import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessTargetDetailsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target_details#id DataAkeylessTargetDetails#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target_details#name DataAkeylessTargetDetails#name}
    */
    readonly name: string;
    /**
    * Include all target versions in reply
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target_details#show_versions DataAkeylessTargetDetails#show_versions}
    */
    readonly showVersions?: boolean | cdktf.IResolvable;
    /**
    * Target version
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target_details#target_version DataAkeylessTargetDetails#target_version}
    */
    readonly targetVersion?: number;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target_details akeyless_target_details}
*/
export declare class DataAkeylessTargetDetails extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_target_details";
    /**
    * Generates CDKTF code for importing a DataAkeylessTargetDetails resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessTargetDetails to import
    * @param importFromId The id of the existing DataAkeylessTargetDetails that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target_details#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessTargetDetails to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target_details akeyless_target_details} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessTargetDetailsConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessTargetDetailsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _showVersions?;
    get showVersions(): boolean | cdktf.IResolvable;
    set showVersions(value: boolean | cdktf.IResolvable);
    resetShowVersions(): void;
    get showVersionsInput(): boolean | cdktf.IResolvable | undefined;
    private _targetVersion?;
    get targetVersion(): number;
    set targetVersion(value: number);
    resetTargetVersion(): void;
    get targetVersionInput(): number | undefined;
    private _value;
    get value(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
