import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DfcKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * DFCKey type; options: [AES128GCM, AES256GCM, AES128SIV, AES256SIV, AES128CBC, AES256CBC, RSA1024, RSA2048, RSA3072, RSA4096]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#alg DfcKey#alg}
    */
    readonly alg: string;
    /**
    * Whether to automatically rotate every rotation_interval days, or disable existing automatic rotation [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#auto_rotate DfcKey#auto_rotate}
    */
    readonly autoRotate?: string;
    /**
    * PEM Certificate in a Base64 format. Used for updating RSA keys' certificates
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#cert_data_base64 DfcKey#cert_data_base64}
    */
    readonly certDataBase64?: string;
    /**
    * Common name for the generated certificate. Relevant only for generate-self-signed-certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#certificate_common_name DfcKey#certificate_common_name}
    */
    readonly certificateCommonName?: string;
    /**
    * Country name for the generated certificate. Relevant only for generate-self-signed-certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#certificate_country DfcKey#certificate_country}
    */
    readonly certificateCountry?: string;
    /**
    * The format of the returned certificate [pem/der]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#certificate_format DfcKey#certificate_format}
    */
    readonly certificateFormat?: string;
    /**
    * Locality for the generated certificate. Relevant only for generate-self-signed-certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#certificate_locality DfcKey#certificate_locality}
    */
    readonly certificateLocality?: string;
    /**
    * Organization name for the generated certificate. Relevant only for generate-self-signed-certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#certificate_organization DfcKey#certificate_organization}
    */
    readonly certificateOrganization?: string;
    /**
    * Province name for the generated certificate. Relevant only for generate-self-signed-certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#certificate_province DfcKey#certificate_province}
    */
    readonly certificateProvince?: string;
    /**
    * TTL in days for the generated certificate. Required only for generate-self-signed-certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#certificate_ttl DfcKey#certificate_ttl}
    */
    readonly certificateTtl?: number;
    /**
    * The csr config data in base64 encoding
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#conf_file_data DfcKey#conf_file_data}
    */
    readonly confFileData?: string;
    /**
    * The customer fragment ID that will be used to create the DFC key (if empty, the key will be created independently of a customer fragment)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#customer_frg_id DfcKey#customer_frg_id}
    */
    readonly customerFrgId?: string;
    /**
    * Protection from accidental deletion of this item, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#delete_protection DfcKey#delete_protection}
    */
    readonly deleteProtection?: boolean | cdktf.IResolvable;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#description DfcKey#description}
    */
    readonly description?: string;
    /**
    * How many days before the expiration of the certificate would you like to be notified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#expiration_event_in DfcKey#expiration_event_in}
    */
    readonly expirationEventIn?: string[];
    /**
    * Whether to generate a self signed certificate with the key. If set, certificate-ttl must be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#generate_self_signed_certificate DfcKey#generate_self_signed_certificate}
    */
    readonly generateSelfSignedCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#id DfcKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * DFCKey name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#name DfcKey#name}
    */
    readonly name: string;
    /**
    * How many days before the rotation of the item would you like to be notified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#rotation_event_in DfcKey#rotation_event_in}
    */
    readonly rotationEventIn?: string[];
    /**
    * The number of days to wait between every automatic rotation (7-365)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#rotation_interval DfcKey#rotation_interval}
    */
    readonly rotationInterval?: string;
    /**
    * The number of fragments that the item will be split into (not includes customer fragment)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#split_level DfcKey#split_level}
    */
    readonly splitLevel?: number;
    /**
    * List of the tags attached to this DFC key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#tags DfcKey#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key akeyless_dfc_key}
*/
export declare class DfcKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dfc_key";
    /**
    * Generates CDKTF code for importing a DfcKey resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DfcKey to import
    * @param importFromId The id of the existing DfcKey that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DfcKey to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dfc_key akeyless_dfc_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DfcKeyConfig
    */
    constructor(scope: Construct, id: string, config: DfcKeyConfig);
    private _alg?;
    get alg(): string;
    set alg(value: string);
    get algInput(): string | undefined;
    private _autoRotate?;
    get autoRotate(): string;
    set autoRotate(value: string);
    resetAutoRotate(): void;
    get autoRotateInput(): string | undefined;
    private _certDataBase64?;
    get certDataBase64(): string;
    set certDataBase64(value: string);
    resetCertDataBase64(): void;
    get certDataBase64Input(): string | undefined;
    private _certificateCommonName?;
    get certificateCommonName(): string;
    set certificateCommonName(value: string);
    resetCertificateCommonName(): void;
    get certificateCommonNameInput(): string | undefined;
    private _certificateCountry?;
    get certificateCountry(): string;
    set certificateCountry(value: string);
    resetCertificateCountry(): void;
    get certificateCountryInput(): string | undefined;
    private _certificateFormat?;
    get certificateFormat(): string;
    set certificateFormat(value: string);
    resetCertificateFormat(): void;
    get certificateFormatInput(): string | undefined;
    private _certificateLocality?;
    get certificateLocality(): string;
    set certificateLocality(value: string);
    resetCertificateLocality(): void;
    get certificateLocalityInput(): string | undefined;
    private _certificateOrganization?;
    get certificateOrganization(): string;
    set certificateOrganization(value: string);
    resetCertificateOrganization(): void;
    get certificateOrganizationInput(): string | undefined;
    private _certificateProvince?;
    get certificateProvince(): string;
    set certificateProvince(value: string);
    resetCertificateProvince(): void;
    get certificateProvinceInput(): string | undefined;
    private _certificateTtl?;
    get certificateTtl(): number;
    set certificateTtl(value: number);
    resetCertificateTtl(): void;
    get certificateTtlInput(): number | undefined;
    private _confFileData?;
    get confFileData(): string;
    set confFileData(value: string);
    resetConfFileData(): void;
    get confFileDataInput(): string | undefined;
    private _customerFrgId?;
    get customerFrgId(): string;
    set customerFrgId(value: string);
    resetCustomerFrgId(): void;
    get customerFrgIdInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): boolean | cdktf.IResolvable;
    set deleteProtection(value: boolean | cdktf.IResolvable);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expirationEventIn?;
    get expirationEventIn(): string[];
    set expirationEventIn(value: string[]);
    resetExpirationEventIn(): void;
    get expirationEventInInput(): string[] | undefined;
    private _generateSelfSignedCertificate?;
    get generateSelfSignedCertificate(): boolean | cdktf.IResolvable;
    set generateSelfSignedCertificate(value: boolean | cdktf.IResolvable);
    resetGenerateSelfSignedCertificate(): void;
    get generateSelfSignedCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rotationEventIn?;
    get rotationEventIn(): string[];
    set rotationEventIn(value: string[]);
    resetRotationEventIn(): void;
    get rotationEventInInput(): string[] | undefined;
    private _rotationInterval?;
    get rotationInterval(): string;
    set rotationInterval(value: string);
    resetRotationInterval(): void;
    get rotationIntervalInput(): string | undefined;
    private _splitLevel?;
    get splitLevel(): number;
    set splitLevel(value: number);
    resetSplitLevel(): void;
    get splitLevelInput(): number | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
