import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The types of credentials to retrieve from AWS. Options:[iam_user,assume_role]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#access_mode DynamicSecretAws#access_mode}
    */
    readonly accessMode?: string;
    /**
    * Access Key ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#aws_access_key_id DynamicSecretAws#aws_access_key_id}
    */
    readonly awsAccessKeyId?: string;
    /**
    * Access Secret Key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#aws_access_secret_key DynamicSecretAws#aws_access_secret_key}
    */
    readonly awsAccessSecretKey?: string;
    /**
    * AWS Role ARNs to be use in the Assume Role operation. Multiple values should be separated by comma
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#aws_role_arns DynamicSecretAws#aws_role_arns}
    */
    readonly awsRoleArns?: string;
    /**
    * Enable AWS User console access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#aws_user_console_access DynamicSecretAws#aws_user_console_access}
    */
    readonly awsUserConsoleAccess?: boolean | cdktf.IResolvable;
    /**
    * UserGroup name(s). Multiple values should be separated by comma
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#aws_user_groups DynamicSecretAws#aws_user_groups}
    */
    readonly awsUserGroups?: string;
    /**
    * Policy ARN(s). Multiple values should be separated by comma
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#aws_user_policies DynamicSecretAws#aws_user_policies}
    */
    readonly awsUserPolicies?: string;
    /**
    * Enable AWS User programmatic access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#aws_user_programmatic_access DynamicSecretAws#aws_user_programmatic_access}
    */
    readonly awsUserProgrammaticAccess?: boolean | cdktf.IResolvable;
    /**
    * Customize how temporary usernames are generated using go template
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#custom_username_template DynamicSecretAws#custom_username_template}
    */
    readonly customUsernameTemplate?: string;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#encryption_key_name DynamicSecretAws#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#id DynamicSecretAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#name DynamicSecretAws#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#password_length DynamicSecretAws#password_length}
    */
    readonly passwordLength?: string;
    /**
    * Region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#region DynamicSecretAws#region}
    */
    readonly region?: string;
    /**
    * The aws account id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#secure_access_aws_account_id DynamicSecretAws#secure_access_aws_account_id}
    */
    readonly secureAccessAwsAccountId?: string;
    /**
    * The aws native cli
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#secure_access_aws_native_cli DynamicSecretAws#secure_access_aws_native_cli}
    */
    readonly secureAccessAwsNativeCli?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#secure_access_aws_region DynamicSecretAws#secure_access_aws_region}
    */
    readonly secureAccessAwsRegion?: string;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#secure_access_bastion_issuer DynamicSecretAws#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#secure_access_enable DynamicSecretAws#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#secure_access_url DynamicSecretAws#secure_access_url}
    */
    readonly secureAccessUrl?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#secure_access_web DynamicSecretAws#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * Secure browser via Akeyless Web Access Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#secure_access_web_browsing DynamicSecretAws#secure_access_web_browsing}
    */
    readonly secureAccessWebBrowsing?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#tags DynamicSecretAws#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#target_name DynamicSecretAws#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#user_ttl DynamicSecretAws#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws akeyless_dynamic_secret_aws}
*/
export declare class DynamicSecretAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_aws";
    /**
    * Generates CDKTF code for importing a DynamicSecretAws resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretAws to import
    * @param importFromId The id of the existing DynamicSecretAws that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretAws to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_aws akeyless_dynamic_secret_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretAwsConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretAwsConfig);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    resetAccessMode(): void;
    get accessModeInput(): string | undefined;
    private _awsAccessKeyId?;
    get awsAccessKeyId(): string;
    set awsAccessKeyId(value: string);
    resetAwsAccessKeyId(): void;
    get awsAccessKeyIdInput(): string | undefined;
    private _awsAccessSecretKey?;
    get awsAccessSecretKey(): string;
    set awsAccessSecretKey(value: string);
    resetAwsAccessSecretKey(): void;
    get awsAccessSecretKeyInput(): string | undefined;
    private _awsRoleArns?;
    get awsRoleArns(): string;
    set awsRoleArns(value: string);
    resetAwsRoleArns(): void;
    get awsRoleArnsInput(): string | undefined;
    private _awsUserConsoleAccess?;
    get awsUserConsoleAccess(): boolean | cdktf.IResolvable;
    set awsUserConsoleAccess(value: boolean | cdktf.IResolvable);
    resetAwsUserConsoleAccess(): void;
    get awsUserConsoleAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _awsUserGroups?;
    get awsUserGroups(): string;
    set awsUserGroups(value: string);
    resetAwsUserGroups(): void;
    get awsUserGroupsInput(): string | undefined;
    private _awsUserPolicies?;
    get awsUserPolicies(): string;
    set awsUserPolicies(value: string);
    resetAwsUserPolicies(): void;
    get awsUserPoliciesInput(): string | undefined;
    private _awsUserProgrammaticAccess?;
    get awsUserProgrammaticAccess(): boolean | cdktf.IResolvable;
    set awsUserProgrammaticAccess(value: boolean | cdktf.IResolvable);
    resetAwsUserProgrammaticAccess(): void;
    get awsUserProgrammaticAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _customUsernameTemplate?;
    get customUsernameTemplate(): string;
    set customUsernameTemplate(value: string);
    resetCustomUsernameTemplate(): void;
    get customUsernameTemplateInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secureAccessAwsAccountId?;
    get secureAccessAwsAccountId(): string;
    set secureAccessAwsAccountId(value: string);
    resetSecureAccessAwsAccountId(): void;
    get secureAccessAwsAccountIdInput(): string | undefined;
    private _secureAccessAwsNativeCli?;
    get secureAccessAwsNativeCli(): boolean | cdktf.IResolvable;
    set secureAccessAwsNativeCli(value: boolean | cdktf.IResolvable);
    resetSecureAccessAwsNativeCli(): void;
    get secureAccessAwsNativeCliInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessAwsRegion?;
    get secureAccessAwsRegion(): string;
    set secureAccessAwsRegion(value: string);
    resetSecureAccessAwsRegion(): void;
    get secureAccessAwsRegionInput(): string | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessUrl?;
    get secureAccessUrl(): string;
    set secureAccessUrl(value: string);
    resetSecureAccessUrl(): void;
    get secureAccessUrlInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessWebBrowsing?;
    get secureAccessWebBrowsing(): boolean | cdktf.IResolvable;
    set secureAccessWebBrowsing(value: boolean | cdktf.IResolvable);
    resetSecureAccessWebBrowsing(): void;
    get secureAccessWebBrowsingInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
