import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Azure App Object ID (required if selected programmatic access)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#app_obj_id DynamicSecretAzure#app_obj_id}
    */
    readonly appObjId?: string;
    /**
    * Azure Client ID (Application ID)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#azure_client_id DynamicSecretAzure#azure_client_id}
    */
    readonly azureClientId?: string;
    /**
    * Azure AD Client Secret
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#azure_client_secret DynamicSecretAzure#azure_client_secret}
    */
    readonly azureClientSecret?: string;
    /**
    * Azure Tenant ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#azure_tenant_id DynamicSecretAzure#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * Customize how temporary usernames are generated using go template
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#custom_username_template DynamicSecretAzure#custom_username_template}
    */
    readonly customUsernameTemplate?: string;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#encryption_key_name DynamicSecretAzure#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#id DynamicSecretAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#name DynamicSecretAzure#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#password_length DynamicSecretAzure#password_length}
    */
    readonly passwordLength?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#secure_access_enable DynamicSecretAzure#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#secure_access_url DynamicSecretAzure#secure_access_url}
    */
    readonly secureAccessUrl?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#secure_access_web DynamicSecretAzure#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * Secure browser via Akeyless Web Access Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#secure_access_web_browsing DynamicSecretAzure#secure_access_web_browsing}
    */
    readonly secureAccessWebBrowsing?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: --tag Tag1 --tag Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#tags DynamicSecretAzure#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#target_name DynamicSecretAzure#target_name}
    */
    readonly targetName?: string;
    /**
    * Azure AD User Group Object ID (required if selected Portal access)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#user_group_obj_id DynamicSecretAzure#user_group_obj_id}
    */
    readonly userGroupObjId?: string;
    /**
    * Enable Azure AD user portal access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#user_portal_access DynamicSecretAzure#user_portal_access}
    */
    readonly userPortalAccess?: boolean | cdktf.IResolvable;
    /**
    * Azure AD User Principal Name (required if selected Portal access)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#user_principal_name DynamicSecretAzure#user_principal_name}
    */
    readonly userPrincipalName?: string;
    /**
    * Enable Azure AD user programmatic access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#user_programmatic_access DynamicSecretAzure#user_programmatic_access}
    */
    readonly userProgrammaticAccess?: boolean | cdktf.IResolvable;
    /**
    * Azure AD User Role Template ID (required if selected Portal access)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#user_role_template_id DynamicSecretAzure#user_role_template_id}
    */
    readonly userRoleTemplateId?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#user_ttl DynamicSecretAzure#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure akeyless_dynamic_secret_azure}
*/
export declare class DynamicSecretAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_azure";
    /**
    * Generates CDKTF code for importing a DynamicSecretAzure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretAzure to import
    * @param importFromId The id of the existing DynamicSecretAzure that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretAzure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_azure akeyless_dynamic_secret_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretAzureConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretAzureConfig);
    private _appObjId?;
    get appObjId(): string;
    set appObjId(value: string);
    resetAppObjId(): void;
    get appObjIdInput(): string | undefined;
    private _azureClientId?;
    get azureClientId(): string;
    set azureClientId(value: string);
    resetAzureClientId(): void;
    get azureClientIdInput(): string | undefined;
    private _azureClientSecret?;
    get azureClientSecret(): string;
    set azureClientSecret(value: string);
    resetAzureClientSecret(): void;
    get azureClientSecretInput(): string | undefined;
    private _azureTenantId?;
    get azureTenantId(): string;
    set azureTenantId(value: string);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _customUsernameTemplate?;
    get customUsernameTemplate(): string;
    set customUsernameTemplate(value: string);
    resetCustomUsernameTemplate(): void;
    get customUsernameTemplateInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessUrl?;
    get secureAccessUrl(): string;
    set secureAccessUrl(value: string);
    resetSecureAccessUrl(): void;
    get secureAccessUrlInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessWebBrowsing?;
    get secureAccessWebBrowsing(): boolean | cdktf.IResolvable;
    set secureAccessWebBrowsing(value: boolean | cdktf.IResolvable);
    resetSecureAccessWebBrowsing(): void;
    get secureAccessWebBrowsingInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userGroupObjId?;
    get userGroupObjId(): string;
    set userGroupObjId(value: string);
    resetUserGroupObjId(): void;
    get userGroupObjIdInput(): string | undefined;
    private _userPortalAccess?;
    get userPortalAccess(): boolean | cdktf.IResolvable;
    set userPortalAccess(value: boolean | cdktf.IResolvable);
    resetUserPortalAccess(): void;
    get userPortalAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _userPrincipalName?;
    get userPrincipalName(): string;
    set userPrincipalName(value: string);
    resetUserPrincipalName(): void;
    get userPrincipalNameInput(): string | undefined;
    private _userProgrammaticAccess?;
    get userProgrammaticAccess(): boolean | cdktf.IResolvable;
    set userProgrammaticAccess(value: boolean | cdktf.IResolvable);
    resetUserProgrammaticAccess(): void;
    get userProgrammaticAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _userRoleTemplateId?;
    get userRoleTemplateId(): string;
    set userRoleTemplateId(value: string);
    resetUserRoleTemplateId(): void;
    get userRoleTemplateIdInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
