import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretEksConfig extends cdktf.TerraformMetaArguments {
    /**
    * EKS Access Key ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#eks_access_key_id DynamicSecretEks#eks_access_key_id}
    */
    readonly eksAccessKeyId?: string;
    /**
    * Role ARN. Role to assume when connecting to the EKS cluster
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#eks_assume_role DynamicSecretEks#eks_assume_role}
    */
    readonly eksAssumeRole?: string;
    /**
    * EKS Cluster certificate. Base 64 encoded certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#eks_cluster_ca_cert DynamicSecretEks#eks_cluster_ca_cert}
    */
    readonly eksClusterCaCert?: string;
    /**
    * EKS Cluster endpoint. https:// , <DNS / IP> of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#eks_cluster_endpoint DynamicSecretEks#eks_cluster_endpoint}
    */
    readonly eksClusterEndpoint?: string;
    /**
    * EKS cluster name. Must match the EKS cluster name you want to connect to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#eks_cluster_name DynamicSecretEks#eks_cluster_name}
    */
    readonly eksClusterName?: string;
    /**
    * EKS Region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#eks_region DynamicSecretEks#eks_region}
    */
    readonly eksRegion?: string;
    /**
    * EKS Secret Access Key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#eks_secret_access_key DynamicSecretEks#eks_secret_access_key}
    */
    readonly eksSecretAccessKey?: string;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#encryption_key_name DynamicSecretEks#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#id DynamicSecretEks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#name DynamicSecretEks#name}
    */
    readonly name: string;
    /**
    * Enable Port forwarding while using CLI access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#secure_access_allow_port_forwading DynamicSecretEks#secure_access_allow_port_forwading}
    */
    readonly secureAccessAllowPortForwading?: boolean | cdktf.IResolvable;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#secure_access_bastion_issuer DynamicSecretEks#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * The K8s cluster endpoint URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#secure_access_cluster_endpoint DynamicSecretEks#secure_access_cluster_endpoint}
    */
    readonly secureAccessClusterEndpoint?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#secure_access_enable DynamicSecretEks#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#secure_access_web DynamicSecretEks#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#tags DynamicSecretEks#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#target_name DynamicSecretEks#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#user_ttl DynamicSecretEks#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks akeyless_dynamic_secret_eks}
*/
export declare class DynamicSecretEks extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_eks";
    /**
    * Generates CDKTF code for importing a DynamicSecretEks resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretEks to import
    * @param importFromId The id of the existing DynamicSecretEks that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretEks to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_eks akeyless_dynamic_secret_eks} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretEksConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretEksConfig);
    private _eksAccessKeyId?;
    get eksAccessKeyId(): string;
    set eksAccessKeyId(value: string);
    resetEksAccessKeyId(): void;
    get eksAccessKeyIdInput(): string | undefined;
    private _eksAssumeRole?;
    get eksAssumeRole(): string;
    set eksAssumeRole(value: string);
    resetEksAssumeRole(): void;
    get eksAssumeRoleInput(): string | undefined;
    private _eksClusterCaCert?;
    get eksClusterCaCert(): string;
    set eksClusterCaCert(value: string);
    resetEksClusterCaCert(): void;
    get eksClusterCaCertInput(): string | undefined;
    private _eksClusterEndpoint?;
    get eksClusterEndpoint(): string;
    set eksClusterEndpoint(value: string);
    resetEksClusterEndpoint(): void;
    get eksClusterEndpointInput(): string | undefined;
    private _eksClusterName?;
    get eksClusterName(): string;
    set eksClusterName(value: string);
    resetEksClusterName(): void;
    get eksClusterNameInput(): string | undefined;
    private _eksRegion?;
    get eksRegion(): string;
    set eksRegion(value: string);
    resetEksRegion(): void;
    get eksRegionInput(): string | undefined;
    private _eksSecretAccessKey?;
    get eksSecretAccessKey(): string;
    set eksSecretAccessKey(value: string);
    resetEksSecretAccessKey(): void;
    get eksSecretAccessKeyInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secureAccessAllowPortForwading?;
    get secureAccessAllowPortForwading(): boolean | cdktf.IResolvable;
    set secureAccessAllowPortForwading(value: boolean | cdktf.IResolvable);
    resetSecureAccessAllowPortForwading(): void;
    get secureAccessAllowPortForwadingInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessClusterEndpoint?;
    get secureAccessClusterEndpoint(): string;
    set secureAccessClusterEndpoint(value: string);
    resetSecureAccessClusterEndpoint(): void;
    get secureAccessClusterEndpointInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
