import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretGcpConfig extends cdktf.TerraformMetaArguments {
    /**
    * The type of the GCP dynamic secret, options are [sa, external]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#access_type DynamicSecretGcp#access_type}
    */
    readonly accessType?: string;
    /**
    * Customize how temporary usernames are generated using go template
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#custom_username_template DynamicSecretGcp#custom_username_template}
    */
    readonly customUsernameTemplate?: string;
    /**
    * Protection from accidental deletion of this item, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#delete_protection DynamicSecretGcp#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#encryption_key_name DynamicSecretGcp#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * For externally provided users, denotes the key-name of IdP claim to extract the username from
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#fixed_user_claim_keyname DynamicSecretGcp#fixed_user_claim_keyname}
    */
    readonly fixedUserClaimKeyname?: string;
    /**
    * Credentials type, options are [token, key]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#gcp_cred_type DynamicSecretGcp#gcp_cred_type}
    */
    readonly gcpCredType?: string;
    /**
    * Base64-encoded service account private key text
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#gcp_key DynamicSecretGcp#gcp_key}
    */
    readonly gcpKey?: string;
    /**
    * Service account key algorithm, e.g. KEY_ALG_RSA_1024
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#gcp_key_algo DynamicSecretGcp#gcp_key_algo}
    */
    readonly gcpKeyAlgo?: string;
    /**
    * GCP service account email
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#gcp_sa_email DynamicSecretGcp#gcp_sa_email}
    */
    readonly gcpSaEmail?: string;
    /**
    * Access token scopes list, e.g. scope1,scope2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#gcp_token_scopes DynamicSecretGcp#gcp_token_scopes}
    */
    readonly gcpTokenScopes?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#id DynamicSecretGcp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#name DynamicSecretGcp#name}
    */
    readonly name: string;
    /**
    * GCP Project ID override for dynamic secret operations
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#project_id DynamicSecretGcp#project_id}
    */
    readonly projectId?: string;
    /**
    * Role binding definitions in json format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#role_binding DynamicSecretGcp#role_binding}
    */
    readonly roleBinding?: string;
    /**
    * Comma-separated list of GCP roles to assign to the user
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#role_names DynamicSecretGcp#role_names}
    */
    readonly roleNames?: string;
    /**
    * The type of the gcp dynamic secret. Options[fixed, dynamic]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#service_account_type DynamicSecretGcp#service_account_type}
    */
    readonly serviceAccountType?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: --tag Tag1 --tag Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#tags DynamicSecretGcp#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#target_name DynamicSecretGcp#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL (<=60m for access token)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#user_ttl DynamicSecretGcp#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp akeyless_dynamic_secret_gcp}
*/
export declare class DynamicSecretGcp extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_gcp";
    /**
    * Generates CDKTF code for importing a DynamicSecretGcp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretGcp to import
    * @param importFromId The id of the existing DynamicSecretGcp that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretGcp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gcp akeyless_dynamic_secret_gcp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretGcpConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretGcpConfig);
    private _accessType?;
    get accessType(): string;
    set accessType(value: string);
    resetAccessType(): void;
    get accessTypeInput(): string | undefined;
    private _customUsernameTemplate?;
    get customUsernameTemplate(): string;
    set customUsernameTemplate(value: string);
    resetCustomUsernameTemplate(): void;
    get customUsernameTemplateInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _fixedUserClaimKeyname?;
    get fixedUserClaimKeyname(): string;
    set fixedUserClaimKeyname(value: string);
    resetFixedUserClaimKeyname(): void;
    get fixedUserClaimKeynameInput(): string | undefined;
    private _gcpCredType?;
    get gcpCredType(): string;
    set gcpCredType(value: string);
    resetGcpCredType(): void;
    get gcpCredTypeInput(): string | undefined;
    private _gcpKey?;
    get gcpKey(): string;
    set gcpKey(value: string);
    resetGcpKey(): void;
    get gcpKeyInput(): string | undefined;
    private _gcpKeyAlgo?;
    get gcpKeyAlgo(): string;
    set gcpKeyAlgo(value: string);
    resetGcpKeyAlgo(): void;
    get gcpKeyAlgoInput(): string | undefined;
    private _gcpSaEmail?;
    get gcpSaEmail(): string;
    set gcpSaEmail(value: string);
    resetGcpSaEmail(): void;
    get gcpSaEmailInput(): string | undefined;
    private _gcpTokenScopes?;
    get gcpTokenScopes(): string;
    set gcpTokenScopes(value: string);
    resetGcpTokenScopes(): void;
    get gcpTokenScopesInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _roleBinding?;
    get roleBinding(): string;
    set roleBinding(value: string);
    resetRoleBinding(): void;
    get roleBindingInput(): string | undefined;
    private _roleNames?;
    get roleNames(): string;
    set roleNames(value: string);
    resetRoleNames(): void;
    get roleNamesInput(): string | undefined;
    private _serviceAccountType?;
    get serviceAccountType(): string;
    set serviceAccountType(value: string);
    resetServiceAccountType(): void;
    get serviceAccountTypeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
