import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretGitlabConfig extends cdktf.TerraformMetaArguments {
    /**
    * Protection from accidental deletion of this item, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#delete_protection DynamicSecretGitlab#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#description DynamicSecretGitlab#description}
    */
    readonly description?: string;
    /**
    * Gitlab access token
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#gitlab_access_token DynamicSecretGitlab#gitlab_access_token}
    */
    readonly gitlabAccessToken?: string;
    /**
    * Gitlab access token type [project,group]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#gitlab_access_type DynamicSecretGitlab#gitlab_access_type}
    */
    readonly gitlabAccessType?: string;
    /**
    * Gitlab tls certificate (base64 encoded)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#gitlab_certificate DynamicSecretGitlab#gitlab_certificate}
    */
    readonly gitlabCertificate?: string;
    /**
    * Gitlab role
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#gitlab_role DynamicSecretGitlab#gitlab_role}
    */
    readonly gitlabRole?: string;
    /**
    * Comma-separated list of access token scopes to grant
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#gitlab_token_scopes DynamicSecretGitlab#gitlab_token_scopes}
    */
    readonly gitlabTokenScopes?: string;
    /**
    * Gitlab base url
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#gitlab_url DynamicSecretGitlab#gitlab_url}
    */
    readonly gitlabUrl?: string;
    /**
    * Gitlab group name, required for access-type=group
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#group_name DynamicSecretGitlab#group_name}
    */
    readonly groupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#id DynamicSecretGitlab#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Gitlab project name, required for access-type=project
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#installation_organization DynamicSecretGitlab#installation_organization}
    */
    readonly installationOrganization?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#name DynamicSecretGitlab#name}
    */
    readonly name: string;
    /**
    * A comma-separated list of tags attached to this secret
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#tags DynamicSecretGitlab#tags}
    */
    readonly tags?: string[];
    /**
    * Name of an existing target
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#target_name DynamicSecretGitlab#target_name}
    */
    readonly targetName?: string;
    /**
    * Access Token TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#ttl DynamicSecretGitlab#ttl}
    */
    readonly ttl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab akeyless_dynamic_secret_gitlab}
*/
export declare class DynamicSecretGitlab extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_gitlab";
    /**
    * Generates CDKTF code for importing a DynamicSecretGitlab resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretGitlab to import
    * @param importFromId The id of the existing DynamicSecretGitlab that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretGitlab to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gitlab akeyless_dynamic_secret_gitlab} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretGitlabConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretGitlabConfig);
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _gitlabAccessToken?;
    get gitlabAccessToken(): string;
    set gitlabAccessToken(value: string);
    resetGitlabAccessToken(): void;
    get gitlabAccessTokenInput(): string | undefined;
    private _gitlabAccessType?;
    get gitlabAccessType(): string;
    set gitlabAccessType(value: string);
    resetGitlabAccessType(): void;
    get gitlabAccessTypeInput(): string | undefined;
    private _gitlabCertificate?;
    get gitlabCertificate(): string;
    set gitlabCertificate(value: string);
    resetGitlabCertificate(): void;
    get gitlabCertificateInput(): string | undefined;
    private _gitlabRole?;
    get gitlabRole(): string;
    set gitlabRole(value: string);
    resetGitlabRole(): void;
    get gitlabRoleInput(): string | undefined;
    private _gitlabTokenScopes?;
    get gitlabTokenScopes(): string;
    set gitlabTokenScopes(value: string);
    resetGitlabTokenScopes(): void;
    get gitlabTokenScopesInput(): string | undefined;
    private _gitlabUrl?;
    get gitlabUrl(): string;
    set gitlabUrl(value: string);
    resetGitlabUrl(): void;
    get gitlabUrlInput(): string | undefined;
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    resetGroupName(): void;
    get groupNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _installationOrganization?;
    get installationOrganization(): string;
    set installationOrganization(value: string);
    resetInstallationOrganization(): void;
    get installationOrganizationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
