import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretMssqlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Customize how temporary usernames are generated using go template
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#custom_username_template DynamicSecretMssql#custom_username_template}
    */
    readonly customUsernameTemplate?: string;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#encryption_key_name DynamicSecretMssql#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#id DynamicSecretMssql#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * MSSQL Server Creation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#mssql_create_statements DynamicSecretMssql#mssql_create_statements}
    */
    readonly mssqlCreateStatements?: string;
    /**
    * MSSQL Server DB Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#mssql_dbname DynamicSecretMssql#mssql_dbname}
    */
    readonly mssqlDbname?: string;
    /**
    * MS SQL Server host name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#mssql_host DynamicSecretMssql#mssql_host}
    */
    readonly mssqlHost?: string;
    /**
    * MS SQL Server password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#mssql_password DynamicSecretMssql#mssql_password}
    */
    readonly mssqlPassword?: string;
    /**
    * MS SQL Server port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#mssql_port DynamicSecretMssql#mssql_port}
    */
    readonly mssqlPort?: string;
    /**
    * MSSQL Server Revocation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#mssql_revocation_statements DynamicSecretMssql#mssql_revocation_statements}
    */
    readonly mssqlRevocationStatements?: string;
    /**
    * MS SQL Server user
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#mssql_username DynamicSecretMssql#mssql_username}
    */
    readonly mssqlUsername?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#name DynamicSecretMssql#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#password_length DynamicSecretMssql#password_length}
    */
    readonly passwordLength?: string;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#secure_access_bastion_issuer DynamicSecretMssql#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * The DB Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#secure_access_db_name DynamicSecretMssql#secure_access_db_name}
    */
    readonly secureAccessDbName?: string;
    /**
    * The db schema
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#secure_access_db_schema DynamicSecretMssql#secure_access_db_schema}
    */
    readonly secureAccessDbSchema?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#secure_access_enable DynamicSecretMssql#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Target DB servers for connections., For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#secure_access_host DynamicSecretMssql#secure_access_host}
    */
    readonly secureAccessHost?: string[];
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#secure_access_web DynamicSecretMssql#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#tags DynamicSecretMssql#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#target_name DynamicSecretMssql#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#user_ttl DynamicSecretMssql#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql akeyless_dynamic_secret_mssql}
*/
export declare class DynamicSecretMssql extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_mssql";
    /**
    * Generates CDKTF code for importing a DynamicSecretMssql resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretMssql to import
    * @param importFromId The id of the existing DynamicSecretMssql that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretMssql to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mssql akeyless_dynamic_secret_mssql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretMssqlConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretMssqlConfig);
    private _customUsernameTemplate?;
    get customUsernameTemplate(): string;
    set customUsernameTemplate(value: string);
    resetCustomUsernameTemplate(): void;
    get customUsernameTemplateInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mssqlCreateStatements?;
    get mssqlCreateStatements(): string;
    set mssqlCreateStatements(value: string);
    resetMssqlCreateStatements(): void;
    get mssqlCreateStatementsInput(): string | undefined;
    private _mssqlDbname?;
    get mssqlDbname(): string;
    set mssqlDbname(value: string);
    resetMssqlDbname(): void;
    get mssqlDbnameInput(): string | undefined;
    private _mssqlHost?;
    get mssqlHost(): string;
    set mssqlHost(value: string);
    resetMssqlHost(): void;
    get mssqlHostInput(): string | undefined;
    private _mssqlPassword?;
    get mssqlPassword(): string;
    set mssqlPassword(value: string);
    resetMssqlPassword(): void;
    get mssqlPasswordInput(): string | undefined;
    private _mssqlPort?;
    get mssqlPort(): string;
    set mssqlPort(value: string);
    resetMssqlPort(): void;
    get mssqlPortInput(): string | undefined;
    private _mssqlRevocationStatements?;
    get mssqlRevocationStatements(): string;
    set mssqlRevocationStatements(value: string);
    resetMssqlRevocationStatements(): void;
    get mssqlRevocationStatementsInput(): string | undefined;
    private _mssqlUsername?;
    get mssqlUsername(): string;
    set mssqlUsername(value: string);
    resetMssqlUsername(): void;
    get mssqlUsernameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessDbName?;
    get secureAccessDbName(): string;
    set secureAccessDbName(value: string);
    resetSecureAccessDbName(): void;
    get secureAccessDbNameInput(): string | undefined;
    private _secureAccessDbSchema?;
    get secureAccessDbSchema(): string;
    set secureAccessDbSchema(value: string);
    resetSecureAccessDbSchema(): void;
    get secureAccessDbSchemaInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessHost?;
    get secureAccessHost(): string[];
    set secureAccessHost(value: string[]);
    resetSecureAccessHost(): void;
    get secureAccessHostInput(): string[] | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
