import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretOracleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Customize how temporary usernames are generated using go template
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#custom_username_template DynamicSecretOracle#custom_username_template}
    */
    readonly customUsernameTemplate?: string;
    /**
    * the set of root certificate authorities in base64 encoding that clients use when verifying server certificates
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#db_server_certificates DynamicSecretOracle#db_server_certificates}
    */
    readonly dbServerCertificates?: string;
    /**
    * Server name is used to verify the hostname on the returned certificates unless InsecureSkipVerify is given. It is also included in the client's handshake to support virtual hosting unless it is an IP address
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#db_server_name DynamicSecretOracle#db_server_name}
    */
    readonly dbServerName?: string;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#encryption_key_name DynamicSecretOracle#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#id DynamicSecretOracle#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#name DynamicSecretOracle#name}
    */
    readonly name: string;
    /**
    * Oracle Creation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#oracle_creation_statements DynamicSecretOracle#oracle_creation_statements}
    */
    readonly oracleCreationStatements?: string;
    /**
    * Oracle host name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#oracle_host DynamicSecretOracle#oracle_host}
    */
    readonly oracleHost?: string;
    /**
    * Oracle password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#oracle_password DynamicSecretOracle#oracle_password}
    */
    readonly oraclePassword?: string;
    /**
    * Oracle port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#oracle_port DynamicSecretOracle#oracle_port}
    */
    readonly oraclePort?: string;
    /**
    * Oracle Revocation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#oracle_revocation_statements DynamicSecretOracle#oracle_revocation_statements}
    */
    readonly oracleRevocationStatements?: string;
    /**
    * Oracle service name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#oracle_service_name DynamicSecretOracle#oracle_service_name}
    */
    readonly oracleServiceName?: string;
    /**
    * Oracle user
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#oracle_username DynamicSecretOracle#oracle_username}
    */
    readonly oracleUsername?: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#password_length DynamicSecretOracle#password_length}
    */
    readonly passwordLength?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#tags DynamicSecretOracle#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#target_name DynamicSecretOracle#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#user_ttl DynamicSecretOracle#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle akeyless_dynamic_secret_oracle}
*/
export declare class DynamicSecretOracle extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_oracle";
    /**
    * Generates CDKTF code for importing a DynamicSecretOracle resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretOracle to import
    * @param importFromId The id of the existing DynamicSecretOracle that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretOracle to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_oracle akeyless_dynamic_secret_oracle} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretOracleConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretOracleConfig);
    private _customUsernameTemplate?;
    get customUsernameTemplate(): string;
    set customUsernameTemplate(value: string);
    resetCustomUsernameTemplate(): void;
    get customUsernameTemplateInput(): string | undefined;
    private _dbServerCertificates?;
    get dbServerCertificates(): string;
    set dbServerCertificates(value: string);
    resetDbServerCertificates(): void;
    get dbServerCertificatesInput(): string | undefined;
    private _dbServerName?;
    get dbServerName(): string;
    set dbServerName(value: string);
    resetDbServerName(): void;
    get dbServerNameInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oracleCreationStatements?;
    get oracleCreationStatements(): string;
    set oracleCreationStatements(value: string);
    resetOracleCreationStatements(): void;
    get oracleCreationStatementsInput(): string | undefined;
    private _oracleHost?;
    get oracleHost(): string;
    set oracleHost(value: string);
    resetOracleHost(): void;
    get oracleHostInput(): string | undefined;
    private _oraclePassword?;
    get oraclePassword(): string;
    set oraclePassword(value: string);
    resetOraclePassword(): void;
    get oraclePasswordInput(): string | undefined;
    private _oraclePort?;
    get oraclePort(): string;
    set oraclePort(value: string);
    resetOraclePort(): void;
    get oraclePortInput(): string | undefined;
    private _oracleRevocationStatements?;
    get oracleRevocationStatements(): string;
    set oracleRevocationStatements(value: string);
    resetOracleRevocationStatements(): void;
    get oracleRevocationStatementsInput(): string | undefined;
    private _oracleServiceName?;
    get oracleServiceName(): string;
    set oracleServiceName(value: string);
    resetOracleServiceName(): void;
    get oracleServiceNameInput(): string | undefined;
    private _oracleUsername?;
    get oracleUsername(): string;
    set oracleUsername(value: string);
    resetOracleUsername(): void;
    get oracleUsernameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
