import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventForwarderEmailConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth Methods event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#auth_methods_event_source_locations EventForwarderEmail#auth_methods_event_source_locations}
    */
    readonly authMethodsEventSourceLocations?: string[];
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#description EventForwarderEmail#description}
    */
    readonly description?: string;
    /**
    * A comma seperated list of email addresses to send event to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#email_to EventForwarderEmail#email_to}
    */
    readonly emailTo?: string;
    /**
    * A comma-separated list of types of events to notify about
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#event_types EventForwarderEmail#event_types}
    */
    readonly eventTypes?: string[];
    /**
    * Rate of periodic runner repetition in hours
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#every EventForwarderEmail#every}
    */
    readonly every?: string;
    /**
    * Gateways event sources to forward events about,for example the relevant Gateways cluster urls,: http://localhost:8000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#gateways_event_source_locations EventForwarderEmail#gateways_event_source_locations}
    */
    readonly gatewaysEventSourceLocations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#id EventForwarderEmail#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set this option to include event errors details [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#include_error EventForwarderEmail#include_error}
    */
    readonly includeError?: string;
    /**
    * Items event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#items_event_source_locations EventForwarderEmail#items_event_source_locations}
    */
    readonly itemsEventSourceLocations?: string[];
    /**
    * Key name. The key will be used to encrypt the Event Forwarder secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#key EventForwarderEmail#key}
    */
    readonly key?: string;
    /**
    * Event Forwarder name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#name EventForwarderEmail#name}
    */
    readonly name: string;
    /**
    * Override Akeyless default URL with your Gateway url (port 18888)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#override_url EventForwarderEmail#override_url}
    */
    readonly overrideUrl?: string;
    /**
    * Event Forwarder runner type [immediate/periodic]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#runner_type EventForwarderEmail#runner_type}
    */
    readonly runnerType?: string;
    /**
    * Targets event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#targets_event_source_locations EventForwarderEmail#targets_event_source_locations}
    */
    readonly targetsEventSourceLocations?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email akeyless_event_forwarder_email}
*/
export declare class EventForwarderEmail extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_event_forwarder_email";
    /**
    * Generates CDKTF code for importing a EventForwarderEmail resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventForwarderEmail to import
    * @param importFromId The id of the existing EventForwarderEmail that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventForwarderEmail to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_email akeyless_event_forwarder_email} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventForwarderEmailConfig
    */
    constructor(scope: Construct, id: string, config: EventForwarderEmailConfig);
    private _authMethodsEventSourceLocations?;
    get authMethodsEventSourceLocations(): string[];
    set authMethodsEventSourceLocations(value: string[]);
    resetAuthMethodsEventSourceLocations(): void;
    get authMethodsEventSourceLocationsInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _emailTo?;
    get emailTo(): string;
    set emailTo(value: string);
    resetEmailTo(): void;
    get emailToInput(): string | undefined;
    private _eventTypes?;
    get eventTypes(): string[];
    set eventTypes(value: string[]);
    resetEventTypes(): void;
    get eventTypesInput(): string[] | undefined;
    private _every?;
    get every(): string;
    set every(value: string);
    resetEvery(): void;
    get everyInput(): string | undefined;
    private _gatewaysEventSourceLocations?;
    get gatewaysEventSourceLocations(): string[];
    set gatewaysEventSourceLocations(value: string[]);
    resetGatewaysEventSourceLocations(): void;
    get gatewaysEventSourceLocationsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeError?;
    get includeError(): string;
    set includeError(value: string);
    resetIncludeError(): void;
    get includeErrorInput(): string | undefined;
    private _itemsEventSourceLocations?;
    get itemsEventSourceLocations(): string[];
    set itemsEventSourceLocations(value: string[]);
    resetItemsEventSourceLocations(): void;
    get itemsEventSourceLocationsInput(): string[] | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _overrideUrl?;
    get overrideUrl(): string;
    set overrideUrl(value: string);
    resetOverrideUrl(): void;
    get overrideUrlInput(): string | undefined;
    private _runnerType?;
    get runnerType(): string;
    set runnerType(value: string);
    resetRunnerType(): void;
    get runnerTypeInput(): string | undefined;
    private _targetsEventSourceLocations?;
    get targetsEventSourceLocations(): string[];
    set targetsEventSourceLocations(value: string[]);
    resetTargetsEventSourceLocations(): void;
    get targetsEventSourceLocationsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
