import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventForwarderServiceNowConfig extends cdktf.TerraformMetaArguments {
    /**
    * Workstation Admin Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#admin_name EventForwarderServiceNow#admin_name}
    */
    readonly adminName?: string;
    /**
    * Workstation Admin Password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#admin_pwd EventForwarderServiceNow#admin_pwd}
    */
    readonly adminPwd?: string;
    /**
    * The RSA Private Key to use when connecting with jwt authentication
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#app_private_key_base64 EventForwarderServiceNow#app_private_key_base64}
    */
    readonly appPrivateKeyBase64?: string;
    /**
    * Auth Methods event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#auth_methods_event_source_locations EventForwarderServiceNow#auth_methods_event_source_locations}
    */
    readonly authMethodsEventSourceLocations?: string[];
    /**
    * The authentication type to use [user-pass/jwt]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#auth_type EventForwarderServiceNow#auth_type}
    */
    readonly authType?: string;
    /**
    * The client ID to use when connecting with jwt authentication
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#client_id EventForwarderServiceNow#client_id}
    */
    readonly clientId?: string;
    /**
    * The client secret to use when connecting with jwt authentication
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#client_secret EventForwarderServiceNow#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#description EventForwarderServiceNow#description}
    */
    readonly description?: string;
    /**
    * A comma-separated list of types of events to notify about
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#event_types EventForwarderServiceNow#event_types}
    */
    readonly eventTypes?: string[];
    /**
    * Rate of periodic runner repetition in hours
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#every EventForwarderServiceNow#every}
    */
    readonly every?: string;
    /**
    * Gateways event sources to forward events about,for example the relevant Gateways cluster urls,: http://localhost:8000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#gateways_event_source_locations EventForwarderServiceNow#gateways_event_source_locations}
    */
    readonly gatewaysEventSourceLocations?: string[];
    /**
    * Workstation Host
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#host EventForwarderServiceNow#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#id EventForwarderServiceNow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Items event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#items_event_source_locations EventForwarderServiceNow#items_event_source_locations}
    */
    readonly itemsEventSourceLocations?: string[];
    /**
    * Key name. The key will be used to encrypt the Event Forwarder secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#key EventForwarderServiceNow#key}
    */
    readonly key?: string;
    /**
    * Event Forwarder name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#name EventForwarderServiceNow#name}
    */
    readonly name: string;
    /**
    * Event Forwarder runner type [immediate/periodic]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#runner_type EventForwarderServiceNow#runner_type}
    */
    readonly runnerType?: string;
    /**
    * Targets event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#targets_event_source_locations EventForwarderServiceNow#targets_event_source_locations}
    */
    readonly targetsEventSourceLocations?: string[];
    /**
    * The user email to identify with when connecting with jwt authentication
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#user_email EventForwarderServiceNow#user_email}
    */
    readonly userEmail?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now akeyless_event_forwarder_service_now}
*/
export declare class EventForwarderServiceNow extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_event_forwarder_service_now";
    /**
    * Generates CDKTF code for importing a EventForwarderServiceNow resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventForwarderServiceNow to import
    * @param importFromId The id of the existing EventForwarderServiceNow that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventForwarderServiceNow to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_service_now akeyless_event_forwarder_service_now} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventForwarderServiceNowConfig
    */
    constructor(scope: Construct, id: string, config: EventForwarderServiceNowConfig);
    private _adminName?;
    get adminName(): string;
    set adminName(value: string);
    resetAdminName(): void;
    get adminNameInput(): string | undefined;
    private _adminPwd?;
    get adminPwd(): string;
    set adminPwd(value: string);
    resetAdminPwd(): void;
    get adminPwdInput(): string | undefined;
    private _appPrivateKeyBase64?;
    get appPrivateKeyBase64(): string;
    set appPrivateKeyBase64(value: string);
    resetAppPrivateKeyBase64(): void;
    get appPrivateKeyBase64Input(): string | undefined;
    private _authMethodsEventSourceLocations?;
    get authMethodsEventSourceLocations(): string[];
    set authMethodsEventSourceLocations(value: string[]);
    resetAuthMethodsEventSourceLocations(): void;
    get authMethodsEventSourceLocationsInput(): string[] | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    resetAuthType(): void;
    get authTypeInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eventTypes?;
    get eventTypes(): string[];
    set eventTypes(value: string[]);
    resetEventTypes(): void;
    get eventTypesInput(): string[] | undefined;
    private _every?;
    get every(): string;
    set every(value: string);
    resetEvery(): void;
    get everyInput(): string | undefined;
    private _gatewaysEventSourceLocations?;
    get gatewaysEventSourceLocations(): string[];
    set gatewaysEventSourceLocations(value: string[]);
    resetGatewaysEventSourceLocations(): void;
    get gatewaysEventSourceLocationsInput(): string[] | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsEventSourceLocations?;
    get itemsEventSourceLocations(): string[];
    set itemsEventSourceLocations(value: string[]);
    resetItemsEventSourceLocations(): void;
    get itemsEventSourceLocationsInput(): string[] | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runnerType?;
    get runnerType(): string;
    set runnerType(value: string);
    resetRunnerType(): void;
    get runnerTypeInput(): string | undefined;
    private _targetsEventSourceLocations?;
    get targetsEventSourceLocations(): string[];
    set targetsEventSourceLocations(value: string[]);
    resetTargetsEventSourceLocations(): void;
    get targetsEventSourceLocationsInput(): string[] | undefined;
    private _userEmail?;
    get userEmail(): string;
    set userEmail(value: string);
    resetUserEmail(): void;
    get userEmailInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
