import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventForwarderWebhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth Methods event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#auth_methods_event_source_locations EventForwarderWebhook#auth_methods_event_source_locations}
    */
    readonly authMethodsEventSourceLocations?: string[];
    /**
    * Base64 encoded Token string relevant for token auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#auth_token EventForwarderWebhook#auth_token}
    */
    readonly authToken?: string;
    /**
    * The Webhook authentication type [user-pass, bearer-token, certificate]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#auth_type EventForwarderWebhook#auth_type}
    */
    readonly authType?: string;
    /**
    * Base64 encoded PEM certificate, relevant for certificate auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#client_cert_data EventForwarderWebhook#client_cert_data}
    */
    readonly clientCertData?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#description EventForwarderWebhook#description}
    */
    readonly description?: string;
    /**
    * A comma-separated list of types of events to notify about
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#event_types EventForwarderWebhook#event_types}
    */
    readonly eventTypes?: string[];
    /**
    * Rate of periodic runner repetition in hours
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#every EventForwarderWebhook#every}
    */
    readonly every?: string;
    /**
    * Gateways event sources to forward events about,for example the relevant Gateways cluster urls,: http://localhost:8000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#gateways_event_source_locations EventForwarderWebhook#gateways_event_source_locations}
    */
    readonly gatewaysEventSourceLocations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#id EventForwarderWebhook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Items event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#items_event_source_locations EventForwarderWebhook#items_event_source_locations}
    */
    readonly itemsEventSourceLocations?: string[];
    /**
    * Key name. The key will be used to encrypt the Event Forwarder secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#key EventForwarderWebhook#key}
    */
    readonly key?: string;
    /**
    * Event Forwarder name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#name EventForwarderWebhook#name}
    */
    readonly name: string;
    /**
    * Password for authentication relevant for user-pass auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#password EventForwarderWebhook#password}
    */
    readonly password?: string;
    /**
    * Base64 encoded PEM RSA Private Key, relevant for certificate auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#private_key_data EventForwarderWebhook#private_key_data}
    */
    readonly privateKeyData?: string;
    /**
    * Event Forwarder runner type [immediate/periodic]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#runner_type EventForwarderWebhook#runner_type}
    */
    readonly runnerType?: string;
    /**
    * Base64 encoded PEM certificate of the Webhook
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#server_certificates EventForwarderWebhook#server_certificates}
    */
    readonly serverCertificates?: string;
    /**
    * Targets event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#targets_event_source_locations EventForwarderWebhook#targets_event_source_locations}
    */
    readonly targetsEventSourceLocations?: string[];
    /**
    * Webhook URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#url EventForwarderWebhook#url}
    */
    readonly url?: string;
    /**
    * Username for authentication relevant for user-pass auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#username EventForwarderWebhook#username}
    */
    readonly username?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook akeyless_event_forwarder_webhook}
*/
export declare class EventForwarderWebhook extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_event_forwarder_webhook";
    /**
    * Generates CDKTF code for importing a EventForwarderWebhook resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventForwarderWebhook to import
    * @param importFromId The id of the existing EventForwarderWebhook that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventForwarderWebhook to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_webhook akeyless_event_forwarder_webhook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventForwarderWebhookConfig
    */
    constructor(scope: Construct, id: string, config: EventForwarderWebhookConfig);
    private _authMethodsEventSourceLocations?;
    get authMethodsEventSourceLocations(): string[];
    set authMethodsEventSourceLocations(value: string[]);
    resetAuthMethodsEventSourceLocations(): void;
    get authMethodsEventSourceLocationsInput(): string[] | undefined;
    private _authToken?;
    get authToken(): string;
    set authToken(value: string);
    resetAuthToken(): void;
    get authTokenInput(): string | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    resetAuthType(): void;
    get authTypeInput(): string | undefined;
    private _clientCertData?;
    get clientCertData(): string;
    set clientCertData(value: string);
    resetClientCertData(): void;
    get clientCertDataInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eventTypes?;
    get eventTypes(): string[];
    set eventTypes(value: string[]);
    resetEventTypes(): void;
    get eventTypesInput(): string[] | undefined;
    private _every?;
    get every(): string;
    set every(value: string);
    resetEvery(): void;
    get everyInput(): string | undefined;
    private _gatewaysEventSourceLocations?;
    get gatewaysEventSourceLocations(): string[];
    set gatewaysEventSourceLocations(value: string[]);
    resetGatewaysEventSourceLocations(): void;
    get gatewaysEventSourceLocationsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsEventSourceLocations?;
    get itemsEventSourceLocations(): string[];
    set itemsEventSourceLocations(value: string[]);
    resetItemsEventSourceLocations(): void;
    get itemsEventSourceLocationsInput(): string[] | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _privateKeyData?;
    get privateKeyData(): string;
    set privateKeyData(value: string);
    resetPrivateKeyData(): void;
    get privateKeyDataInput(): string | undefined;
    private _runnerType?;
    get runnerType(): string;
    set runnerType(value: string);
    resetRunnerType(): void;
    get runnerTypeInput(): string | undefined;
    private _serverCertificates?;
    get serverCertificates(): string;
    set serverCertificates(value: string);
    resetServerCertificates(): void;
    get serverCertificatesInput(): string | undefined;
    private _targetsEventSourceLocations?;
    get targetsEventSourceLocations(): string[];
    set targetsEventSourceLocations(value: string[]);
    resetTargetsEventSourceLocations(): void;
    get targetsEventSourceLocationsInput(): string[] | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
