import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayAllowedAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access id to be attached to this allowed access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access#access_id GatewayAllowedAccess#access_id}
    */
    readonly accessId: string;
    /**
    * Allowed access description
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access#description GatewayAllowedAccess#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access#id GatewayAllowedAccess#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Allowed access name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access#name GatewayAllowedAccess#name}
    */
    readonly name: string;
    /**
    * Comma-seperated list of permissions for this allowed access. Available permissions: [defaults,targets,classic_keys,automatic_migration,ldap_auth,dynamic_secret,k8s_auth,log_forwarding,zero_knowledge_encryption,rotated_secret,caching,event_forwarding,admin,kmip,general]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access#permissions GatewayAllowedAccess#permissions}
    */
    readonly permissions?: string;
    /**
    * key/val of sub claims, e.g group=admins,developers
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access#sub_claims GatewayAllowedAccess#sub_claims}
    */
    readonly subClaims?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access akeyless_gateway_allowed_access}
*/
export declare class GatewayAllowedAccess extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_allowed_access";
    /**
    * Generates CDKTF code for importing a GatewayAllowedAccess resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayAllowedAccess to import
    * @param importFromId The id of the existing GatewayAllowedAccess that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayAllowedAccess to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_allowed_access akeyless_gateway_allowed_access} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayAllowedAccessConfig
    */
    constructor(scope: Construct, id: string, config: GatewayAllowedAccessConfig);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    get accessIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _subClaims?;
    get subClaims(): {
        [key: string]: string;
    };
    set subClaims(value: {
        [key: string]: string;
    });
    resetSubClaims(): void;
    get subClaimsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
