import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayCacheConfig extends cdktf.TerraformMetaArguments {
    /**
    * Secure backup interval in minutes. To ensure service continuity in case of power cycle and network outage secrets will be backed up periodically per backup interval
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache#backup_interval GatewayCache#backup_interval}
    */
    readonly backupInterval?: string;
    /**
    * Enable cache [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache#enable_cache GatewayCache#enable_cache}
    */
    readonly enableCache?: string;
    /**
    * Enable proactive caching [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache#enable_proactive GatewayCache#enable_proactive}
    */
    readonly enableProactive?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache#id GatewayCache#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When using Cache or/and Proactive Cache, additional secrets will be fetched upon requesting a secret, based on the requestor's access policy. Define minimum fetching interval to avoid over fetching in a given time frame
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache#minimum_fetch_interval GatewayCache#minimum_fetch_interval}
    */
    readonly minimumFetchInterval?: string;
    /**
    * Stale timeout in minutes, cache entries which are not accessed within timeout will be removed from cache
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache#stale_timeout GatewayCache#stale_timeout}
    */
    readonly staleTimeout?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache akeyless_gateway_cache}
*/
export declare class GatewayCache extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_cache";
    /**
    * Generates CDKTF code for importing a GatewayCache resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayCache to import
    * @param importFromId The id of the existing GatewayCache that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayCache to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_cache akeyless_gateway_cache} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayCacheConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayCacheConfig);
    private _backupInterval?;
    get backupInterval(): string;
    set backupInterval(value: string);
    resetBackupInterval(): void;
    get backupIntervalInput(): string | undefined;
    private _enableCache?;
    get enableCache(): string;
    set enableCache(value: string);
    resetEnableCache(): void;
    get enableCacheInput(): string | undefined;
    private _enableProactive?;
    get enableProactive(): string;
    set enableProactive(value: string);
    resetEnableProactive(): void;
    get enableProactiveInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _minimumFetchInterval?;
    get minimumFetchInterval(): string;
    set minimumFetchInterval(value: string);
    resetMinimumFetchInterval(): void;
    get minimumFetchIntervalInput(): string | undefined;
    private _staleTimeout?;
    get staleTimeout(): string;
    set staleTimeout(value: string);
    resetStaleTimeout(): void;
    get staleTimeoutInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
