import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayDefaultsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Default Certificate access-id for UI login
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults#cert_access_id GatewayDefaults#cert_access_id}
    */
    readonly certAccessId?: string;
    /**
    * Trigger an event when Gateway status is changed [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults#event_on_status_change GatewayDefaults#event_on_status_change}
    */
    readonly eventOnStatusChange?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults#id GatewayDefaults#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the gateway default encryption key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults#key GatewayDefaults#key}
    */
    readonly key?: string;
    /**
    * Default OIDC access-id for UI login
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults#oidc_access_id GatewayDefaults#oidc_access_id}
    */
    readonly oidcAccessId?: string;
    /**
    * Default SAML access-id for UI login
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults#saml_access_id GatewayDefaults#saml_access_id}
    */
    readonly samlAccessId?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults akeyless_gateway_defaults}
*/
export declare class GatewayDefaults extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_defaults";
    /**
    * Generates CDKTF code for importing a GatewayDefaults resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayDefaults to import
    * @param importFromId The id of the existing GatewayDefaults that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayDefaults to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_defaults akeyless_gateway_defaults} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayDefaultsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayDefaultsConfig);
    private _certAccessId?;
    get certAccessId(): string;
    set certAccessId(value: string);
    resetCertAccessId(): void;
    get certAccessIdInput(): string | undefined;
    private _eventOnStatusChange?;
    get eventOnStatusChange(): string;
    set eventOnStatusChange(value: string);
    resetEventOnStatusChange(): void;
    get eventOnStatusChangeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _oidcAccessId?;
    get oidcAccessId(): string;
    set oidcAccessId(value: string);
    resetOidcAccessId(): void;
    get oidcAccessIdInput(): string | undefined;
    private _samlAccessId?;
    get samlAccessId(): string;
    set samlAccessId(value: string);
    resetSamlAccessId(): void;
    get samlAccessIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
