import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingElasticsearchConfig extends cdktf.TerraformMetaArguments {
    /**
    * Elasticsearch api key relevant only for api_key auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#api_key GatewayLogForwardingElasticsearch#api_key}
    */
    readonly apiKey?: string;
    /**
    * Elasticsearch auth type [api_key/password]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#auth_type GatewayLogForwardingElasticsearch#auth_type}
    */
    readonly authType?: string;
    /**
    * Elasticsearch cloud id relevant only for cloud server-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#cloud_id GatewayLogForwardingElasticsearch#cloud_id}
    */
    readonly cloudId?: string;
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#enable GatewayLogForwardingElasticsearch#enable}
    */
    readonly enable?: string;
    /**
    * Enable tls
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#enable_tls GatewayLogForwardingElasticsearch#enable_tls}
    */
    readonly enableTls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#id GatewayLogForwardingElasticsearch#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Elasticsearch index
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#index GatewayLogForwardingElasticsearch#index}
    */
    readonly index?: string;
    /**
    * Elasticsearch nodes relevant only for nodes server-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#nodes GatewayLogForwardingElasticsearch#nodes}
    */
    readonly nodes?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#output_format GatewayLogForwardingElasticsearch#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Elasticsearch password relevant only for password auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#password GatewayLogForwardingElasticsearch#password}
    */
    readonly password?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#pull_interval GatewayLogForwardingElasticsearch#pull_interval}
    */
    readonly pullInterval?: string;
    /**
    * Elasticsearch server type [nodes/cloud]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#server_type GatewayLogForwardingElasticsearch#server_type}
    */
    readonly serverType?: string;
    /**
    * Elasticsearch tls certificate (PEM format) in a Base64 format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#tls_certificate GatewayLogForwardingElasticsearch#tls_certificate}
    */
    readonly tlsCertificate?: string;
    /**
    * Elasticsearch user name relevant only for password auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#user_name GatewayLogForwardingElasticsearch#user_name}
    */
    readonly userName?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch akeyless_gateway_log_forwarding_elasticsearch}
*/
export declare class GatewayLogForwardingElasticsearch extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_elasticsearch";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingElasticsearch resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingElasticsearch to import
    * @param importFromId The id of the existing GatewayLogForwardingElasticsearch that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingElasticsearch to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_elasticsearch akeyless_gateway_log_forwarding_elasticsearch} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingElasticsearchConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingElasticsearchConfig);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    resetAuthType(): void;
    get authTypeInput(): string | undefined;
    private _cloudId?;
    get cloudId(): string;
    set cloudId(value: string);
    resetCloudId(): void;
    get cloudIdInput(): string | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _enableTls?;
    get enableTls(): boolean | cdktf.IResolvable;
    set enableTls(value: boolean | cdktf.IResolvable);
    resetEnableTls(): void;
    get enableTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    resetIndex(): void;
    get indexInput(): string | undefined;
    private _nodes?;
    get nodes(): string;
    set nodes(value: string);
    resetNodes(): void;
    get nodesInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    private _serverType?;
    get serverType(): string;
    set serverType(value: string);
    resetServerType(): void;
    get serverTypeInput(): string | undefined;
    private _tlsCertificate?;
    get tlsCertificate(): string;
    set tlsCertificate(value: string);
    resetTlsCertificate(): void;
    get tlsCertificateInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
