import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingSplunkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#enable GatewayLogForwardingSplunk#enable}
    */
    readonly enable?: string;
    /**
    * Enable tls
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#enable_tls GatewayLogForwardingSplunk#enable_tls}
    */
    readonly enableTls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#id GatewayLogForwardingSplunk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Splunk index
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#index GatewayLogForwardingSplunk#index}
    */
    readonly index?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#output_format GatewayLogForwardingSplunk#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#pull_interval GatewayLogForwardingSplunk#pull_interval}
    */
    readonly pullInterval?: string;
    /**
    * Splunk source
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#source GatewayLogForwardingSplunk#source}
    */
    readonly source?: string;
    /**
    * Splunk source type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#source_type GatewayLogForwardingSplunk#source_type}
    */
    readonly sourceType?: string;
    /**
    * Splunk token
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#splunk_token GatewayLogForwardingSplunk#splunk_token}
    */
    readonly splunkToken?: string;
    /**
    * Splunk server URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#splunk_url GatewayLogForwardingSplunk#splunk_url}
    */
    readonly splunkUrl?: string;
    /**
    * Splunk tls certificate (PEM format) in a Base64 format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#tls_certificate GatewayLogForwardingSplunk#tls_certificate}
    */
    readonly tlsCertificate?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk akeyless_gateway_log_forwarding_splunk}
*/
export declare class GatewayLogForwardingSplunk extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_splunk";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingSplunk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingSplunk to import
    * @param importFromId The id of the existing GatewayLogForwardingSplunk that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingSplunk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_splunk akeyless_gateway_log_forwarding_splunk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingSplunkConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingSplunkConfig);
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _enableTls?;
    get enableTls(): boolean | cdktf.IResolvable;
    set enableTls(value: boolean | cdktf.IResolvable);
    resetEnableTls(): void;
    get enableTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    resetIndex(): void;
    get indexInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _sourceType?;
    get sourceType(): string;
    set sourceType(value: string);
    resetSourceType(): void;
    get sourceTypeInput(): string | undefined;
    private _splunkToken?;
    get splunkToken(): string;
    set splunkToken(value: string);
    resetSplunkToken(): void;
    get splunkTokenInput(): string | undefined;
    private _splunkUrl?;
    get splunkUrl(): string;
    set splunkUrl(value: string);
    resetSplunkUrl(): void;
    get splunkUrlInput(): string | undefined;
    private _tlsCertificate?;
    get tlsCertificate(): string;
    set tlsCertificate(value: string);
    resetTlsCertificate(): void;
    get tlsCertificateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
