import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingSumologicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic#enable GatewayLogForwardingSumologic#enable}
    */
    readonly enable?: string;
    /**
    * Sumologic endpoint URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic#endpoint GatewayLogForwardingSumologic#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Sumologic host
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic#host GatewayLogForwardingSumologic#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic#id GatewayLogForwardingSumologic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic#output_format GatewayLogForwardingSumologic#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic#pull_interval GatewayLogForwardingSumologic#pull_interval}
    */
    readonly pullInterval?: string;
    /**
    * A comma-separated list of Sumologic tags
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic#sumologic_tags GatewayLogForwardingSumologic#sumologic_tags}
    */
    readonly sumologicTags?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic akeyless_gateway_log_forwarding_sumologic}
*/
export declare class GatewayLogForwardingSumologic extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_sumologic";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingSumologic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingSumologic to import
    * @param importFromId The id of the existing GatewayLogForwardingSumologic that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingSumologic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_sumologic akeyless_gateway_log_forwarding_sumologic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingSumologicConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingSumologicConfig);
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    private _sumologicTags?;
    get sumologicTags(): string;
    set sumologicTags(value: string);
    resetSumologicTags(): void;
    get sumologicTagsInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
