"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRemoteAccessRdpRecording = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording akeyless_gateway_remote_access_rdp_recording}
*/
class GatewayRemoteAccessRdpRecording extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a GatewayRemoteAccessRdpRecording resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayRemoteAccessRdpRecording to import
    * @param importFromId The id of the existing GatewayRemoteAccessRdpRecording that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayRemoteAccessRdpRecording to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "akeyless_gateway_remote_access_rdp_recording", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording akeyless_gateway_remote_access_rdp_recording} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayRemoteAccessRdpRecordingConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'akeyless_gateway_remote_access_rdp_recording',
            terraformGeneratorMetadata: {
                providerName: 'akeyless',
                providerVersion: '1.11.2',
                providerVersionConstraint: '~> 1.11.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._awsStorageAccessKeyId = config.awsStorageAccessKeyId;
        this._awsStorageBucketName = config.awsStorageBucketName;
        this._awsStorageBucketPrefix = config.awsStorageBucketPrefix;
        this._awsStorageRegion = config.awsStorageRegion;
        this._awsStorageSecretAccessKey = config.awsStorageSecretAccessKey;
        this._azureStorageAccountName = config.azureStorageAccountName;
        this._azureStorageClientId = config.azureStorageClientId;
        this._azureStorageClientSecret = config.azureStorageClientSecret;
        this._azureStorageContainerName = config.azureStorageContainerName;
        this._azureStorageTenantId = config.azureStorageTenantId;
        this._id = config.id;
        this._rdpSessionRecording = config.rdpSessionRecording;
        this._rdpSessionStorage = config.rdpSessionStorage;
    }
    get awsStorageAccessKeyId() {
        return this.getStringAttribute('aws_storage_access_key_id');
    }
    set awsStorageAccessKeyId(value) {
        this._awsStorageAccessKeyId = value;
    }
    resetAwsStorageAccessKeyId() {
        this._awsStorageAccessKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsStorageAccessKeyIdInput() {
        return this._awsStorageAccessKeyId;
    }
    get awsStorageBucketName() {
        return this.getStringAttribute('aws_storage_bucket_name');
    }
    set awsStorageBucketName(value) {
        this._awsStorageBucketName = value;
    }
    resetAwsStorageBucketName() {
        this._awsStorageBucketName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsStorageBucketNameInput() {
        return this._awsStorageBucketName;
    }
    get awsStorageBucketPrefix() {
        return this.getStringAttribute('aws_storage_bucket_prefix');
    }
    set awsStorageBucketPrefix(value) {
        this._awsStorageBucketPrefix = value;
    }
    resetAwsStorageBucketPrefix() {
        this._awsStorageBucketPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsStorageBucketPrefixInput() {
        return this._awsStorageBucketPrefix;
    }
    get awsStorageRegion() {
        return this.getStringAttribute('aws_storage_region');
    }
    set awsStorageRegion(value) {
        this._awsStorageRegion = value;
    }
    resetAwsStorageRegion() {
        this._awsStorageRegion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsStorageRegionInput() {
        return this._awsStorageRegion;
    }
    get awsStorageSecretAccessKey() {
        return this.getStringAttribute('aws_storage_secret_access_key');
    }
    set awsStorageSecretAccessKey(value) {
        this._awsStorageSecretAccessKey = value;
    }
    resetAwsStorageSecretAccessKey() {
        this._awsStorageSecretAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsStorageSecretAccessKeyInput() {
        return this._awsStorageSecretAccessKey;
    }
    get azureStorageAccountName() {
        return this.getStringAttribute('azure_storage_account_name');
    }
    set azureStorageAccountName(value) {
        this._azureStorageAccountName = value;
    }
    resetAzureStorageAccountName() {
        this._azureStorageAccountName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureStorageAccountNameInput() {
        return this._azureStorageAccountName;
    }
    get azureStorageClientId() {
        return this.getStringAttribute('azure_storage_client_id');
    }
    set azureStorageClientId(value) {
        this._azureStorageClientId = value;
    }
    resetAzureStorageClientId() {
        this._azureStorageClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureStorageClientIdInput() {
        return this._azureStorageClientId;
    }
    get azureStorageClientSecret() {
        return this.getStringAttribute('azure_storage_client_secret');
    }
    set azureStorageClientSecret(value) {
        this._azureStorageClientSecret = value;
    }
    resetAzureStorageClientSecret() {
        this._azureStorageClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureStorageClientSecretInput() {
        return this._azureStorageClientSecret;
    }
    get azureStorageContainerName() {
        return this.getStringAttribute('azure_storage_container_name');
    }
    set azureStorageContainerName(value) {
        this._azureStorageContainerName = value;
    }
    resetAzureStorageContainerName() {
        this._azureStorageContainerName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureStorageContainerNameInput() {
        return this._azureStorageContainerName;
    }
    get azureStorageTenantId() {
        return this.getStringAttribute('azure_storage_tenant_id');
    }
    set azureStorageTenantId(value) {
        this._azureStorageTenantId = value;
    }
    resetAzureStorageTenantId() {
        this._azureStorageTenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureStorageTenantIdInput() {
        return this._azureStorageTenantId;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get rdpSessionRecording() {
        return this.getStringAttribute('rdp_session_recording');
    }
    set rdpSessionRecording(value) {
        this._rdpSessionRecording = value;
    }
    resetRdpSessionRecording() {
        this._rdpSessionRecording = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rdpSessionRecordingInput() {
        return this._rdpSessionRecording;
    }
    get rdpSessionStorage() {
        return this.getStringAttribute('rdp_session_storage');
    }
    set rdpSessionStorage(value) {
        this._rdpSessionStorage = value;
    }
    resetRdpSessionStorage() {
        this._rdpSessionStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rdpSessionStorageInput() {
        return this._rdpSessionStorage;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            aws_storage_access_key_id: cdktf.stringToTerraform(this._awsStorageAccessKeyId),
            aws_storage_bucket_name: cdktf.stringToTerraform(this._awsStorageBucketName),
            aws_storage_bucket_prefix: cdktf.stringToTerraform(this._awsStorageBucketPrefix),
            aws_storage_region: cdktf.stringToTerraform(this._awsStorageRegion),
            aws_storage_secret_access_key: cdktf.stringToTerraform(this._awsStorageSecretAccessKey),
            azure_storage_account_name: cdktf.stringToTerraform(this._azureStorageAccountName),
            azure_storage_client_id: cdktf.stringToTerraform(this._azureStorageClientId),
            azure_storage_client_secret: cdktf.stringToTerraform(this._azureStorageClientSecret),
            azure_storage_container_name: cdktf.stringToTerraform(this._azureStorageContainerName),
            azure_storage_tenant_id: cdktf.stringToTerraform(this._azureStorageTenantId),
            id: cdktf.stringToTerraform(this._id),
            rdp_session_recording: cdktf.stringToTerraform(this._rdpSessionRecording),
            rdp_session_storage: cdktf.stringToTerraform(this._rdpSessionStorage),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            aws_storage_access_key_id: {
                value: cdktf.stringToHclTerraform(this._awsStorageAccessKeyId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            aws_storage_bucket_name: {
                value: cdktf.stringToHclTerraform(this._awsStorageBucketName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            aws_storage_bucket_prefix: {
                value: cdktf.stringToHclTerraform(this._awsStorageBucketPrefix),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            aws_storage_region: {
                value: cdktf.stringToHclTerraform(this._awsStorageRegion),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            aws_storage_secret_access_key: {
                value: cdktf.stringToHclTerraform(this._awsStorageSecretAccessKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            azure_storage_account_name: {
                value: cdktf.stringToHclTerraform(this._azureStorageAccountName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            azure_storage_client_id: {
                value: cdktf.stringToHclTerraform(this._azureStorageClientId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            azure_storage_client_secret: {
                value: cdktf.stringToHclTerraform(this._azureStorageClientSecret),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            azure_storage_container_name: {
                value: cdktf.stringToHclTerraform(this._azureStorageContainerName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            azure_storage_tenant_id: {
                value: cdktf.stringToHclTerraform(this._azureStorageTenantId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            rdp_session_recording: {
                value: cdktf.stringToHclTerraform(this._rdpSessionRecording),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            rdp_session_storage: {
                value: cdktf.stringToHclTerraform(this._rdpSessionStorage),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.GatewayRemoteAccessRdpRecording = GatewayRemoteAccessRdpRecording;
_a = JSII_RTTI_SYMBOL_1;
GatewayRemoteAccessRdpRecording[_a] = { fqn: "akeyless.gatewayRemoteAccessRdpRecording.GatewayRemoteAccessRdpRecording", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
GatewayRemoteAccessRdpRecording.tfResourceType = "akeyless_gateway_remote_access_rdp_recording";
//# sourceMappingURL=data:application/json;base64,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