import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayRemoteAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of valid URLs to redirect from the Portal back to the remote access server (in a comma-delimited list)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#allowed_urls GatewayRemoteAccess#allowed_urls}
    */
    readonly allowedUrls?: string;
    /**
    * Specifies whether to show/hide if the session is currently recorded [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#hide_session_recording GatewayRemoteAccess#hide_session_recording}
    */
    readonly hideSessionRecording?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#id GatewayRemoteAccess#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Decide which algorithm will be used as part of the SSH initial hand-shake process
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#kexalgs GatewayRemoteAccess#kexalgs}
    */
    readonly kexalgs?: string;
    /**
    * Enable support for additional keyboard layouts
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#keyboard_layout GatewayRemoteAccess#keyboard_layout}
    */
    readonly keyboardLayout?: string;
    /**
    * Signs SSH certificates using legacy ssh-rsa-cert-01@openssh.com signing algorithm [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#legacy_ssh_algorithm GatewayRemoteAccess#legacy_ssh_algorithm}
    */
    readonly legacySshAlgorithm?: string;
    /**
    * Specify the usernameSubClaim that exists inside the IDP JWT, e.g. email
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#rdp_target_configuration GatewayRemoteAccess#rdp_target_configuration}
    */
    readonly rdpTargetConfiguration?: string;
    /**
    * Specify the usernameSubClaim that exists inside the IDP JWT, e.g. email
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#ssh_target_configuration GatewayRemoteAccess#ssh_target_configuration}
    */
    readonly sshTargetConfiguration?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access akeyless_gateway_remote_access}
*/
export declare class GatewayRemoteAccess extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_remote_access";
    /**
    * Generates CDKTF code for importing a GatewayRemoteAccess resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayRemoteAccess to import
    * @param importFromId The id of the existing GatewayRemoteAccess that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayRemoteAccess to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access akeyless_gateway_remote_access} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayRemoteAccessConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayRemoteAccessConfig);
    private _allowedUrls?;
    get allowedUrls(): string;
    set allowedUrls(value: string);
    resetAllowedUrls(): void;
    get allowedUrlsInput(): string | undefined;
    private _hideSessionRecording?;
    get hideSessionRecording(): string;
    set hideSessionRecording(value: string);
    resetHideSessionRecording(): void;
    get hideSessionRecordingInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kexalgs?;
    get kexalgs(): string;
    set kexalgs(value: string);
    resetKexalgs(): void;
    get kexalgsInput(): string | undefined;
    private _keyboardLayout?;
    get keyboardLayout(): string;
    set keyboardLayout(value: string);
    resetKeyboardLayout(): void;
    get keyboardLayoutInput(): string | undefined;
    private _legacySshAlgorithm?;
    get legacySshAlgorithm(): string;
    set legacySshAlgorithm(value: string);
    resetLegacySshAlgorithm(): void;
    get legacySshAlgorithmInput(): string | undefined;
    private _rdpTargetConfiguration?;
    get rdpTargetConfiguration(): string;
    set rdpTargetConfiguration(value: string);
    resetRdpTargetConfiguration(): void;
    get rdpTargetConfigurationInput(): string | undefined;
    private _sshTargetConfiguration?;
    get sshTargetConfiguration(): string;
    set sshTargetConfiguration(value: string);
    resetSshTargetConfiguration(): void;
    get sshTargetConfigurationInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
