"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.K8SAuthConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config akeyless_k8s_auth_config}
*/
class K8SAuthConfig extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a K8SAuthConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the K8SAuthConfig to import
    * @param importFromId The id of the existing K8SAuthConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the K8SAuthConfig to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "akeyless_k8s_auth_config", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config akeyless_k8s_auth_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options K8SAuthConfigConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'akeyless_k8s_auth_config',
            terraformGeneratorMetadata: {
                providerName: 'akeyless',
                providerVersion: '1.11.2',
                providerVersionConstraint: '~> 1.11.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._accessId = config.accessId;
        this._clusterApiType = config.clusterApiType;
        this._disableIssuerValidation = config.disableIssuerValidation;
        this._id = config.id;
        this._k8SAuthType = config.k8SAuthType;
        this._k8SCaCert = config.k8SCaCert;
        this._k8SClientCertificate = config.k8SClientCertificate;
        this._k8SClientKey = config.k8SClientKey;
        this._k8SHost = config.k8SHost;
        this._k8SIssuer = config.k8SIssuer;
        this._name = config.name;
        this._rancherApiKey = config.rancherApiKey;
        this._rancherClusterId = config.rancherClusterId;
        this._signingKey = config.signingKey;
        this._tokenExp = config.tokenExp;
        this._tokenReviewerJwt = config.tokenReviewerJwt;
        this._useLocalCaJwt = config.useLocalCaJwt;
    }
    get accessId() {
        return this.getStringAttribute('access_id');
    }
    set accessId(value) {
        this._accessId = value;
    }
    // Temporarily expose input value. Use with caution.
    get accessIdInput() {
        return this._accessId;
    }
    get clusterApiType() {
        return this.getStringAttribute('cluster_api_type');
    }
    set clusterApiType(value) {
        this._clusterApiType = value;
    }
    resetClusterApiType() {
        this._clusterApiType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusterApiTypeInput() {
        return this._clusterApiType;
    }
    get disableIssuerValidation() {
        return this.getStringAttribute('disable_issuer_validation');
    }
    set disableIssuerValidation(value) {
        this._disableIssuerValidation = value;
    }
    resetDisableIssuerValidation() {
        this._disableIssuerValidation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableIssuerValidationInput() {
        return this._disableIssuerValidation;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get k8SAuthType() {
        return this.getStringAttribute('k8s_auth_type');
    }
    set k8SAuthType(value) {
        this._k8SAuthType = value;
    }
    resetK8SAuthType() {
        this._k8SAuthType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get k8SAuthTypeInput() {
        return this._k8SAuthType;
    }
    get k8SCaCert() {
        return this.getStringAttribute('k8s_ca_cert');
    }
    set k8SCaCert(value) {
        this._k8SCaCert = value;
    }
    resetK8SCaCert() {
        this._k8SCaCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get k8SCaCertInput() {
        return this._k8SCaCert;
    }
    get k8SClientCertificate() {
        return this.getStringAttribute('k8s_client_certificate');
    }
    set k8SClientCertificate(value) {
        this._k8SClientCertificate = value;
    }
    resetK8SClientCertificate() {
        this._k8SClientCertificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get k8SClientCertificateInput() {
        return this._k8SClientCertificate;
    }
    get k8SClientKey() {
        return this.getStringAttribute('k8s_client_key');
    }
    set k8SClientKey(value) {
        this._k8SClientKey = value;
    }
    resetK8SClientKey() {
        this._k8SClientKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get k8SClientKeyInput() {
        return this._k8SClientKey;
    }
    get k8SHost() {
        return this.getStringAttribute('k8s_host');
    }
    set k8SHost(value) {
        this._k8SHost = value;
    }
    resetK8SHost() {
        this._k8SHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get k8SHostInput() {
        return this._k8SHost;
    }
    get k8SIssuer() {
        return this.getStringAttribute('k8s_issuer');
    }
    set k8SIssuer(value) {
        this._k8SIssuer = value;
    }
    resetK8SIssuer() {
        this._k8SIssuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get k8SIssuerInput() {
        return this._k8SIssuer;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get rancherApiKey() {
        return this.getStringAttribute('rancher_api_key');
    }
    set rancherApiKey(value) {
        this._rancherApiKey = value;
    }
    resetRancherApiKey() {
        this._rancherApiKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rancherApiKeyInput() {
        return this._rancherApiKey;
    }
    get rancherClusterId() {
        return this.getStringAttribute('rancher_cluster_id');
    }
    set rancherClusterId(value) {
        this._rancherClusterId = value;
    }
    resetRancherClusterId() {
        this._rancherClusterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rancherClusterIdInput() {
        return this._rancherClusterId;
    }
    get signingKey() {
        return this.getStringAttribute('signing_key');
    }
    set signingKey(value) {
        this._signingKey = value;
    }
    resetSigningKey() {
        this._signingKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signingKeyInput() {
        return this._signingKey;
    }
    get tokenExp() {
        return this.getNumberAttribute('token_exp');
    }
    set tokenExp(value) {
        this._tokenExp = value;
    }
    resetTokenExp() {
        this._tokenExp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExpInput() {
        return this._tokenExp;
    }
    get tokenReviewerJwt() {
        return this.getStringAttribute('token_reviewer_jwt');
    }
    set tokenReviewerJwt(value) {
        this._tokenReviewerJwt = value;
    }
    resetTokenReviewerJwt() {
        this._tokenReviewerJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenReviewerJwtInput() {
        return this._tokenReviewerJwt;
    }
    get useLocalCaJwt() {
        return this.getBooleanAttribute('use_local_ca_jwt');
    }
    set useLocalCaJwt(value) {
        this._useLocalCaJwt = value;
    }
    resetUseLocalCaJwt() {
        this._useLocalCaJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useLocalCaJwtInput() {
        return this._useLocalCaJwt;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_id: cdktf.stringToTerraform(this._accessId),
            cluster_api_type: cdktf.stringToTerraform(this._clusterApiType),
            disable_issuer_validation: cdktf.stringToTerraform(this._disableIssuerValidation),
            id: cdktf.stringToTerraform(this._id),
            k8s_auth_type: cdktf.stringToTerraform(this._k8SAuthType),
            k8s_ca_cert: cdktf.stringToTerraform(this._k8SCaCert),
            k8s_client_certificate: cdktf.stringToTerraform(this._k8SClientCertificate),
            k8s_client_key: cdktf.stringToTerraform(this._k8SClientKey),
            k8s_host: cdktf.stringToTerraform(this._k8SHost),
            k8s_issuer: cdktf.stringToTerraform(this._k8SIssuer),
            name: cdktf.stringToTerraform(this._name),
            rancher_api_key: cdktf.stringToTerraform(this._rancherApiKey),
            rancher_cluster_id: cdktf.stringToTerraform(this._rancherClusterId),
            signing_key: cdktf.stringToTerraform(this._signingKey),
            token_exp: cdktf.numberToTerraform(this._tokenExp),
            token_reviewer_jwt: cdktf.stringToTerraform(this._tokenReviewerJwt),
            use_local_ca_jwt: cdktf.booleanToTerraform(this._useLocalCaJwt),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            access_id: {
                value: cdktf.stringToHclTerraform(this._accessId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            cluster_api_type: {
                value: cdktf.stringToHclTerraform(this._clusterApiType),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            disable_issuer_validation: {
                value: cdktf.stringToHclTerraform(this._disableIssuerValidation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            k8s_auth_type: {
                value: cdktf.stringToHclTerraform(this._k8SAuthType),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            k8s_ca_cert: {
                value: cdktf.stringToHclTerraform(this._k8SCaCert),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            k8s_client_certificate: {
                value: cdktf.stringToHclTerraform(this._k8SClientCertificate),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            k8s_client_key: {
                value: cdktf.stringToHclTerraform(this._k8SClientKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            k8s_host: {
                value: cdktf.stringToHclTerraform(this._k8SHost),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            k8s_issuer: {
                value: cdktf.stringToHclTerraform(this._k8SIssuer),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            rancher_api_key: {
                value: cdktf.stringToHclTerraform(this._rancherApiKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            rancher_cluster_id: {
                value: cdktf.stringToHclTerraform(this._rancherClusterId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            signing_key: {
                value: cdktf.stringToHclTerraform(this._signingKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            token_exp: {
                value: cdktf.numberToHclTerraform(this._tokenExp),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            token_reviewer_jwt: {
                value: cdktf.stringToHclTerraform(this._tokenReviewerJwt),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            use_local_ca_jwt: {
                value: cdktf.booleanToHclTerraform(this._useLocalCaJwt),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.K8SAuthConfig = K8SAuthConfig;
_a = JSII_RTTI_SYMBOL_1;
K8SAuthConfig[_a] = { fqn: "akeyless.k8SAuthConfig.K8SAuthConfig", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
K8SAuthConfig.tfResourceType = "akeyless_k8s_auth_config";
//# sourceMappingURL=data:application/json;base64,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