import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerCustomConfig extends cdktf.TerraformMetaArguments {
    /**
    * Rotation period in days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#admin_rotation_interval_days ProducerCustom#admin_rotation_interval_days}
    */
    readonly adminRotationIntervalDays?: number;
    /**
    * URL of an endpoint that implements /sync/create method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#create_sync_url ProducerCustom#create_sync_url}
    */
    readonly createSyncUrl: string;
    /**
    * Enable automatic admin credentials rotation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#enable_admin_rotation ProducerCustom#enable_admin_rotation}
    */
    readonly enableAdminRotation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#id ProducerCustom#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#name ProducerCustom#name}
    */
    readonly name: string;
    /**
    * Secret payload to be sent with each create/revoke webhook request
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#payload ProducerCustom#payload}
    */
    readonly payload?: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#producer_encryption_key_name ProducerCustom#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * URL of an endpoint that implements /sync/revoke method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#revoke_sync_url ProducerCustom#revoke_sync_url}
    */
    readonly revokeSyncUrl: string;
    /**
    * URL of an endpoint that implements /sync/rotate method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#rotate_sync_url ProducerCustom#rotate_sync_url}
    */
    readonly rotateSyncUrl?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#tags ProducerCustom#tags}
    */
    readonly tags?: string[];
    /**
    * Maximum allowed time in seconds for the webhook to return the results
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#timeout_sec ProducerCustom#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#user_ttl ProducerCustom#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom akeyless_producer_custom}
*/
export declare class ProducerCustom extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_custom";
    /**
    * Generates CDKTF code for importing a ProducerCustom resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerCustom to import
    * @param importFromId The id of the existing ProducerCustom that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerCustom to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_custom akeyless_producer_custom} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerCustomConfig
    */
    constructor(scope: Construct, id: string, config: ProducerCustomConfig);
    private _adminRotationIntervalDays?;
    get adminRotationIntervalDays(): number;
    set adminRotationIntervalDays(value: number);
    resetAdminRotationIntervalDays(): void;
    get adminRotationIntervalDaysInput(): number | undefined;
    private _createSyncUrl?;
    get createSyncUrl(): string;
    set createSyncUrl(value: string);
    get createSyncUrlInput(): string | undefined;
    private _enableAdminRotation?;
    get enableAdminRotation(): boolean | cdktf.IResolvable;
    set enableAdminRotation(value: boolean | cdktf.IResolvable);
    resetEnableAdminRotation(): void;
    get enableAdminRotationInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _revokeSyncUrl?;
    get revokeSyncUrl(): string;
    set revokeSyncUrl(value: string);
    get revokeSyncUrlInput(): string | undefined;
    private _rotateSyncUrl?;
    get rotateSyncUrl(): string;
    set rotateSyncUrl(value: string);
    resetRotateSyncUrl(): void;
    get rotateSyncUrlInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
