import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerGkeConfig extends cdktf.TerraformMetaArguments {
    /**
    * GKE service account key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#gke_account_key ProducerGke#gke_account_key}
    */
    readonly gkeAccountKey?: string;
    /**
    * GKE Base-64 encoded cluster certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#gke_cluster_cert ProducerGke#gke_cluster_cert}
    */
    readonly gkeClusterCert?: string;
    /**
    * GKE cluster endpoint, i.e., cluster URI https://<DNS/IP>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#gke_cluster_endpoint ProducerGke#gke_cluster_endpoint}
    */
    readonly gkeClusterEndpoint?: string;
    /**
    * GKE cluster name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#gke_cluster_name ProducerGke#gke_cluster_name}
    */
    readonly gkeClusterName?: string;
    /**
    * GKE service account email
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#gke_service_account_email ProducerGke#gke_service_account_email}
    */
    readonly gkeServiceAccountEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#id ProducerGke#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#name ProducerGke#name}
    */
    readonly name: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#producer_encryption_key_name ProducerGke#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * Enable Port forwarding while using CLI access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#secure_access_allow_port_forwading ProducerGke#secure_access_allow_port_forwading}
    */
    readonly secureAccessAllowPortForwading?: boolean | cdktf.IResolvable;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#secure_access_bastion_issuer ProducerGke#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * The K8s cluster endpoint URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#secure_access_cluster_endpoint ProducerGke#secure_access_cluster_endpoint}
    */
    readonly secureAccessClusterEndpoint?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#secure_access_enable ProducerGke#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#secure_access_web ProducerGke#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#tags ProducerGke#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#target_name ProducerGke#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#user_ttl ProducerGke#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke akeyless_producer_gke}
*/
export declare class ProducerGke extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_gke";
    /**
    * Generates CDKTF code for importing a ProducerGke resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerGke to import
    * @param importFromId The id of the existing ProducerGke that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerGke to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke akeyless_producer_gke} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerGkeConfig
    */
    constructor(scope: Construct, id: string, config: ProducerGkeConfig);
    private _gkeAccountKey?;
    get gkeAccountKey(): string;
    set gkeAccountKey(value: string);
    resetGkeAccountKey(): void;
    get gkeAccountKeyInput(): string | undefined;
    private _gkeClusterCert?;
    get gkeClusterCert(): string;
    set gkeClusterCert(value: string);
    resetGkeClusterCert(): void;
    get gkeClusterCertInput(): string | undefined;
    private _gkeClusterEndpoint?;
    get gkeClusterEndpoint(): string;
    set gkeClusterEndpoint(value: string);
    resetGkeClusterEndpoint(): void;
    get gkeClusterEndpointInput(): string | undefined;
    private _gkeClusterName?;
    get gkeClusterName(): string;
    set gkeClusterName(value: string);
    resetGkeClusterName(): void;
    get gkeClusterNameInput(): string | undefined;
    private _gkeServiceAccountEmail?;
    get gkeServiceAccountEmail(): string;
    set gkeServiceAccountEmail(value: string);
    resetGkeServiceAccountEmail(): void;
    get gkeServiceAccountEmailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _secureAccessAllowPortForwading?;
    get secureAccessAllowPortForwading(): boolean | cdktf.IResolvable;
    set secureAccessAllowPortForwading(value: boolean | cdktf.IResolvable);
    resetSecureAccessAllowPortForwading(): void;
    get secureAccessAllowPortForwadingInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessClusterEndpoint?;
    get secureAccessClusterEndpoint(): string;
    set secureAccessClusterEndpoint(value: string);
    resetSecureAccessClusterEndpoint(): void;
    get secureAccessClusterEndpointInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
