"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProducerGke = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke akeyless_producer_gke}
*/
class ProducerGke extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a ProducerGke resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerGke to import
    * @param importFromId The id of the existing ProducerGke that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerGke to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "akeyless_producer_gke", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gke akeyless_producer_gke} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerGkeConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'akeyless_producer_gke',
            terraformGeneratorMetadata: {
                providerName: 'akeyless',
                providerVersion: '1.11.2',
                providerVersionConstraint: '~> 1.11.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._gkeAccountKey = config.gkeAccountKey;
        this._gkeClusterCert = config.gkeClusterCert;
        this._gkeClusterEndpoint = config.gkeClusterEndpoint;
        this._gkeClusterName = config.gkeClusterName;
        this._gkeServiceAccountEmail = config.gkeServiceAccountEmail;
        this._id = config.id;
        this._name = config.name;
        this._producerEncryptionKeyName = config.producerEncryptionKeyName;
        this._secureAccessAllowPortForwading = config.secureAccessAllowPortForwading;
        this._secureAccessBastionIssuer = config.secureAccessBastionIssuer;
        this._secureAccessClusterEndpoint = config.secureAccessClusterEndpoint;
        this._secureAccessEnable = config.secureAccessEnable;
        this._secureAccessWeb = config.secureAccessWeb;
        this._tags = config.tags;
        this._targetName = config.targetName;
        this._userTtl = config.userTtl;
    }
    get gkeAccountKey() {
        return this.getStringAttribute('gke_account_key');
    }
    set gkeAccountKey(value) {
        this._gkeAccountKey = value;
    }
    resetGkeAccountKey() {
        this._gkeAccountKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeAccountKeyInput() {
        return this._gkeAccountKey;
    }
    get gkeClusterCert() {
        return this.getStringAttribute('gke_cluster_cert');
    }
    set gkeClusterCert(value) {
        this._gkeClusterCert = value;
    }
    resetGkeClusterCert() {
        this._gkeClusterCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeClusterCertInput() {
        return this._gkeClusterCert;
    }
    get gkeClusterEndpoint() {
        return this.getStringAttribute('gke_cluster_endpoint');
    }
    set gkeClusterEndpoint(value) {
        this._gkeClusterEndpoint = value;
    }
    resetGkeClusterEndpoint() {
        this._gkeClusterEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeClusterEndpointInput() {
        return this._gkeClusterEndpoint;
    }
    get gkeClusterName() {
        return this.getStringAttribute('gke_cluster_name');
    }
    set gkeClusterName(value) {
        this._gkeClusterName = value;
    }
    resetGkeClusterName() {
        this._gkeClusterName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeClusterNameInput() {
        return this._gkeClusterName;
    }
    get gkeServiceAccountEmail() {
        return this.getStringAttribute('gke_service_account_email');
    }
    set gkeServiceAccountEmail(value) {
        this._gkeServiceAccountEmail = value;
    }
    resetGkeServiceAccountEmail() {
        this._gkeServiceAccountEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeServiceAccountEmailInput() {
        return this._gkeServiceAccountEmail;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get producerEncryptionKeyName() {
        return this.getStringAttribute('producer_encryption_key_name');
    }
    set producerEncryptionKeyName(value) {
        this._producerEncryptionKeyName = value;
    }
    resetProducerEncryptionKeyName() {
        this._producerEncryptionKeyName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get producerEncryptionKeyNameInput() {
        return this._producerEncryptionKeyName;
    }
    get secureAccessAllowPortForwading() {
        return this.getBooleanAttribute('secure_access_allow_port_forwading');
    }
    set secureAccessAllowPortForwading(value) {
        this._secureAccessAllowPortForwading = value;
    }
    resetSecureAccessAllowPortForwading() {
        this._secureAccessAllowPortForwading = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessAllowPortForwadingInput() {
        return this._secureAccessAllowPortForwading;
    }
    get secureAccessBastionIssuer() {
        return this.getStringAttribute('secure_access_bastion_issuer');
    }
    set secureAccessBastionIssuer(value) {
        this._secureAccessBastionIssuer = value;
    }
    resetSecureAccessBastionIssuer() {
        this._secureAccessBastionIssuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessBastionIssuerInput() {
        return this._secureAccessBastionIssuer;
    }
    get secureAccessClusterEndpoint() {
        return this.getStringAttribute('secure_access_cluster_endpoint');
    }
    set secureAccessClusterEndpoint(value) {
        this._secureAccessClusterEndpoint = value;
    }
    resetSecureAccessClusterEndpoint() {
        this._secureAccessClusterEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessClusterEndpointInput() {
        return this._secureAccessClusterEndpoint;
    }
    get secureAccessEnable() {
        return this.getStringAttribute('secure_access_enable');
    }
    set secureAccessEnable(value) {
        this._secureAccessEnable = value;
    }
    resetSecureAccessEnable() {
        this._secureAccessEnable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessEnableInput() {
        return this._secureAccessEnable;
    }
    get secureAccessWeb() {
        return this.getBooleanAttribute('secure_access_web');
    }
    set secureAccessWeb(value) {
        this._secureAccessWeb = value;
    }
    resetSecureAccessWeb() {
        this._secureAccessWeb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessWebInput() {
        return this._secureAccessWeb;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get targetName() {
        return this.getStringAttribute('target_name');
    }
    set targetName(value) {
        this._targetName = value;
    }
    resetTargetName() {
        this._targetName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get targetNameInput() {
        return this._targetName;
    }
    get userTtl() {
        return this.getStringAttribute('user_ttl');
    }
    set userTtl(value) {
        this._userTtl = value;
    }
    resetUserTtl() {
        this._userTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTtlInput() {
        return this._userTtl;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            gke_account_key: cdktf.stringToTerraform(this._gkeAccountKey),
            gke_cluster_cert: cdktf.stringToTerraform(this._gkeClusterCert),
            gke_cluster_endpoint: cdktf.stringToTerraform(this._gkeClusterEndpoint),
            gke_cluster_name: cdktf.stringToTerraform(this._gkeClusterName),
            gke_service_account_email: cdktf.stringToTerraform(this._gkeServiceAccountEmail),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            producer_encryption_key_name: cdktf.stringToTerraform(this._producerEncryptionKeyName),
            secure_access_allow_port_forwading: cdktf.booleanToTerraform(this._secureAccessAllowPortForwading),
            secure_access_bastion_issuer: cdktf.stringToTerraform(this._secureAccessBastionIssuer),
            secure_access_cluster_endpoint: cdktf.stringToTerraform(this._secureAccessClusterEndpoint),
            secure_access_enable: cdktf.stringToTerraform(this._secureAccessEnable),
            secure_access_web: cdktf.booleanToTerraform(this._secureAccessWeb),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            target_name: cdktf.stringToTerraform(this._targetName),
            user_ttl: cdktf.stringToTerraform(this._userTtl),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            gke_account_key: {
                value: cdktf.stringToHclTerraform(this._gkeAccountKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            gke_cluster_cert: {
                value: cdktf.stringToHclTerraform(this._gkeClusterCert),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            gke_cluster_endpoint: {
                value: cdktf.stringToHclTerraform(this._gkeClusterEndpoint),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            gke_cluster_name: {
                value: cdktf.stringToHclTerraform(this._gkeClusterName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            gke_service_account_email: {
                value: cdktf.stringToHclTerraform(this._gkeServiceAccountEmail),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            producer_encryption_key_name: {
                value: cdktf.stringToHclTerraform(this._producerEncryptionKeyName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_allow_port_forwading: {
                value: cdktf.booleanToHclTerraform(this._secureAccessAllowPortForwading),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            secure_access_bastion_issuer: {
                value: cdktf.stringToHclTerraform(this._secureAccessBastionIssuer),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_cluster_endpoint: {
                value: cdktf.stringToHclTerraform(this._secureAccessClusterEndpoint),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_enable: {
                value: cdktf.stringToHclTerraform(this._secureAccessEnable),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_web: {
                value: cdktf.booleanToHclTerraform(this._secureAccessWeb),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            target_name: {
                value: cdktf.stringToHclTerraform(this._targetName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_ttl: {
                value: cdktf.stringToHclTerraform(this._userTtl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.ProducerGke = ProducerGke;
_a = JSII_RTTI_SYMBOL_1;
ProducerGke[_a] = { fqn: "akeyless.producerGke.ProducerGke", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
ProducerGke.tfResourceType = "akeyless_producer_gke";
//# sourceMappingURL=data:application/json;base64,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