import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerMongoConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#id ProducerMongo#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * MongoDB Atlas private key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_atlas_api_private_key ProducerMongo#mongodb_atlas_api_private_key}
    */
    readonly mongodbAtlasApiPrivateKey?: string;
    /**
    * MongoDB Atlas public key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_atlas_api_public_key ProducerMongo#mongodb_atlas_api_public_key}
    */
    readonly mongodbAtlasApiPublicKey?: string;
    /**
    * MongoDB Atlas project ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_atlas_project_id ProducerMongo#mongodb_atlas_project_id}
    */
    readonly mongodbAtlasProjectId?: string;
    /**
    * MongoDB server default authentication database
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_default_auth_db ProducerMongo#mongodb_default_auth_db}
    */
    readonly mongodbDefaultAuthDb?: string;
    /**
    * host:port (e.g. my.mongo.db:27017)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_host_port ProducerMongo#mongodb_host_port}
    */
    readonly mongodbHostPort?: string;
    /**
    * MongoDB name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_name ProducerMongo#mongodb_name}
    */
    readonly mongodbName?: string;
    /**
    * MongoDB server password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_password ProducerMongo#mongodb_password}
    */
    readonly mongodbPassword?: string;
    /**
    * MongoDB roles (e.g. MongoDB:[{role:readWrite, db: sales}], MongoDB Atlas:[{roleName : readWrite, databaseName: sales}])
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_roles ProducerMongo#mongodb_roles}
    */
    readonly mongodbRoles?: string;
    /**
    * MongoDB server URI (e.g. mongodb://user:password@my.mongo.db:27017/admin?replicaSet=mySet)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_server_uri ProducerMongo#mongodb_server_uri}
    */
    readonly mongodbServerUri?: string;
    /**
    * MongoDB server URI options (e.g. replicaSet=mySet&authSource=authDB)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_uri_options ProducerMongo#mongodb_uri_options}
    */
    readonly mongodbUriOptions?: string;
    /**
    * MongoDB server username
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#mongodb_username ProducerMongo#mongodb_username}
    */
    readonly mongodbUsername?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#name ProducerMongo#name}
    */
    readonly name: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#producer_encryption_key_name ProducerMongo#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#secure_access_bastion_issuer ProducerMongo#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#secure_access_db_name ProducerMongo#secure_access_db_name}
    */
    readonly secureAccessDbName?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#secure_access_enable ProducerMongo#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Target DB servers for connections., For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#secure_access_host ProducerMongo#secure_access_host}
    */
    readonly secureAccessHost?: string[];
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#secure_access_web ProducerMongo#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#tags ProducerMongo#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#target_name ProducerMongo#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL (e.g. 60s, 60m, 60h)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#user_ttl ProducerMongo#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo akeyless_producer_mongo}
*/
export declare class ProducerMongo extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_mongo";
    /**
    * Generates CDKTF code for importing a ProducerMongo resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerMongo to import
    * @param importFromId The id of the existing ProducerMongo that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerMongo to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo akeyless_producer_mongo} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerMongoConfig
    */
    constructor(scope: Construct, id: string, config: ProducerMongoConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mongodbAtlasApiPrivateKey?;
    get mongodbAtlasApiPrivateKey(): string;
    set mongodbAtlasApiPrivateKey(value: string);
    resetMongodbAtlasApiPrivateKey(): void;
    get mongodbAtlasApiPrivateKeyInput(): string | undefined;
    private _mongodbAtlasApiPublicKey?;
    get mongodbAtlasApiPublicKey(): string;
    set mongodbAtlasApiPublicKey(value: string);
    resetMongodbAtlasApiPublicKey(): void;
    get mongodbAtlasApiPublicKeyInput(): string | undefined;
    private _mongodbAtlasProjectId?;
    get mongodbAtlasProjectId(): string;
    set mongodbAtlasProjectId(value: string);
    resetMongodbAtlasProjectId(): void;
    get mongodbAtlasProjectIdInput(): string | undefined;
    private _mongodbDefaultAuthDb?;
    get mongodbDefaultAuthDb(): string;
    set mongodbDefaultAuthDb(value: string);
    resetMongodbDefaultAuthDb(): void;
    get mongodbDefaultAuthDbInput(): string | undefined;
    private _mongodbHostPort?;
    get mongodbHostPort(): string;
    set mongodbHostPort(value: string);
    resetMongodbHostPort(): void;
    get mongodbHostPortInput(): string | undefined;
    private _mongodbName?;
    get mongodbName(): string;
    set mongodbName(value: string);
    resetMongodbName(): void;
    get mongodbNameInput(): string | undefined;
    private _mongodbPassword?;
    get mongodbPassword(): string;
    set mongodbPassword(value: string);
    resetMongodbPassword(): void;
    get mongodbPasswordInput(): string | undefined;
    private _mongodbRoles?;
    get mongodbRoles(): string;
    set mongodbRoles(value: string);
    resetMongodbRoles(): void;
    get mongodbRolesInput(): string | undefined;
    private _mongodbServerUri?;
    get mongodbServerUri(): string;
    set mongodbServerUri(value: string);
    resetMongodbServerUri(): void;
    get mongodbServerUriInput(): string | undefined;
    private _mongodbUriOptions?;
    get mongodbUriOptions(): string;
    set mongodbUriOptions(value: string);
    resetMongodbUriOptions(): void;
    get mongodbUriOptionsInput(): string | undefined;
    private _mongodbUsername?;
    get mongodbUsername(): string;
    set mongodbUsername(value: string);
    resetMongodbUsername(): void;
    get mongodbUsernameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessDbName?;
    get secureAccessDbName(): string;
    set secureAccessDbName(value: string);
    resetSecureAccessDbName(): void;
    get secureAccessDbNameInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessHost?;
    get secureAccessHost(): string[];
    set secureAccessHost(value: string[]);
    resetSecureAccessHost(): void;
    get secureAccessHostInput(): string[] | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
