import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerRdpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable fixed user only
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#fixed_user_only ProducerRdp#fixed_user_only}
    */
    readonly fixedUserOnly?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#id ProducerRdp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#name ProducerRdp#name}
    */
    readonly name: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#producer_encryption_key_name ProducerRdp#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * RDP Admin name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#rdp_admin_name ProducerRdp#rdp_admin_name}
    */
    readonly rdpAdminName?: string;
    /**
    * RDP Admin Password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#rdp_admin_pwd ProducerRdp#rdp_admin_pwd}
    */
    readonly rdpAdminPwd?: string;
    /**
    * RDP Host name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#rdp_host_name ProducerRdp#rdp_host_name}
    */
    readonly rdpHostName?: string;
    /**
    * RDP Host port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#rdp_host_port ProducerRdp#rdp_host_port}
    */
    readonly rdpHostPort?: string;
    /**
    * RDP UserGroup name(s). Multiple values should be separated by comma
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#rdp_user_groups ProducerRdp#rdp_user_groups}
    */
    readonly rdpUserGroups?: string;
    /**
    * Allow providing external user for a domain users
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#secure_access_allow_external_user ProducerRdp#secure_access_allow_external_user}
    */
    readonly secureAccessAllowExternalUser?: boolean | cdktf.IResolvable;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#secure_access_enable ProducerRdp#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Target servers for connections., For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#secure_access_host ProducerRdp#secure_access_host}
    */
    readonly secureAccessHost?: string[];
    /**
    * Required when the Dynamic Secret is used for a domain user
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#secure_access_rdp_domain ProducerRdp#secure_access_rdp_domain}
    */
    readonly secureAccessRdpDomain?: string;
    /**
    * Override the RDP Domain username
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#secure_access_rdp_user ProducerRdp#secure_access_rdp_user}
    */
    readonly secureAccessRdpUser?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#secure_access_web ProducerRdp#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#tags ProducerRdp#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#target_name ProducerRdp#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#user_ttl ProducerRdp#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp akeyless_producer_rdp}
*/
export declare class ProducerRdp extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_rdp";
    /**
    * Generates CDKTF code for importing a ProducerRdp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerRdp to import
    * @param importFromId The id of the existing ProducerRdp that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerRdp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_rdp akeyless_producer_rdp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerRdpConfig
    */
    constructor(scope: Construct, id: string, config: ProducerRdpConfig);
    private _fixedUserOnly?;
    get fixedUserOnly(): string;
    set fixedUserOnly(value: string);
    resetFixedUserOnly(): void;
    get fixedUserOnlyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _rdpAdminName?;
    get rdpAdminName(): string;
    set rdpAdminName(value: string);
    resetRdpAdminName(): void;
    get rdpAdminNameInput(): string | undefined;
    private _rdpAdminPwd?;
    get rdpAdminPwd(): string;
    set rdpAdminPwd(value: string);
    resetRdpAdminPwd(): void;
    get rdpAdminPwdInput(): string | undefined;
    private _rdpHostName?;
    get rdpHostName(): string;
    set rdpHostName(value: string);
    resetRdpHostName(): void;
    get rdpHostNameInput(): string | undefined;
    private _rdpHostPort?;
    get rdpHostPort(): string;
    set rdpHostPort(value: string);
    resetRdpHostPort(): void;
    get rdpHostPortInput(): string | undefined;
    private _rdpUserGroups?;
    get rdpUserGroups(): string;
    set rdpUserGroups(value: string);
    resetRdpUserGroups(): void;
    get rdpUserGroupsInput(): string | undefined;
    private _secureAccessAllowExternalUser?;
    get secureAccessAllowExternalUser(): boolean | cdktf.IResolvable;
    set secureAccessAllowExternalUser(value: boolean | cdktf.IResolvable);
    resetSecureAccessAllowExternalUser(): void;
    get secureAccessAllowExternalUserInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessHost?;
    get secureAccessHost(): string[];
    set secureAccessHost(value: string[]);
    resetSecureAccessHost(): void;
    get secureAccessHostInput(): string[] | undefined;
    private _secureAccessRdpDomain?;
    get secureAccessRdpDomain(): string;
    set secureAccessRdpDomain(value: string);
    resetSecureAccessRdpDomain(): void;
    get secureAccessRdpDomainInput(): string | undefined;
    private _secureAccessRdpUser?;
    get secureAccessRdpUser(): string;
    set secureAccessRdpUser(value: string);
    resetSecureAccessRdpUser(): void;
    get secureAccessRdpUserInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
