import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AkeylessProviderConfig {
    /**
    * Origin URL of the API Gateway server. This is a URL with a scheme, a hostname and a port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#api_gateway_address AkeylessProvider#api_gateway_address}
    */
    readonly apiGatewayAddress?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#alias AkeylessProvider#alias}
    */
    readonly alias?: string;
    /**
    * api_key_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#api_key_login AkeylessProvider#api_key_login}
    */
    readonly apiKeyLogin?: AkeylessProviderApiKeyLogin[] | cdktf.IResolvable;
    /**
    * aws_iam_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#aws_iam_login AkeylessProvider#aws_iam_login}
    */
    readonly awsIamLogin?: AkeylessProviderAwsIamLogin[] | cdktf.IResolvable;
    /**
    * azure_ad_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#azure_ad_login AkeylessProvider#azure_ad_login}
    */
    readonly azureAdLogin?: AkeylessProviderAzureAdLogin[] | cdktf.IResolvable;
    /**
    * cert_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#cert_login AkeylessProvider#cert_login}
    */
    readonly certLogin?: AkeylessProviderCertLogin[] | cdktf.IResolvable;
    /**
    * email_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#email_login AkeylessProvider#email_login}
    */
    readonly emailLogin?: AkeylessProviderEmailLogin[] | cdktf.IResolvable;
    /**
    * gcp_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#gcp_login AkeylessProvider#gcp_login}
    */
    readonly gcpLogin?: AkeylessProviderGcpLogin[] | cdktf.IResolvable;
    /**
    * jwt_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#jwt_login AkeylessProvider#jwt_login}
    */
    readonly jwtLogin?: AkeylessProviderJwtLogin[] | cdktf.IResolvable;
    /**
    * token_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#token_login AkeylessProvider#token_login}
    */
    readonly tokenLogin?: AkeylessProviderTokenLogin[] | cdktf.IResolvable;
    /**
    * uid_login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#uid_login AkeylessProvider#uid_login}
    */
    readonly uidLogin?: AkeylessProviderUidLogin[] | cdktf.IResolvable;
}
export interface AkeylessProviderApiKeyLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#access_id AkeylessProvider#access_id}
    */
    readonly accessId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#access_key AkeylessProvider#access_key}
    */
    readonly accessKey: string;
}
export declare function akeylessProviderApiKeyLoginToTerraform(struct?: AkeylessProviderApiKeyLogin | cdktf.IResolvable): any;
export declare function akeylessProviderApiKeyLoginToHclTerraform(struct?: AkeylessProviderApiKeyLogin | cdktf.IResolvable): any;
export interface AkeylessProviderAwsIamLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#access_id AkeylessProvider#access_id}
    */
    readonly accessId: string;
}
export declare function akeylessProviderAwsIamLoginToTerraform(struct?: AkeylessProviderAwsIamLogin | cdktf.IResolvable): any;
export declare function akeylessProviderAwsIamLoginToHclTerraform(struct?: AkeylessProviderAwsIamLogin | cdktf.IResolvable): any;
export interface AkeylessProviderAzureAdLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#access_id AkeylessProvider#access_id}
    */
    readonly accessId: string;
}
export declare function akeylessProviderAzureAdLoginToTerraform(struct?: AkeylessProviderAzureAdLogin | cdktf.IResolvable): any;
export declare function akeylessProviderAzureAdLoginToHclTerraform(struct?: AkeylessProviderAzureAdLogin | cdktf.IResolvable): any;
export interface AkeylessProviderCertLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#access_id AkeylessProvider#access_id}
    */
    readonly accessId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#cert_data AkeylessProvider#cert_data}
    */
    readonly certData?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#cert_file_name AkeylessProvider#cert_file_name}
    */
    readonly certFileName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#key_data AkeylessProvider#key_data}
    */
    readonly keyData?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#key_file_name AkeylessProvider#key_file_name}
    */
    readonly keyFileName?: string;
}
export declare function akeylessProviderCertLoginToTerraform(struct?: AkeylessProviderCertLogin | cdktf.IResolvable): any;
export declare function akeylessProviderCertLoginToHclTerraform(struct?: AkeylessProviderCertLogin | cdktf.IResolvable): any;
export interface AkeylessProviderEmailLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#admin_email AkeylessProvider#admin_email}
    */
    readonly adminEmail: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#admin_password AkeylessProvider#admin_password}
    */
    readonly adminPassword: string;
}
export declare function akeylessProviderEmailLoginToTerraform(struct?: AkeylessProviderEmailLogin | cdktf.IResolvable): any;
export declare function akeylessProviderEmailLoginToHclTerraform(struct?: AkeylessProviderEmailLogin | cdktf.IResolvable): any;
export interface AkeylessProviderGcpLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#access_id AkeylessProvider#access_id}
    */
    readonly accessId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#audience AkeylessProvider#audience}
    */
    readonly audience?: string;
}
export declare function akeylessProviderGcpLoginToTerraform(struct?: AkeylessProviderGcpLogin | cdktf.IResolvable): any;
export declare function akeylessProviderGcpLoginToHclTerraform(struct?: AkeylessProviderGcpLogin | cdktf.IResolvable): any;
export interface AkeylessProviderJwtLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#access_id AkeylessProvider#access_id}
    */
    readonly accessId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#jwt AkeylessProvider#jwt}
    */
    readonly jwt: string;
}
export declare function akeylessProviderJwtLoginToTerraform(struct?: AkeylessProviderJwtLogin | cdktf.IResolvable): any;
export declare function akeylessProviderJwtLoginToHclTerraform(struct?: AkeylessProviderJwtLogin | cdktf.IResolvable): any;
export interface AkeylessProviderTokenLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#token AkeylessProvider#token}
    */
    readonly token: string;
}
export declare function akeylessProviderTokenLoginToTerraform(struct?: AkeylessProviderTokenLogin | cdktf.IResolvable): any;
export declare function akeylessProviderTokenLoginToHclTerraform(struct?: AkeylessProviderTokenLogin | cdktf.IResolvable): any;
export interface AkeylessProviderUidLogin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#access_id AkeylessProvider#access_id}
    */
    readonly accessId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#uid_token AkeylessProvider#uid_token}
    */
    readonly uidToken: string;
}
export declare function akeylessProviderUidLoginToTerraform(struct?: AkeylessProviderUidLogin | cdktf.IResolvable): any;
export declare function akeylessProviderUidLoginToHclTerraform(struct?: AkeylessProviderUidLogin | cdktf.IResolvable): any;
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs akeyless}
*/
export declare class AkeylessProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "akeyless";
    /**
    * Generates CDKTF code for importing a AkeylessProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AkeylessProvider to import
    * @param importFromId The id of the existing AkeylessProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AkeylessProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs akeyless} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AkeylessProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AkeylessProviderConfig);
    private _apiGatewayAddress?;
    get apiGatewayAddress(): string | undefined;
    set apiGatewayAddress(value: string | undefined);
    resetApiGatewayAddress(): void;
    get apiGatewayAddressInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _apiKeyLogin?;
    get apiKeyLogin(): AkeylessProviderApiKeyLogin[] | cdktf.IResolvable | undefined;
    set apiKeyLogin(value: AkeylessProviderApiKeyLogin[] | cdktf.IResolvable | undefined);
    resetApiKeyLogin(): void;
    get apiKeyLoginInput(): cdktf.IResolvable | AkeylessProviderApiKeyLogin[] | undefined;
    private _awsIamLogin?;
    get awsIamLogin(): AkeylessProviderAwsIamLogin[] | cdktf.IResolvable | undefined;
    set awsIamLogin(value: AkeylessProviderAwsIamLogin[] | cdktf.IResolvable | undefined);
    resetAwsIamLogin(): void;
    get awsIamLoginInput(): cdktf.IResolvable | AkeylessProviderAwsIamLogin[] | undefined;
    private _azureAdLogin?;
    get azureAdLogin(): AkeylessProviderAzureAdLogin[] | cdktf.IResolvable | undefined;
    set azureAdLogin(value: AkeylessProviderAzureAdLogin[] | cdktf.IResolvable | undefined);
    resetAzureAdLogin(): void;
    get azureAdLoginInput(): cdktf.IResolvable | AkeylessProviderAzureAdLogin[] | undefined;
    private _certLogin?;
    get certLogin(): AkeylessProviderCertLogin[] | cdktf.IResolvable | undefined;
    set certLogin(value: AkeylessProviderCertLogin[] | cdktf.IResolvable | undefined);
    resetCertLogin(): void;
    get certLoginInput(): cdktf.IResolvable | AkeylessProviderCertLogin[] | undefined;
    private _emailLogin?;
    get emailLogin(): AkeylessProviderEmailLogin[] | cdktf.IResolvable | undefined;
    set emailLogin(value: AkeylessProviderEmailLogin[] | cdktf.IResolvable | undefined);
    resetEmailLogin(): void;
    get emailLoginInput(): cdktf.IResolvable | AkeylessProviderEmailLogin[] | undefined;
    private _gcpLogin?;
    get gcpLogin(): AkeylessProviderGcpLogin[] | cdktf.IResolvable | undefined;
    set gcpLogin(value: AkeylessProviderGcpLogin[] | cdktf.IResolvable | undefined);
    resetGcpLogin(): void;
    get gcpLoginInput(): cdktf.IResolvable | AkeylessProviderGcpLogin[] | undefined;
    private _jwtLogin?;
    get jwtLogin(): AkeylessProviderJwtLogin[] | cdktf.IResolvable | undefined;
    set jwtLogin(value: AkeylessProviderJwtLogin[] | cdktf.IResolvable | undefined);
    resetJwtLogin(): void;
    get jwtLoginInput(): cdktf.IResolvable | AkeylessProviderJwtLogin[] | undefined;
    private _tokenLogin?;
    get tokenLogin(): AkeylessProviderTokenLogin[] | cdktf.IResolvable | undefined;
    set tokenLogin(value: AkeylessProviderTokenLogin[] | cdktf.IResolvable | undefined);
    resetTokenLogin(): void;
    get tokenLoginInput(): cdktf.IResolvable | AkeylessProviderTokenLogin[] | undefined;
    private _uidLogin?;
    get uidLogin(): AkeylessProviderUidLogin[] | cdktf.IResolvable | undefined;
    set uidLogin(value: AkeylessProviderUidLogin[] | cdktf.IResolvable | undefined);
    resetUidLogin(): void;
    get uidLoginInput(): cdktf.IResolvable | AkeylessProviderUidLogin[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
