import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allow this role to view analytics. Currently only 'none', 'own' and 'all' values are supported, allowing associated auth methods to view reports produced by the same auth methods.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#analytics_access Role#analytics_access}
    */
    readonly analyticsAccess?: string;
    /**
    * Allow this role to view audit logs. Currently only 'none', 'own' and 'all' values are supported, allowing associated auth methods to view audit logs produced by the same auth methods.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#audit_access Role#audit_access}
    */
    readonly auditAccess?: string;
    /**
    * Protection from accidental deletion of this role, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#delete_protection Role#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#description Role#description}
    */
    readonly description?: string;
    /**
    * Allow this role to view Event Center. Currently only 'none', 'own' and 'all' values are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#event_center_access Role#event_center_access}
    */
    readonly eventCenterAccess?: string;
    /**
    * Allow this role to manage Event Forwarders. Currently only 'none' and 'all' values are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#event_forwarders_access Role#event_forwarders_access}
    */
    readonly eventForwardersAccess?: string;
    /**
    * Allow this role to view gw analytics. Currently only 'none', 'own' and 'all' values are supported, allowing associated auth methods to view reports produced by the same auth methods.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#gw_analytics_access Role#gw_analytics_access}
    */
    readonly gwAnalyticsAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#id Role#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Role name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#name Role#name}
    */
    readonly name: string;
    /**
    * Allow this role to view SRA Clusters. Currently only 'none', 'own' and 'all' values are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#sra_reports_access Role#sra_reports_access}
    */
    readonly sraReportsAccess?: string;
    /**
    * Allow this role to view Usage reports. Currently only 'none' and 'all' values are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#usage_reports_access Role#usage_reports_access}
    */
    readonly usageReportsAccess?: string;
    /**
    * assoc_auth_method block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#assoc_auth_method Role#assoc_auth_method}
    */
    readonly assocAuthMethod?: RoleAssocAuthMethod[] | cdktf.IResolvable;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#rules Role#rules}
    */
    readonly rules?: RoleRules[] | cdktf.IResolvable;
}
export interface RoleRestrictedRules {
}
export declare function roleRestrictedRulesToTerraform(struct?: RoleRestrictedRules): any;
export declare function roleRestrictedRulesToHclTerraform(struct?: RoleRestrictedRules): any;
export declare class RoleRestrictedRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RoleRestrictedRules | undefined;
    set internalValue(value: RoleRestrictedRules | undefined);
    get capability(): string[];
    get path(): string;
    get ruleType(): string;
}
export declare class RoleRestrictedRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RoleRestrictedRulesOutputReference;
}
export interface RoleAssocAuthMethod {
    /**
    * The auth method to associate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#am_name Role#am_name}
    */
    readonly amName: string;
    /**
    * Treat sub claims as case-sensitive
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#case_sensitive Role#case_sensitive}
    */
    readonly caseSensitive?: string;
    /**
    * key/val of sub claims, e.g group=admins,developers
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#sub_claims Role#sub_claims}
    */
    readonly subClaims?: {
        [key: string]: string;
    };
}
export declare function roleAssocAuthMethodToTerraform(struct?: RoleAssocAuthMethod | cdktf.IResolvable): any;
export declare function roleAssocAuthMethodToHclTerraform(struct?: RoleAssocAuthMethod | cdktf.IResolvable): any;
export declare class RoleAssocAuthMethodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RoleAssocAuthMethod | cdktf.IResolvable | undefined;
    set internalValue(value: RoleAssocAuthMethod | cdktf.IResolvable | undefined);
    get accessId(): string;
    private _amName?;
    get amName(): string;
    set amName(value: string);
    get amNameInput(): string | undefined;
    get assocId(): string;
    private _caseSensitive?;
    get caseSensitive(): string;
    set caseSensitive(value: string);
    resetCaseSensitive(): void;
    get caseSensitiveInput(): string | undefined;
    private _subClaims?;
    get subClaims(): {
        [key: string]: string;
    };
    set subClaims(value: {
        [key: string]: string;
    });
    resetSubClaims(): void;
    get subClaimsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class RoleAssocAuthMethodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RoleAssocAuthMethod[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RoleAssocAuthMethodOutputReference;
}
export interface RoleRules {
    /**
    * List of the approved/denied capabilities in the path options: [read, create, update, delete, list, deny] for sra-rule type: [allow_access, request_access, justify_access_only, approval_authority, upload_files, download_files]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#capability Role#capability}
    */
    readonly capability: string[];
    /**
    * The path the rule refers to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#path Role#path}
    */
    readonly path: string;
    /**
    * item-rule, target-rule, role-rule, auth-method-rule, sra-rule
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#rule_type Role#rule_type}
    */
    readonly ruleType?: string;
}
export declare function roleRulesToTerraform(struct?: RoleRules | cdktf.IResolvable): any;
export declare function roleRulesToHclTerraform(struct?: RoleRules | cdktf.IResolvable): any;
export declare class RoleRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RoleRules | cdktf.IResolvable | undefined;
    set internalValue(value: RoleRules | cdktf.IResolvable | undefined);
    private _capability?;
    get capability(): string[];
    set capability(value: string[]);
    get capabilityInput(): string[] | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _ruleType?;
    get ruleType(): string;
    set ruleType(value: string);
    resetRuleType(): void;
    get ruleTypeInput(): string | undefined;
}
export declare class RoleRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RoleRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RoleRulesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role akeyless_role}
*/
export declare class Role extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_role";
    /**
    * Generates CDKTF code for importing a Role resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Role to import
    * @param importFromId The id of the existing Role that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Role to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/role akeyless_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleConfig
    */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _analyticsAccess?;
    get analyticsAccess(): string;
    set analyticsAccess(value: string);
    resetAnalyticsAccess(): void;
    get analyticsAccessInput(): string | undefined;
    private _auditAccess?;
    get auditAccess(): string;
    set auditAccess(value: string);
    resetAuditAccess(): void;
    get auditAccessInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eventCenterAccess?;
    get eventCenterAccess(): string;
    set eventCenterAccess(value: string);
    resetEventCenterAccess(): void;
    get eventCenterAccessInput(): string | undefined;
    private _eventForwardersAccess?;
    get eventForwardersAccess(): string;
    set eventForwardersAccess(value: string);
    resetEventForwardersAccess(): void;
    get eventForwardersAccessInput(): string | undefined;
    private _gwAnalyticsAccess?;
    get gwAnalyticsAccess(): string;
    set gwAnalyticsAccess(value: string);
    resetGwAnalyticsAccess(): void;
    get gwAnalyticsAccessInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _restrictedRules;
    get restrictedRules(): RoleRestrictedRulesList;
    private _sraReportsAccess?;
    get sraReportsAccess(): string;
    set sraReportsAccess(value: string);
    resetSraReportsAccess(): void;
    get sraReportsAccessInput(): string | undefined;
    private _usageReportsAccess?;
    get usageReportsAccess(): string;
    set usageReportsAccess(value: string);
    resetUsageReportsAccess(): void;
    get usageReportsAccessInput(): string | undefined;
    private _assocAuthMethod;
    get assocAuthMethod(): RoleAssocAuthMethodList;
    putAssocAuthMethod(value: RoleAssocAuthMethod[] | cdktf.IResolvable): void;
    resetAssocAuthMethod(): void;
    get assocAuthMethodInput(): cdktf.IResolvable | RoleAssocAuthMethod[] | undefined;
    private _rules;
    get rules(): RoleRulesList;
    putRules(value: RoleRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | RoleRules[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
