import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RotatedSecretAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * API ID to rotate (relevant only for rotator-type=api-key)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#api_id RotatedSecretAws#api_id}
    */
    readonly apiId?: string;
    /**
    * API key to rotate (relevant only for rotator-type=api-key)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#api_key RotatedSecretAws#api_key}
    */
    readonly apiKey?: string;
    /**
    * The credentials to connect with [use-self-creds/use-target-creds]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#authentication_credentials RotatedSecretAws#authentication_credentials}
    */
    readonly authenticationCredentials?: string;
    /**
    * Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#auto_rotate RotatedSecretAws#auto_rotate}
    */
    readonly autoRotate?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#description RotatedSecretAws#description}
    */
    readonly description?: string;
    /**
    * Create a new access key without deleting the old key from AWS for backup (relevant only for AWS) [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#grace_rotation RotatedSecretAws#grace_rotation}
    */
    readonly graceRotation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#id RotatedSecretAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of a key that is used to encrypt the secret value (if empty, the account default protectionKey key will be used)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#key RotatedSecretAws#key}
    */
    readonly key?: string;
    /**
    * Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#name RotatedSecretAws#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#password_length RotatedSecretAws#password_length}
    */
    readonly passwordLength?: string;
    /**
    * The Hour of the rotation in UTC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#rotation_hour RotatedSecretAws#rotation_hour}
    */
    readonly rotationHour?: number;
    /**
    * The number of days to wait between every automatic rotation (1-365),custom rotator interval will be set in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#rotation_interval RotatedSecretAws#rotation_interval}
    */
    readonly rotationInterval?: string;
    /**
    * The rotator type [target/api-key]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#rotator_type RotatedSecretAws#rotator_type}
    */
    readonly rotatorType: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#tags RotatedSecretAws#tags}
    */
    readonly tags?: string[];
    /**
    * The target name to associate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#target_name RotatedSecretAws#target_name}
    */
    readonly targetName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws akeyless_rotated_secret_aws}
*/
export declare class RotatedSecretAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_rotated_secret_aws";
    /**
    * Generates CDKTF code for importing a RotatedSecretAws resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RotatedSecretAws to import
    * @param importFromId The id of the existing RotatedSecretAws that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RotatedSecretAws to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_aws akeyless_rotated_secret_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RotatedSecretAwsConfig
    */
    constructor(scope: Construct, id: string, config: RotatedSecretAwsConfig);
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    resetApiId(): void;
    get apiIdInput(): string | undefined;
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _authenticationCredentials?;
    get authenticationCredentials(): string;
    set authenticationCredentials(value: string);
    resetAuthenticationCredentials(): void;
    get authenticationCredentialsInput(): string | undefined;
    private _autoRotate?;
    get autoRotate(): string;
    set autoRotate(value: string);
    resetAutoRotate(): void;
    get autoRotateInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _graceRotation?;
    get graceRotation(): string;
    set graceRotation(value: string);
    resetGraceRotation(): void;
    get graceRotationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _rotationHour?;
    get rotationHour(): number;
    set rotationHour(value: number);
    resetRotationHour(): void;
    get rotationHourInput(): number | undefined;
    private _rotationInterval?;
    get rotationInterval(): string;
    set rotationInterval(value: string);
    resetRotationInterval(): void;
    get rotationIntervalInput(): string | undefined;
    private _rotatorType?;
    get rotatorType(): string;
    set rotatorType(value: string);
    get rotatorTypeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    get targetNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
