import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RotatedSecretAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * API ID to rotate (relevant only for rotator-type=api-key)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#api_id RotatedSecretAzure#api_id}
    */
    readonly apiId?: string;
    /**
    * API key to rotate (relevant only for rotator-type=api-key)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#api_key RotatedSecretAzure#api_key}
    */
    readonly apiKey?: string;
    /**
    * Id of the azure app that hold the serect to be rotated (relevant only for rotator-type=api-key & authentication-credentials=use-target-creds)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#app_id RotatedSecretAzure#app_id}
    */
    readonly appId?: string;
    /**
    * The credentials to connect with [use-self-creds/use-target-creds]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#authentication_credentials RotatedSecretAzure#authentication_credentials}
    */
    readonly authenticationCredentials?: string;
    /**
    * Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#auto_rotate RotatedSecretAzure#auto_rotate}
    */
    readonly autoRotate?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#description RotatedSecretAzure#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#id RotatedSecretAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of a key that is used to encrypt the secret value (if empty, the account default protectionKey key will be used)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#key RotatedSecretAzure#key}
    */
    readonly key?: string;
    /**
    * Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#name RotatedSecretAzure#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#password_length RotatedSecretAzure#password_length}
    */
    readonly passwordLength?: string;
    /**
    * The Hour of the rotation in UTC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#rotation_hour RotatedSecretAzure#rotation_hour}
    */
    readonly rotationHour?: number;
    /**
    * The number of days to wait between every automatic rotation (1-365),custom rotator interval will be set in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#rotation_interval RotatedSecretAzure#rotation_interval}
    */
    readonly rotationInterval?: string;
    /**
    * The rotator type [target/password/api-key/azure-storage-account]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#rotator_type RotatedSecretAzure#rotator_type}
    */
    readonly rotatorType: string;
    /**
    * The name of the storage account key to rotate [key1/key2/kerb1/kerb2] (relevat to azure-storage-account)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#storage_account_key_name RotatedSecretAzure#storage_account_key_name}
    */
    readonly storageAccountKeyName?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#tags RotatedSecretAzure#tags}
    */
    readonly tags?: string[];
    /**
    * The target name to associate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#target_name RotatedSecretAzure#target_name}
    */
    readonly targetName: string;
    /**
    * The user principal name to rotate his password (relevant only for rotator-type=password)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#username RotatedSecretAzure#username}
    */
    readonly username?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure akeyless_rotated_secret_azure}
*/
export declare class RotatedSecretAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_rotated_secret_azure";
    /**
    * Generates CDKTF code for importing a RotatedSecretAzure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RotatedSecretAzure to import
    * @param importFromId The id of the existing RotatedSecretAzure that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RotatedSecretAzure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_azure akeyless_rotated_secret_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RotatedSecretAzureConfig
    */
    constructor(scope: Construct, id: string, config: RotatedSecretAzureConfig);
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    resetApiId(): void;
    get apiIdInput(): string | undefined;
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _appId?;
    get appId(): string;
    set appId(value: string);
    resetAppId(): void;
    get appIdInput(): string | undefined;
    private _authenticationCredentials?;
    get authenticationCredentials(): string;
    set authenticationCredentials(value: string);
    resetAuthenticationCredentials(): void;
    get authenticationCredentialsInput(): string | undefined;
    private _autoRotate?;
    get autoRotate(): string;
    set autoRotate(value: string);
    resetAutoRotate(): void;
    get autoRotateInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _rotationHour?;
    get rotationHour(): number;
    set rotationHour(value: number);
    resetRotationHour(): void;
    get rotationHourInput(): number | undefined;
    private _rotationInterval?;
    get rotationInterval(): string;
    set rotationInterval(value: string);
    resetRotationInterval(): void;
    get rotationIntervalInput(): string | undefined;
    private _rotatorType?;
    get rotatorType(): string;
    set rotatorType(value: string);
    get rotatorTypeInput(): string | undefined;
    private _storageAccountKeyName?;
    get storageAccountKeyName(): string;
    set storageAccountKeyName(value: string);
    resetStorageAccountKeyName(): void;
    get storageAccountKeyNameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    get targetNameInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
