import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RotatedSecretCustomConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#auto_rotate RotatedSecretCustom#auto_rotate}
    */
    readonly autoRotate?: string;
    /**
    * Secret payload to be sent with rotation request
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#custom_payload RotatedSecretCustom#custom_payload}
    */
    readonly customPayload?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#description RotatedSecretCustom#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#id RotatedSecretCustom#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of a key that is used to encrypt the secret value (if empty, the account default protectionKey key will be used)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#key RotatedSecretCustom#key}
    */
    readonly key?: string;
    /**
    * Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#name RotatedSecretCustom#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#password_length RotatedSecretCustom#password_length}
    */
    readonly passwordLength?: string;
    /**
    * The Hour of the rotation in UTC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#rotation_hour RotatedSecretCustom#rotation_hour}
    */
    readonly rotationHour?: number;
    /**
    * The number of days to wait between every automatic rotation (1-365),custom rotator interval will be set in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#rotation_interval RotatedSecretCustom#rotation_interval}
    */
    readonly rotationInterval?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#tags RotatedSecretCustom#tags}
    */
    readonly tags?: string[];
    /**
    * The target name to associate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#target_name RotatedSecretCustom#target_name}
    */
    readonly targetName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom akeyless_rotated_secret_custom}
*/
export declare class RotatedSecretCustom extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_rotated_secret_custom";
    /**
    * Generates CDKTF code for importing a RotatedSecretCustom resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RotatedSecretCustom to import
    * @param importFromId The id of the existing RotatedSecretCustom that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RotatedSecretCustom to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_custom akeyless_rotated_secret_custom} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RotatedSecretCustomConfig
    */
    constructor(scope: Construct, id: string, config: RotatedSecretCustomConfig);
    private _autoRotate?;
    get autoRotate(): string;
    set autoRotate(value: string);
    resetAutoRotate(): void;
    get autoRotateInput(): string | undefined;
    private _customPayload?;
    get customPayload(): string;
    set customPayload(value: string);
    resetCustomPayload(): void;
    get customPayloadInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _rotationHour?;
    get rotationHour(): number;
    set rotationHour(value: number);
    resetRotationHour(): void;
    get rotationHourInput(): number | undefined;
    private _rotationInterval?;
    get rotationInterval(): string;
    set rotationInterval(value: string);
    resetRotationInterval(): void;
    get rotationIntervalInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    get targetNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
