import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RotatedSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * API ID to rotate (relevant only for rotator-type=api-key)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#api_id RotatedSecret#api_id}
    */
    readonly apiId?: string;
    /**
    * API key to rotate (relevant only for rotator-type=api-key)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#api_key RotatedSecret#api_key}
    */
    readonly apiKey?: string;
    /**
    * The credentials to connect with use-user-creds/use-target-creds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#authentication_credentials RotatedSecret#authentication_credentials}
    */
    readonly authenticationCredentials?: string;
    /**
    * Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#auto_rotate RotatedSecret#auto_rotate}
    */
    readonly autoRotate?: string;
    /**
    * Secret payload to be sent with rotation request (relevant only for rotator-type=custom)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#custom_payload RotatedSecret#custom_payload}
    */
    readonly customPayload?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#description RotatedSecret#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#id RotatedSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Retrieve the Secret value without checking the Gateway's cache [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#ignore_cache RotatedSecret#ignore_cache}
    */
    readonly ignoreCache?: string;
    /**
    * The name of a key that is used to encrypt the secret value (if empty, the account default protectionKey key will be used)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#key RotatedSecret#key}
    */
    readonly key?: string;
    /**
    * Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#name RotatedSecret#name}
    */
    readonly name: string;
    /**
    * rotated-username password (relevant only for rotator-type=password)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#rotated_password RotatedSecret#rotated_password}
    */
    readonly rotatedPassword?: string;
    /**
    * username to be rotated, if selected use-self-creds at rotator-creds-type, this username will try to rotate it's own password, if use-target-creds is selected, target credentials will be use to rotate the rotated-password (relevant only for rotator-type=password)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#rotated_username RotatedSecret#rotated_username}
    */
    readonly rotatedUsername?: string;
    /**
    * The Hour of the rotation in UTC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#rotation_hour RotatedSecret#rotation_hour}
    */
    readonly rotationHour?: number;
    /**
    * The number of days to wait between every automatic rotation (1-365),custom rotator interval will be set in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#rotation_interval RotatedSecret#rotation_interval}
    */
    readonly rotationInterval?: string;
    /**
    * Custom rotation command (relevant only for ssh target)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#rotator_custom_cmd RotatedSecret#rotator_custom_cmd}
    */
    readonly rotatorCustomCmd?: string;
    /**
    * The rotator type password/target/api-key/ldap/custom
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#rotator_type RotatedSecret#rotator_type}
    */
    readonly rotatorType: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#tags RotatedSecret#tags}
    */
    readonly tags?: string[];
    /**
    * The target name to associate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#target_name RotatedSecret#target_name}
    */
    readonly targetName: string;
    /**
    * LDAP User Attribute
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#user_attribute RotatedSecret#user_attribute}
    */
    readonly userAttribute?: string;
    /**
    * Base DN to Perform User Search
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#user_dn RotatedSecret#user_dn}
    */
    readonly userDn?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret akeyless_rotated_secret}
*/
export declare class RotatedSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_rotated_secret";
    /**
    * Generates CDKTF code for importing a RotatedSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RotatedSecret to import
    * @param importFromId The id of the existing RotatedSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RotatedSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret akeyless_rotated_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RotatedSecretConfig
    */
    constructor(scope: Construct, id: string, config: RotatedSecretConfig);
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    resetApiId(): void;
    get apiIdInput(): string | undefined;
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _authenticationCredentials?;
    get authenticationCredentials(): string;
    set authenticationCredentials(value: string);
    resetAuthenticationCredentials(): void;
    get authenticationCredentialsInput(): string | undefined;
    private _autoRotate?;
    get autoRotate(): string;
    set autoRotate(value: string);
    resetAutoRotate(): void;
    get autoRotateInput(): string | undefined;
    private _customPayload?;
    get customPayload(): string;
    set customPayload(value: string);
    resetCustomPayload(): void;
    get customPayloadInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreCache?;
    get ignoreCache(): string;
    set ignoreCache(value: string);
    resetIgnoreCache(): void;
    get ignoreCacheInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rotatedPassword?;
    get rotatedPassword(): string;
    set rotatedPassword(value: string);
    resetRotatedPassword(): void;
    get rotatedPasswordInput(): string | undefined;
    private _rotatedUsername?;
    get rotatedUsername(): string;
    set rotatedUsername(value: string);
    resetRotatedUsername(): void;
    get rotatedUsernameInput(): string | undefined;
    private _rotationHour?;
    get rotationHour(): number;
    set rotationHour(value: number);
    resetRotationHour(): void;
    get rotationHourInput(): number | undefined;
    private _rotationInterval?;
    get rotationInterval(): string;
    set rotationInterval(value: string);
    resetRotationInterval(): void;
    get rotationIntervalInput(): string | undefined;
    private _rotatorCustomCmd?;
    get rotatorCustomCmd(): string;
    set rotatorCustomCmd(value: string);
    resetRotatorCustomCmd(): void;
    get rotatorCustomCmdInput(): string | undefined;
    private _rotatorType?;
    get rotatorType(): string;
    set rotatorType(value: string);
    get rotatorTypeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    get targetNameInput(): string | undefined;
    private _userAttribute?;
    get userAttribute(): string;
    set userAttribute(value: string);
    resetUserAttribute(): void;
    get userAttributeInput(): string | undefined;
    private _userDn?;
    get userDn(): string;
    set userDn(value: string);
    resetUserDn(): void;
    get userDnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
