import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StaticSecretSyncConfig extends cdktf.TerraformMetaArguments {
    /**
    * JQ expression to filter or transform the secret value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync#filter_secret_value StaticSecretSync#filter_secret_value}
    */
    readonly filterSecretValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync#id StaticSecretSync#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Static Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync#name StaticSecretSync#name}
    */
    readonly name: string;
    /**
    * Vault namespace, releavnt only for Hashicorp Vault Target
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync#namespace StaticSecretSync#namespace}
    */
    readonly namespace?: string;
    /**
    * Remote Secret Name that will be synced on the remote endpoint
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync#remote_secret_name StaticSecretSync#remote_secret_name}
    */
    readonly remoteSecretName: string;
    /**
    * Universal Secret Connector name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync#usc_name StaticSecretSync#usc_name}
    */
    readonly uscName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync akeyless_static_secret_sync}
*/
export declare class StaticSecretSync extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_static_secret_sync";
    /**
    * Generates CDKTF code for importing a StaticSecretSync resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StaticSecretSync to import
    * @param importFromId The id of the existing StaticSecretSync that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StaticSecretSync to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret_sync akeyless_static_secret_sync} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StaticSecretSyncConfig
    */
    constructor(scope: Construct, id: string, config: StaticSecretSyncConfig);
    private _filterSecretValue?;
    get filterSecretValue(): string;
    set filterSecretValue(value: string);
    resetFilterSecretValue(): void;
    get filterSecretValueInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _remoteSecretName?;
    get remoteSecretName(): string;
    set remoteSecretName(value: string);
    get remoteSecretNameInput(): string | undefined;
    private _uscName?;
    get uscName(): string;
    set uscName(value: string);
    get uscNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
