import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StaticSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Additional custom fields to associate with the item (e.g fieldName1=value1) (relevant only for type 'password')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#custom_field StaticSecret#custom_field}
    */
    readonly customField?: {
        [key: string]: string;
    };
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#delete_protection StaticSecret#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#description StaticSecret#description}
    */
    readonly description?: string;
    /**
    * Secret format [text/json/key-value] (relevant only for type 'generic')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#format StaticSecret#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#id StaticSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Retrieve the Secret value without checking the Gateway's cache [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#ignore_cache StaticSecret#ignore_cache}
    */
    readonly ignoreCache?: string;
    /**
    * List of URLs associated with the item (relevant only for type 'password')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#inject_url StaticSecret#inject_url}
    */
    readonly injectUrl?: string[];
    /**
    * Whether to keep previous version [true/false]. If not set, use default according to account settings
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#keep_prev_version StaticSecret#keep_prev_version}
    */
    readonly keepPrevVersion?: string;
    /**
    * The provided value is a multiline value (separated by '
    * ')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#multiline_value StaticSecret#multiline_value}
    */
    readonly multilineValue?: boolean | cdktf.IResolvable;
    /**
    * Password value (relevant only for type 'password')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#password StaticSecret#password}
    */
    readonly password?: string;
    /**
    * The path where the secret will be stored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#path StaticSecret#path}
    */
    readonly path: string;
    /**
    * The name of a key that is used to encrypt the secret value (if empty, the account default protectionKey key will be used)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#protection_key StaticSecret#protection_key}
    */
    readonly protectionKey?: string;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Secure Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#secure_access_bastion_issuer StaticSecret#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#secure_access_enable StaticSecret#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Target servers for connections., For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#secure_access_host StaticSecret#secure_access_host}
    */
    readonly secureAccessHost?: string[];
    /**
    * Static-Secret values contains SSH Credentials, either Private Key or Password [password/private-key]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#secure_access_ssh_creds StaticSecret#secure_access_ssh_creds}
    */
    readonly secureAccessSshCreds?: string;
    /**
    * Override the SSH username as indicated in SSH Certificate Issuer
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#secure_access_ssh_user StaticSecret#secure_access_ssh_user}
    */
    readonly secureAccessSshUser?: string;
    /**
    * Destination URL to inject secrets.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#secure_access_url StaticSecret#secure_access_url}
    */
    readonly secureAccessUrl?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#secure_access_web StaticSecret#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * Secure browser via Akeyless's Secure Remote Access (SRA)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#secure_access_web_browsing StaticSecret#secure_access_web_browsing}
    */
    readonly secureAccessWebBrowsing?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#tags StaticSecret#tags}
    */
    readonly tags?: string[];
    /**
    * Secret type [generic/password]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#type StaticSecret#type}
    */
    readonly type?: string;
    /**
    * Username value (relevant only for type 'password')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#username StaticSecret#username}
    */
    readonly username?: string;
    /**
    * The secret content.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#value StaticSecret#value}
    */
    readonly value?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret akeyless_static_secret}
*/
export declare class StaticSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_static_secret";
    /**
    * Generates CDKTF code for importing a StaticSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StaticSecret to import
    * @param importFromId The id of the existing StaticSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StaticSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret akeyless_static_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StaticSecretConfig
    */
    constructor(scope: Construct, id: string, config: StaticSecretConfig);
    private _customField?;
    get customField(): {
        [key: string]: string;
    };
    set customField(value: {
        [key: string]: string;
    });
    resetCustomField(): void;
    get customFieldInput(): {
        [key: string]: string;
    } | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreCache?;
    get ignoreCache(): string;
    set ignoreCache(value: string);
    resetIgnoreCache(): void;
    get ignoreCacheInput(): string | undefined;
    private _injectUrl?;
    get injectUrl(): string[];
    set injectUrl(value: string[]);
    resetInjectUrl(): void;
    get injectUrlInput(): string[] | undefined;
    private _keepPrevVersion?;
    get keepPrevVersion(): string;
    set keepPrevVersion(value: string);
    resetKeepPrevVersion(): void;
    get keepPrevVersionInput(): string | undefined;
    private _multilineValue?;
    get multilineValue(): boolean | cdktf.IResolvable;
    set multilineValue(value: boolean | cdktf.IResolvable);
    resetMultilineValue(): void;
    get multilineValueInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _protectionKey?;
    get protectionKey(): string;
    set protectionKey(value: string);
    resetProtectionKey(): void;
    get protectionKeyInput(): string | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessHost?;
    get secureAccessHost(): string[];
    set secureAccessHost(value: string[]);
    resetSecureAccessHost(): void;
    get secureAccessHostInput(): string[] | undefined;
    private _secureAccessSshCreds?;
    get secureAccessSshCreds(): string;
    set secureAccessSshCreds(value: string);
    resetSecureAccessSshCreds(): void;
    get secureAccessSshCredsInput(): string | undefined;
    private _secureAccessSshUser?;
    get secureAccessSshUser(): string;
    set secureAccessSshUser(value: string);
    resetSecureAccessSshUser(): void;
    get secureAccessSshUserInput(): string | undefined;
    private _secureAccessUrl?;
    get secureAccessUrl(): string;
    set secureAccessUrl(value: string);
    resetSecureAccessUrl(): void;
    get secureAccessUrlInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessWebBrowsing?;
    get secureAccessWebBrowsing(): boolean | cdktf.IResolvable;
    set secureAccessWebBrowsing(value: boolean | cdktf.IResolvable);
    resetSecureAccessWebBrowsing(): void;
    get secureAccessWebBrowsingInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    get version(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
