import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetArtifactoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Admin name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory#artifactory_admin_name TargetArtifactory#artifactory_admin_name}
    */
    readonly artifactoryAdminName: string;
    /**
    * Admin API Key/Password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory#artifactory_admin_pwd TargetArtifactory#artifactory_admin_pwd}
    */
    readonly artifactoryAdminPwd: string;
    /**
    * Artifactory REST URL, must end with artifactory postfix
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory#base_url TargetArtifactory#base_url}
    */
    readonly baseUrl: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory#description TargetArtifactory#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory#id TargetArtifactory#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory#key TargetArtifactory#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory#name TargetArtifactory#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory akeyless_target_artifactory}
*/
export declare class TargetArtifactory extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_artifactory";
    /**
    * Generates CDKTF code for importing a TargetArtifactory resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetArtifactory to import
    * @param importFromId The id of the existing TargetArtifactory that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetArtifactory to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_artifactory akeyless_target_artifactory} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetArtifactoryConfig
    */
    constructor(scope: Construct, id: string, config: TargetArtifactoryConfig);
    private _artifactoryAdminName?;
    get artifactoryAdminName(): string;
    set artifactoryAdminName(value: string);
    get artifactoryAdminNameInput(): string | undefined;
    private _artifactoryAdminPwd?;
    get artifactoryAdminPwd(): string;
    set artifactoryAdminPwd(value: string);
    get artifactoryAdminPwdInput(): string | undefined;
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    get baseUrlInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
