import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetEksConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#description TargetEks#description}
    */
    readonly description?: string;
    /**
    * EKS access key ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#eks_access_key_id TargetEks#eks_access_key_id}
    */
    readonly eksAccessKeyId: string;
    /**
    * EKS cluster base-64 encoded certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#eks_cluster_ca_cert TargetEks#eks_cluster_ca_cert}
    */
    readonly eksClusterCaCert: string;
    /**
    * EKS cluster endpoint (i.e., https://<IP> of the cluster)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#eks_cluster_endpoint TargetEks#eks_cluster_endpoint}
    */
    readonly eksClusterEndpoint: string;
    /**
    * EKS cluster name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#eks_cluster_name TargetEks#eks_cluster_name}
    */
    readonly eksClusterName: string;
    /**
    * EKS region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#eks_region TargetEks#eks_region}
    */
    readonly eksRegion?: string;
    /**
    * EKS secret access key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#eks_secret_access_key TargetEks#eks_secret_access_key}
    */
    readonly eksSecretAccessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#id TargetEks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#key TargetEks#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#name TargetEks#name}
    */
    readonly name: string;
    /**
    * Use the GW's Cloud IAM
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#use_gw_cloud_identity TargetEks#use_gw_cloud_identity}
    */
    readonly useGwCloudIdentity?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks akeyless_target_eks}
*/
export declare class TargetEks extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_eks";
    /**
    * Generates CDKTF code for importing a TargetEks resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetEks to import
    * @param importFromId The id of the existing TargetEks that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetEks to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_eks akeyless_target_eks} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetEksConfig
    */
    constructor(scope: Construct, id: string, config: TargetEksConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eksAccessKeyId?;
    get eksAccessKeyId(): string;
    set eksAccessKeyId(value: string);
    get eksAccessKeyIdInput(): string | undefined;
    private _eksClusterCaCert?;
    get eksClusterCaCert(): string;
    set eksClusterCaCert(value: string);
    get eksClusterCaCertInput(): string | undefined;
    private _eksClusterEndpoint?;
    get eksClusterEndpoint(): string;
    set eksClusterEndpoint(value: string);
    get eksClusterEndpointInput(): string | undefined;
    private _eksClusterName?;
    get eksClusterName(): string;
    set eksClusterName(value: string);
    get eksClusterNameInput(): string | undefined;
    private _eksRegion?;
    get eksRegion(): string;
    set eksRegion(value: string);
    resetEksRegion(): void;
    get eksRegionInput(): string | undefined;
    private _eksSecretAccessKey?;
    get eksSecretAccessKey(): string;
    set eksSecretAccessKey(value: string);
    get eksSecretAccessKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _useGwCloudIdentity?;
    get useGwCloudIdentity(): boolean | cdktf.IResolvable;
    set useGwCloudIdentity(value: boolean | cdktf.IResolvable);
    resetUseGwCloudIdentity(): void;
    get useGwCloudIdentityInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
