import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetGkeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#description TargetGke#description}
    */
    readonly description?: string;
    /**
    * GKE service account key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#gke_account_key TargetGke#gke_account_key}
    */
    readonly gkeAccountKey?: string;
    /**
    * GKE Base-64 encoded cluster certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#gke_cluster_cert TargetGke#gke_cluster_cert}
    */
    readonly gkeClusterCert?: string;
    /**
    * GKE cluster endpoint, i.e., cluster URI https://<DNS/IP>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#gke_cluster_endpoint TargetGke#gke_cluster_endpoint}
    */
    readonly gkeClusterEndpoint?: string;
    /**
    * GKE cluster name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#gke_cluster_name TargetGke#gke_cluster_name}
    */
    readonly gkeClusterName?: string;
    /**
    * GKE service account email
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#gke_service_account_email TargetGke#gke_service_account_email}
    */
    readonly gkeServiceAccountEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#id TargetGke#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#key TargetGke#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#name TargetGke#name}
    */
    readonly name: string;
    /**
    * Use the GW's Cloud IAM
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#use_gw_cloud_identity TargetGke#use_gw_cloud_identity}
    */
    readonly useGwCloudIdentity?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke akeyless_target_gke}
*/
export declare class TargetGke extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_gke";
    /**
    * Generates CDKTF code for importing a TargetGke resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetGke to import
    * @param importFromId The id of the existing TargetGke that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetGke to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gke akeyless_target_gke} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetGkeConfig
    */
    constructor(scope: Construct, id: string, config: TargetGkeConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _gkeAccountKey?;
    get gkeAccountKey(): string;
    set gkeAccountKey(value: string);
    resetGkeAccountKey(): void;
    get gkeAccountKeyInput(): string | undefined;
    private _gkeClusterCert?;
    get gkeClusterCert(): string;
    set gkeClusterCert(value: string);
    resetGkeClusterCert(): void;
    get gkeClusterCertInput(): string | undefined;
    private _gkeClusterEndpoint?;
    get gkeClusterEndpoint(): string;
    set gkeClusterEndpoint(value: string);
    resetGkeClusterEndpoint(): void;
    get gkeClusterEndpointInput(): string | undefined;
    private _gkeClusterName?;
    get gkeClusterName(): string;
    set gkeClusterName(value: string);
    resetGkeClusterName(): void;
    get gkeClusterNameInput(): string | undefined;
    private _gkeServiceAccountEmail?;
    get gkeServiceAccountEmail(): string;
    set gkeServiceAccountEmail(value: string);
    resetGkeServiceAccountEmail(): void;
    get gkeServiceAccountEmailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _useGwCloudIdentity?;
    get useGwCloudIdentity(): boolean | cdktf.IResolvable;
    set useGwCloudIdentity(value: boolean | cdktf.IResolvable);
    resetUseGwCloudIdentity(): void;
    get useGwCloudIdentityInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
