import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetSshConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#description TargetSsh#description}
    */
    readonly description?: string;
    /**
    * SSH host name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#host TargetSsh#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#id TargetSsh#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#key TargetSsh#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#name TargetSsh#name}
    */
    readonly name: string;
    /**
    * SSH port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#port TargetSsh#port}
    */
    readonly port?: string;
    /**
    * SSH private key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#private_key TargetSsh#private_key}
    */
    readonly privateKey?: string;
    /**
    * SSH private key password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#private_key_password TargetSsh#private_key_password}
    */
    readonly privateKeyPassword?: string;
    /**
    * SSH password to rotate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#ssh_password TargetSsh#ssh_password}
    */
    readonly sshPassword?: string;
    /**
    * SSH username
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#ssh_username TargetSsh#ssh_username}
    */
    readonly sshUsername?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh akeyless_target_ssh}
*/
export declare class TargetSsh extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_ssh";
    /**
    * Generates CDKTF code for importing a TargetSsh resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetSsh to import
    * @param importFromId The id of the existing TargetSsh that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetSsh to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_ssh akeyless_target_ssh} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetSshConfig
    */
    constructor(scope: Construct, id: string, config: TargetSshConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _privateKeyPassword?;
    get privateKeyPassword(): string;
    set privateKeyPassword(value: string);
    resetPrivateKeyPassword(): void;
    get privateKeyPasswordInput(): string | undefined;
    private _sshPassword?;
    get sshPassword(): string;
    set sshPassword(value: string);
    resetSshPassword(): void;
    get sshPasswordInput(): string | undefined;
    private _sshUsername?;
    get sshUsername(): string;
    set sshUsername(value: string);
    resetSshUsername(): void;
    get sshUsernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
