import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetZerosslConfig extends cdktf.TerraformMetaArguments {
    /**
    * API Key of the ZeroSSLTarget account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#api_key TargetZerossl#api_key}
    */
    readonly apiKey: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#description TargetZerossl#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#id TargetZerossl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * FQDN of the IMAP service
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#imap_fqdn TargetZerossl#imap_fqdn}
    */
    readonly imapFqdn: string;
    /**
    * Password to access the IMAP service
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#imap_password TargetZerossl#imap_password}
    */
    readonly imapPassword: string;
    /**
    * Port of the IMAP service
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#imap_port TargetZerossl#imap_port}
    */
    readonly imapPort?: string;
    /**
    * Email to use when asking ZeroSSL to send a validation email, if empty will use username
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#imap_target_email TargetZerossl#imap_target_email}
    */
    readonly imapTargetEmail?: string;
    /**
    * Username to access the IMAP service
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#imap_username TargetZerossl#imap_username}
    */
    readonly imapUsername: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#key TargetZerossl#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#name TargetZerossl#name}
    */
    readonly name: string;
    /**
    * Timeout waiting for certificate validation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#timeout TargetZerossl#timeout}
    */
    readonly timeout?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl akeyless_target_zerossl}
*/
export declare class TargetZerossl extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_zerossl";
    /**
    * Generates CDKTF code for importing a TargetZerossl resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetZerossl to import
    * @param importFromId The id of the existing TargetZerossl that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetZerossl to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_zerossl akeyless_target_zerossl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetZerosslConfig
    */
    constructor(scope: Construct, id: string, config: TargetZerosslConfig);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imapFqdn?;
    get imapFqdn(): string;
    set imapFqdn(value: string);
    get imapFqdnInput(): string | undefined;
    private _imapPassword?;
    get imapPassword(): string;
    set imapPassword(value: string);
    get imapPasswordInput(): string | undefined;
    private _imapPort?;
    get imapPort(): string;
    set imapPort(value: string);
    resetImapPort(): void;
    get imapPortInput(): string | undefined;
    private _imapTargetEmail?;
    get imapTargetEmail(): string;
    set imapTargetEmail(value: string);
    resetImapTargetEmail(): void;
    get imapTargetEmailInput(): string | undefined;
    private _imapUsername?;
    get imapUsername(): string;
    set imapUsername(value: string);
    get imapUsernameInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
