import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TokenizerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Alphabet to use in custom vaultless tokenization, such as '0123456789' for credit cards.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#alphabet Tokenizer#alphabet}
    */
    readonly alphabet?: string;
    /**
    * The Decoding output template to use in custom vaultless tokenization
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#decoding_template Tokenizer#decoding_template}
    */
    readonly decodingTemplate?: string;
    /**
    * Protection from accidental deletion of this item, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#delete_protection Tokenizer#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#description Tokenizer#description}
    */
    readonly description?: string;
    /**
    * The Encoding output template to use in custom vaultless tokenization
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#encoding_template Tokenizer#encoding_template}
    */
    readonly encodingTemplate?: string;
    /**
    * AES key name to use in vaultless tokenization
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#encryption_key_name Tokenizer#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#id Tokenizer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Tokenizer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#name Tokenizer#name}
    */
    readonly name: string;
    /**
    * Pattern to use in custom vaultless tokenization
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#pattern Tokenizer#pattern}
    */
    readonly pattern?: string;
    /**
    * List of the tags attached to this key. To specify multiple tags use argument multiple times: --tag Tag1 --tag Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#tag Tokenizer#tag}
    */
    readonly tag?: string[];
    /**
    * Which template type this tokenizer is used for [SSN,CreditCard,USPhoneNumber,Custom]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#template_type Tokenizer#template_type}
    */
    readonly templateType: string;
    /**
    * Tokenizer type(vaultless)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#tokenizer_type Tokenizer#tokenizer_type}
    */
    readonly tokenizerType?: string;
    /**
    * The tweak type to use in vaultless tokenization [Supplied, Generated, Internal, Masking]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#tweak_type Tokenizer#tweak_type}
    */
    readonly tweakType?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer akeyless_tokenizer}
*/
export declare class Tokenizer extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_tokenizer";
    /**
    * Generates CDKTF code for importing a Tokenizer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Tokenizer to import
    * @param importFromId The id of the existing Tokenizer that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Tokenizer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/tokenizer akeyless_tokenizer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TokenizerConfig
    */
    constructor(scope: Construct, id: string, config: TokenizerConfig);
    private _alphabet?;
    get alphabet(): string;
    set alphabet(value: string);
    resetAlphabet(): void;
    get alphabetInput(): string | undefined;
    private _decodingTemplate?;
    get decodingTemplate(): string;
    set decodingTemplate(value: string);
    resetDecodingTemplate(): void;
    get decodingTemplateInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _encodingTemplate?;
    get encodingTemplate(): string;
    set encodingTemplate(value: string);
    resetEncodingTemplate(): void;
    get encodingTemplateInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _tag?;
    get tag(): string[];
    set tag(value: string[]);
    resetTag(): void;
    get tagInput(): string[] | undefined;
    private _templateType?;
    get templateType(): string;
    set templateType(value: string);
    get templateTypeInput(): string | undefined;
    private _tokenizerType?;
    get tokenizerType(): string;
    set tokenizerType(value: string);
    resetTokenizerType(): void;
    get tokenizerTypeInput(): string | undefined;
    get tweak(): string;
    private _tweakType?;
    get tweakType(): string;
    set tweakType(value: string);
    resetTweakType(): void;
    get tweakTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
