import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UscConfig extends cdktf.TerraformMetaArguments {
    /**
    * Azure Key Vault name (Relevant only for Azure targets)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#azure_kv_name Usc#azure_kv_name}
    */
    readonly azureKvName?: string;
    /**
    * Protection from accidental deletion of this object, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#delete_protection Usc#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * Description of the Universal Secrets Connector
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#description Usc#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#id Usc#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * K8s namespace (Relevant to Kubernetes targets)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#k8s_namespace Usc#k8s_namespace}
    */
    readonly k8SNamespace?: string;
    /**
    * Universal Secrets Connector name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#name Usc#name}
    */
    readonly name: string;
    /**
    * List of the tags attached to this Universal Secrets Connector
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#tags Usc#tags}
    */
    readonly tags?: string[];
    /**
    * Target Universal Secrets Connector to connect
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#target_to_associate Usc#target_to_associate}
    */
    readonly targetToAssociate: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc akeyless_usc}
*/
export declare class Usc extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_usc";
    /**
    * Generates CDKTF code for importing a Usc resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Usc to import
    * @param importFromId The id of the existing Usc that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Usc to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc akeyless_usc} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UscConfig
    */
    constructor(scope: Construct, id: string, config: UscConfig);
    private _azureKvName?;
    get azureKvName(): string;
    set azureKvName(value: string);
    resetAzureKvName(): void;
    get azureKvNameInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _k8SNamespace?;
    get k8SNamespace(): string;
    set k8SNamespace(value: string);
    resetK8SNamespace(): void;
    get k8SNamespaceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetToAssociate?;
    get targetToAssociate(): string;
    set targetToAssociate(value: string);
    get targetToAssociateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
