# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAccessPolicyIamPolicyResult',
    'AwaitableGetAccessPolicyIamPolicyResult',
    'get_access_policy_iam_policy',
    'get_access_policy_iam_policy_output',
]

@pulumi.output_type
class GetAccessPolicyIamPolicyResult:
    """
    A collection of values returned by getAccessPolicyIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, name=None, policy_data=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> str:
        """
        (Required only by `accesscontextmanager.AccessPolicyIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")


class AwaitableGetAccessPolicyIamPolicyResult(GetAccessPolicyIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessPolicyIamPolicyResult(
            etag=self.etag,
            id=self.id,
            name=self.name,
            policy_data=self.policy_data)


def get_access_policy_iam_policy(name: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessPolicyIamPolicyResult:
    """
    Retrieves the current IAM policy data for accesspolicy

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.accesscontextmanager.get_access_policy_iam_policy(name=google_access_context_manager_access_policy["access-policy"]["name"])
    ```


    :param str name: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:accesscontextmanager/getAccessPolicyIamPolicy:getAccessPolicyIamPolicy', __args__, opts=opts, typ=GetAccessPolicyIamPolicyResult).value

    return AwaitableGetAccessPolicyIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        policy_data=pulumi.get(__ret__, 'policy_data'))


@_utilities.lift_output_func(get_access_policy_iam_policy)
def get_access_policy_iam_policy_output(name: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessPolicyIamPolicyResult]:
    """
    Retrieves the current IAM policy data for accesspolicy

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.accesscontextmanager.get_access_policy_iam_policy(name=google_access_context_manager_access_policy["access-policy"]["name"])
    ```


    :param str name: Used to find the parent resource to bind the IAM policy to
    """
    ...
