# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicePerimeterEgressPolicyArgs', 'ServicePerimeterEgressPolicy']

@pulumi.input_type
class ServicePerimeterEgressPolicyArgs:
    def __init__(__self__, *,
                 perimeter: pulumi.Input[str],
                 egress_from: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']] = None,
                 egress_to: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']] = None):
        """
        The set of arguments for constructing a ServicePerimeterEgressPolicy resource.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        :param pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs'] egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs'] egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        """
        pulumi.set(__self__, "perimeter", perimeter)
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)

    @property
    @pulumi.getter
    def perimeter(self) -> pulumi.Input[str]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: pulumi.Input[str]):
        pulumi.set(self, "perimeter", value)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']]:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @egress_from.setter
    def egress_from(self, value: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']]):
        pulumi.set(self, "egress_from", value)

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")

    @egress_to.setter
    def egress_to(self, value: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']]):
        pulumi.set(self, "egress_to", value)


@pulumi.input_type
class _ServicePerimeterEgressPolicyState:
    def __init__(__self__, *,
                 egress_from: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']] = None,
                 egress_to: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']] = None,
                 perimeter: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServicePerimeterEgressPolicy resources.
        :param pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs'] egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs'] egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)
        if perimeter is not None:
            pulumi.set(__self__, "perimeter", perimeter)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']]:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @egress_from.setter
    def egress_from(self, value: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressFromArgs']]):
        pulumi.set(self, "egress_from", value)

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")

    @egress_to.setter
    def egress_to(self, value: Optional[pulumi.Input['ServicePerimeterEgressPolicyEgressToArgs']]):
        pulumi.set(self, "egress_to", value)

    @property
    @pulumi.getter
    def perimeter(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "perimeter", value)


class ServicePerimeterEgressPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egress_from: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressFromArgs']]] = None,
                 egress_to: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressToArgs']]] = None,
                 perimeter: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        EgressPolicies match requests based on egressFrom and egressTo stanzas.
        For an EgressPolicy to match, both egressFrom and egressTo stanzas must be matched.
        If an EgressPolicy matches a request, the request is allowed to span the ServicePerimeter
        boundary. For example, an EgressPolicy can be used to allow VMs on networks
        within the ServicePerimeter to access a defined set of projects outside the
        perimeter in certain contexts (e.g. to read data from a Cloud Storage bucket
        or query against a BigQuery dataset).

        To get more information about ServicePerimeterEgressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#egresspolicy)

        ## Import

        ServicePerimeterEgressPolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:accesscontextmanager/servicePerimeterEgressPolicy:ServicePerimeterEgressPolicy default {{perimeter}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressFromArgs']] egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressToArgs']] egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePerimeterEgressPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        EgressPolicies match requests based on egressFrom and egressTo stanzas.
        For an EgressPolicy to match, both egressFrom and egressTo stanzas must be matched.
        If an EgressPolicy matches a request, the request is allowed to span the ServicePerimeter
        boundary. For example, an EgressPolicy can be used to allow VMs on networks
        within the ServicePerimeter to access a defined set of projects outside the
        perimeter in certain contexts (e.g. to read data from a Cloud Storage bucket
        or query against a BigQuery dataset).

        To get more information about ServicePerimeterEgressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#egresspolicy)

        ## Import

        ServicePerimeterEgressPolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:accesscontextmanager/servicePerimeterEgressPolicy:ServicePerimeterEgressPolicy default {{perimeter}}
        ```

        :param str resource_name: The name of the resource.
        :param ServicePerimeterEgressPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePerimeterEgressPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egress_from: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressFromArgs']]] = None,
                 egress_to: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressToArgs']]] = None,
                 perimeter: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePerimeterEgressPolicyArgs.__new__(ServicePerimeterEgressPolicyArgs)

            __props__.__dict__["egress_from"] = egress_from
            __props__.__dict__["egress_to"] = egress_to
            if perimeter is None and not opts.urn:
                raise TypeError("Missing required property 'perimeter'")
            __props__.__dict__["perimeter"] = perimeter
        super(ServicePerimeterEgressPolicy, __self__).__init__(
            'gcp:accesscontextmanager/servicePerimeterEgressPolicy:ServicePerimeterEgressPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            egress_from: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressFromArgs']]] = None,
            egress_to: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressToArgs']]] = None,
            perimeter: Optional[pulumi.Input[str]] = None) -> 'ServicePerimeterEgressPolicy':
        """
        Get an existing ServicePerimeterEgressPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressFromArgs']] egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterEgressPolicyEgressToArgs']] egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePerimeterEgressPolicyState.__new__(_ServicePerimeterEgressPolicyState)

        __props__.__dict__["egress_from"] = egress_from
        __props__.__dict__["egress_to"] = egress_to
        __props__.__dict__["perimeter"] = perimeter
        return ServicePerimeterEgressPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> pulumi.Output[Optional['outputs.ServicePerimeterEgressPolicyEgressFrom']]:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> pulumi.Output[Optional['outputs.ServicePerimeterEgressPolicyEgressTo']]:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")

    @property
    @pulumi.getter
    def perimeter(self) -> pulumi.Output[str]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

