# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicePerimeterIngressPolicyArgs', 'ServicePerimeterIngressPolicy']

@pulumi.input_type
class ServicePerimeterIngressPolicyArgs:
    def __init__(__self__, *,
                 perimeter: pulumi.Input[str],
                 ingress_from: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']] = None,
                 ingress_to: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']] = None):
        """
        The set of arguments for constructing a ServicePerimeterIngressPolicy resource.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        :param pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs'] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs'] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        """
        pulumi.set(__self__, "perimeter", perimeter)
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)

    @property
    @pulumi.getter
    def perimeter(self) -> pulumi.Input[str]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: pulumi.Input[str]):
        pulumi.set(self, "perimeter", value)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @ingress_from.setter
    def ingress_from(self, value: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']]):
        pulumi.set(self, "ingress_from", value)

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @ingress_to.setter
    def ingress_to(self, value: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']]):
        pulumi.set(self, "ingress_to", value)


@pulumi.input_type
class _ServicePerimeterIngressPolicyState:
    def __init__(__self__, *,
                 ingress_from: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']] = None,
                 ingress_to: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']] = None,
                 perimeter: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServicePerimeterIngressPolicy resources.
        :param pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs'] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs'] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)
        if perimeter is not None:
            pulumi.set(__self__, "perimeter", perimeter)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @ingress_from.setter
    def ingress_from(self, value: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']]):
        pulumi.set(self, "ingress_from", value)

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @ingress_to.setter
    def ingress_to(self, value: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']]):
        pulumi.set(self, "ingress_to", value)

    @property
    @pulumi.getter
    def perimeter(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "perimeter", value)


class ServicePerimeterIngressPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_from: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressFromArgs']]] = None,
                 ingress_to: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressToArgs']]] = None,
                 perimeter: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        IngressPolicies match requests based on ingressFrom and ingressTo stanzas. For an ingress policy to match,
        both the ingressFrom and ingressTo stanzas must be matched. If an IngressPolicy matches a request,
        the request is allowed through the perimeter boundary from outside the perimeter.
        For example, access from the internet can be allowed either based on an AccessLevel or,
        for traffic hosted on Google Cloud, the project of the source network.
        For access from private networks, using the project of the hosting network is required.
        Individual ingress policies can be limited by restricting which services and/
        or actions they match using the ingressTo field.

        To get more information about ServicePerimeterIngressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#ingresspolicy)

        ## Import

        ServicePerimeterIngressPolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:accesscontextmanager/servicePerimeterIngressPolicy:ServicePerimeterIngressPolicy default {{perimeter}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressFromArgs']] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressToArgs']] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePerimeterIngressPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        IngressPolicies match requests based on ingressFrom and ingressTo stanzas. For an ingress policy to match,
        both the ingressFrom and ingressTo stanzas must be matched. If an IngressPolicy matches a request,
        the request is allowed through the perimeter boundary from outside the perimeter.
        For example, access from the internet can be allowed either based on an AccessLevel or,
        for traffic hosted on Google Cloud, the project of the source network.
        For access from private networks, using the project of the hosting network is required.
        Individual ingress policies can be limited by restricting which services and/
        or actions they match using the ingressTo field.

        To get more information about ServicePerimeterIngressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#ingresspolicy)

        ## Import

        ServicePerimeterIngressPolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:accesscontextmanager/servicePerimeterIngressPolicy:ServicePerimeterIngressPolicy default {{perimeter}}
        ```

        :param str resource_name: The name of the resource.
        :param ServicePerimeterIngressPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePerimeterIngressPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_from: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressFromArgs']]] = None,
                 ingress_to: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressToArgs']]] = None,
                 perimeter: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePerimeterIngressPolicyArgs.__new__(ServicePerimeterIngressPolicyArgs)

            __props__.__dict__["ingress_from"] = ingress_from
            __props__.__dict__["ingress_to"] = ingress_to
            if perimeter is None and not opts.urn:
                raise TypeError("Missing required property 'perimeter'")
            __props__.__dict__["perimeter"] = perimeter
        super(ServicePerimeterIngressPolicy, __self__).__init__(
            'gcp:accesscontextmanager/servicePerimeterIngressPolicy:ServicePerimeterIngressPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ingress_from: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressFromArgs']]] = None,
            ingress_to: Optional[pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressToArgs']]] = None,
            perimeter: Optional[pulumi.Input[str]] = None) -> 'ServicePerimeterIngressPolicy':
        """
        Get an existing ServicePerimeterIngressPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressFromArgs']] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ServicePerimeterIngressPolicyIngressToArgs']] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePerimeterIngressPolicyState.__new__(_ServicePerimeterIngressPolicyState)

        __props__.__dict__["ingress_from"] = ingress_from
        __props__.__dict__["ingress_to"] = ingress_to
        __props__.__dict__["perimeter"] = perimeter
        return ServicePerimeterIngressPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> pulumi.Output[Optional['outputs.ServicePerimeterIngressPolicyIngressFrom']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> pulumi.Output[Optional['outputs.ServicePerimeterIngressPolicyIngressTo']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @property
    @pulumi.getter
    def perimeter(self) -> pulumi.Output[str]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

