# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BackupEncryptionConfig',
    'BackupEncryptionInfo',
    'ClusterAutomatedBackupPolicy',
    'ClusterAutomatedBackupPolicyEncryptionConfig',
    'ClusterAutomatedBackupPolicyQuantityBasedRetention',
    'ClusterAutomatedBackupPolicyTimeBasedRetention',
    'ClusterAutomatedBackupPolicyWeeklySchedule',
    'ClusterAutomatedBackupPolicyWeeklyScheduleStartTime',
    'ClusterBackupSource',
    'ClusterEncryptionConfig',
    'ClusterEncryptionInfo',
    'ClusterInitialUser',
    'ClusterMigrationSource',
    'InstanceMachineConfig',
    'InstanceReadPoolConfig',
    'GetLocationsLocationResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult',
]

@pulumi.output_type
class BackupEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class BackupEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersions":
            suggest = "kms_key_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[str] = None,
                 kms_key_versions: Optional[Sequence[str]] = None):
        """
        :param str encryption_type: (Output)
               Output only. Type of encryption.
        :param Sequence[str] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[str]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[Sequence[str]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class ClusterAutomatedBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupWindow":
            suggest = "backup_window"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "quantityBasedRetention":
            suggest = "quantity_based_retention"
        elif key == "timeBasedRetention":
            suggest = "time_based_retention"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_window: Optional[str] = None,
                 enabled: Optional[bool] = None,
                 encryption_config: Optional['outputs.ClusterAutomatedBackupPolicyEncryptionConfig'] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 location: Optional[str] = None,
                 quantity_based_retention: Optional['outputs.ClusterAutomatedBackupPolicyQuantityBasedRetention'] = None,
                 time_based_retention: Optional['outputs.ClusterAutomatedBackupPolicyTimeBasedRetention'] = None,
                 weekly_schedule: Optional['outputs.ClusterAutomatedBackupPolicyWeeklySchedule'] = None):
        """
        :param str backup_window: The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
               The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param bool enabled: Whether automated backups are enabled.
        :param 'ClusterAutomatedBackupPolicyEncryptionConfigArgs' encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param Mapping[str, str] labels: Labels to apply to backups created using this configuration.
        :param str location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param 'ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs' quantity_based_retention: Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
               Structure is documented below.
        :param 'ClusterAutomatedBackupPolicyTimeBasedRetentionArgs' time_based_retention: Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
               Structure is documented below.
        :param 'ClusterAutomatedBackupPolicyWeeklyScheduleArgs' weekly_schedule: Weekly schedule for the Backup.
               Structure is documented below.
        """
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if quantity_based_retention is not None:
            pulumi.set(__self__, "quantity_based_retention", quantity_based_retention)
        if time_based_retention is not None:
            pulumi.set(__self__, "time_based_retention", time_based_retention)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional[str]:
        """
        The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
        The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether automated backups are enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.ClusterAutomatedBackupPolicyEncryptionConfig']:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="quantityBasedRetention")
    def quantity_based_retention(self) -> Optional['outputs.ClusterAutomatedBackupPolicyQuantityBasedRetention']:
        """
        Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "quantity_based_retention")

    @property
    @pulumi.getter(name="timeBasedRetention")
    def time_based_retention(self) -> Optional['outputs.ClusterAutomatedBackupPolicyTimeBasedRetention']:
        """
        Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "time_based_retention")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.ClusterAutomatedBackupPolicyWeeklySchedule']:
        """
        Weekly schedule for the Backup.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class ClusterAutomatedBackupPolicyEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterAutomatedBackupPolicyQuantityBasedRetention(dict):
    def __init__(__self__, *,
                 count: Optional[int] = None):
        """
        :param int count: The number of backups to retain.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The number of backups to retain.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class ClusterAutomatedBackupPolicyTimeBasedRetention(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyTimeBasedRetention. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyTimeBasedRetention.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyTimeBasedRetention.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period: Optional[str] = None):
        """
        :param str retention_period: The retention period.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[str]:
        """
        The retention period.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class ClusterAutomatedBackupPolicyWeeklySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimes":
            suggest = "start_times"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyWeeklySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyWeeklySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyWeeklySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_times: Sequence['outputs.ClusterAutomatedBackupPolicyWeeklyScheduleStartTime'],
                 days_of_weeks: Optional[Sequence[str]] = None):
        """
        :param Sequence['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs'] start_times: The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
               Structure is documented below.
        :param Sequence[str] days_of_weeks: The days of the week to perform a backup. At least one day of the week must be provided.
               Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        pulumi.set(__self__, "start_times", start_times)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.ClusterAutomatedBackupPolicyWeeklyScheduleStartTime']:
        """
        The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
        Structure is documented below.
        """
        return pulumi.get(self, "start_times")

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[str]]:
        """
        The days of the week to perform a backup. At least one day of the week must be provided.
        Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "days_of_weeks")


@pulumi.output_type
class ClusterAutomatedBackupPolicyWeeklyScheduleStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[int] = None,
                 minutes: Optional[int] = None,
                 nanos: Optional[int] = None,
                 seconds: Optional[int] = None):
        """
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param int nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param int seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[int]:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ClusterBackupSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupName":
            suggest = "backup_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBackupSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBackupSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBackupSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_name: Optional[str] = None):
        """
        :param str backup_name: The name of the backup resource.
        """
        if backup_name is not None:
            pulumi.set(__self__, "backup_name", backup_name)

    @property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> Optional[str]:
        """
        The name of the backup resource.
        """
        return pulumi.get(self, "backup_name")


@pulumi.output_type
class ClusterEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersions":
            suggest = "kms_key_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[str] = None,
                 kms_key_versions: Optional[Sequence[str]] = None):
        """
        :param str encryption_type: (Output)
               Output only. Type of encryption.
        :param Sequence[str] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[str]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[Sequence[str]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class ClusterInitialUser(dict):
    def __init__(__self__, *,
                 password: str,
                 user: Optional[str] = None):
        """
        :param str password: The initial password for the user.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str user: The database username.
        """
        pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        The database username.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ClusterMigrationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostPort":
            suggest = "host_port"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMigrationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMigrationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMigrationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_port: Optional[str] = None,
                 reference_id: Optional[str] = None,
                 source_type: Optional[str] = None):
        """
        :param str host_port: The host and port of the on-premises instance in host:port format
        :param str reference_id: Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        :param str source_type: Type of migration source.
        """
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[str]:
        """
        The host and port of the on-premises instance in host:port format
        """
        return pulumi.get(self, "host_port")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[str]:
        """
        Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        """
        Type of migration source.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class InstanceMachineConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMachineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMachineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMachineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: Optional[int] = None):
        """
        :param int cpu_count: The number of CPU's in the VM instance.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[int]:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")


@pulumi.output_type
class InstanceReadPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceReadPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceReadPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceReadPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_count: Optional[int] = None):
        """
        :param int node_count: Read capacity, i.e. number of nodes in a read pool instance.
        """
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        Read capacity, i.e. number of nodes in a read pool instance.
        """
        return pulumi.get(self, "node_count")


@pulumi.output_type
class GetLocationsLocationResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 labels: Mapping[str, str],
                 location_id: str,
                 metadata: Mapping[str, str],
                 name: str):
        """
        :param str display_name: The friendly name for this location, typically a nearby city name. For example, "Tokyo".
        :param Mapping[str, str] labels: Cross-service attributes for the location. For example `{"cloud.googleapis.com/region": "us-east1"}`.
        :param str location_id: The canonical id for this location. For example: "us-east1"..
        :param Mapping[str, str] metadata: Service-specific metadata. For example the available capacity at the given location.
        :param str name: Resource name for the location, which may vary between implementations. For example: "projects/example-project/locations/us-east1".
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location_id", location_id)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The friendly name for this location, typically a nearby city name. For example, "Tokyo".
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Cross-service attributes for the location. For example `{"cloud.googleapis.com/region": "us-east1"}`.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> str:
        """
        The canonical id for this location. For example: "us-east1"..
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Service-specific metadata. For example the available capacity at the given location.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the location, which may vary between implementations. For example: "projects/example-project/locations/us-east1".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 accepts_multiple_values: bool,
                 flag_name: str,
                 integer_restrictions: 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult',
                 name: str,
                 requires_db_restart: bool,
                 string_restrictions: 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult',
                 supported_db_versions: Sequence[str],
                 value_type: str):
        """
        :param bool accepts_multiple_values: Whether the database flag accepts multiple values. If true, a comma-separated list of stringified values may be specified.
        :param str flag_name: The name of the database flag, e.g. "max_allowed_packets". The is a possibly key for the Instance.database_flags map field.
        :param 'GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsArgs' integer_restrictions: Restriction on `INTEGER` type value. Specifies the minimum value and the maximum value that can be specified, if applicable.
        :param str name: The name of the flag resource, following Google Cloud conventions, e.g.: * projects/{project}/locations/{location}/flags/{flag} This field currently has no semantic meaning.
        :param bool requires_db_restart: Whether setting or updating this flag on an Instance requires a database restart. If a flag that requires database restart is set, the backend will automatically restart the database (making sure to satisfy any availability SLO's).
        :param 'GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsArgs' string_restrictions: Restriction on `STRING` type value. The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        :param Sequence[str] supported_db_versions: Major database engine versions for which this flag is supported. The supported values are `POSTGRES_14` and `DATABASE_VERSION_UNSPECIFIED`.
        :param str value_type: ValueType describes the semantic type of the value that the flag accepts. Regardless of the ValueType, the Instance.database_flags field accepts the stringified version of the value, i.e. "20" or "3.14". The supported values are `VALUE_TYPE_UNSPECIFIED`, `STRING`, `INTEGER`, `FLOAT` and `NONE`.
        """
        pulumi.set(__self__, "accepts_multiple_values", accepts_multiple_values)
        pulumi.set(__self__, "flag_name", flag_name)
        pulumi.set(__self__, "integer_restrictions", integer_restrictions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "requires_db_restart", requires_db_restart)
        pulumi.set(__self__, "string_restrictions", string_restrictions)
        pulumi.set(__self__, "supported_db_versions", supported_db_versions)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="acceptsMultipleValues")
    def accepts_multiple_values(self) -> bool:
        """
        Whether the database flag accepts multiple values. If true, a comma-separated list of stringified values may be specified.
        """
        return pulumi.get(self, "accepts_multiple_values")

    @property
    @pulumi.getter(name="flagName")
    def flag_name(self) -> str:
        """
        The name of the database flag, e.g. "max_allowed_packets". The is a possibly key for the Instance.database_flags map field.
        """
        return pulumi.get(self, "flag_name")

    @property
    @pulumi.getter(name="integerRestrictions")
    def integer_restrictions(self) -> 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult':
        """
        Restriction on `INTEGER` type value. Specifies the minimum value and the maximum value that can be specified, if applicable.
        """
        return pulumi.get(self, "integer_restrictions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the flag resource, following Google Cloud conventions, e.g.: * projects/{project}/locations/{location}/flags/{flag} This field currently has no semantic meaning.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requiresDbRestart")
    def requires_db_restart(self) -> bool:
        """
        Whether setting or updating this flag on an Instance requires a database restart. If a flag that requires database restart is set, the backend will automatically restart the database (making sure to satisfy any availability SLO's).
        """
        return pulumi.get(self, "requires_db_restart")

    @property
    @pulumi.getter(name="stringRestrictions")
    def string_restrictions(self) -> 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult':
        """
        Restriction on `STRING` type value. The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        """
        return pulumi.get(self, "string_restrictions")

    @property
    @pulumi.getter(name="supportedDbVersions")
    def supported_db_versions(self) -> Sequence[str]:
        """
        Major database engine versions for which this flag is supported. The supported values are `POSTGRES_14` and `DATABASE_VERSION_UNSPECIFIED`.
        """
        return pulumi.get(self, "supported_db_versions")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        ValueType describes the semantic type of the value that the flag accepts. Regardless of the ValueType, the Instance.database_flags field accepts the stringified version of the value, i.e. "20" or "3.14". The supported values are `VALUE_TYPE_UNSPECIFIED`, `STRING`, `INTEGER`, `FLOAT` and `NONE`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult(dict):
    def __init__(__self__, *,
                 max_value: str,
                 min_value: str):
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> str:
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> str:
        return pulumi.get(self, "min_value")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult(dict):
    def __init__(__self__, *,
                 allowed_values: Sequence[str]):
        pulumi.set(__self__, "allowed_values", allowed_values)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_values")


