# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeystoresAliasesSelfSignedCertArgs', 'KeystoresAliasesSelfSignedCert']

@pulumi.input_type
class KeystoresAliasesSelfSignedCertArgs:
    def __init__(__self__, *,
                 alias: pulumi.Input[str],
                 environment: pulumi.Input[str],
                 keystore: pulumi.Input[str],
                 org_id: pulumi.Input[str],
                 sig_alg: pulumi.Input[str],
                 subject: pulumi.Input['KeystoresAliasesSelfSignedCertSubjectArgs'],
                 cert_validity_in_days: Optional[pulumi.Input[int]] = None,
                 key_size: Optional[pulumi.Input[str]] = None,
                 subject_alternative_dns_names: Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']] = None):
        """
        The set of arguments for constructing a KeystoresAliasesSelfSignedCert resource.
        :param pulumi.Input[str] alias: Alias for the key/certificate pair. Values must match the regular expression [\\w\\s-.]{1,255}.
               This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
               this parameter or the JSON body.
        :param pulumi.Input[str] environment: The Apigee environment name
        :param pulumi.Input[str] keystore: The Apigee keystore name associated in an Apigee environment
        :param pulumi.Input[str] org_id: The Apigee Organization name associated with the Apigee environment
        :param pulumi.Input[str] sig_alg: Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
        :param pulumi.Input['KeystoresAliasesSelfSignedCertSubjectArgs'] subject: Subject details.
               Structure is documented below.
        :param pulumi.Input[int] cert_validity_in_days: Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
        :param pulumi.Input[str] key_size: Key size. Default and maximum value is 2048 bits.
        :param pulumi.Input['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs'] subject_alternative_dns_names: List of alternative host names. Maximum length is 255 characters for each value.
               Structure is documented below.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "keystore", keystore)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "sig_alg", sig_alg)
        pulumi.set(__self__, "subject", subject)
        if cert_validity_in_days is not None:
            pulumi.set(__self__, "cert_validity_in_days", cert_validity_in_days)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)
        if subject_alternative_dns_names is not None:
            pulumi.set(__self__, "subject_alternative_dns_names", subject_alternative_dns_names)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Input[str]:
        """
        Alias for the key/certificate pair. Values must match the regular expression [\\w\\s-.]{1,255}.
        This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
        this parameter or the JSON body.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: pulumi.Input[str]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input[str]:
        """
        The Apigee environment name
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def keystore(self) -> pulumi.Input[str]:
        """
        The Apigee keystore name associated in an Apigee environment
        """
        return pulumi.get(self, "keystore")

    @keystore.setter
    def keystore(self, value: pulumi.Input[str]):
        pulumi.set(self, "keystore", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[str]:
        """
        The Apigee Organization name associated with the Apigee environment
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="sigAlg")
    def sig_alg(self) -> pulumi.Input[str]:
        """
        Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
        """
        return pulumi.get(self, "sig_alg")

    @sig_alg.setter
    def sig_alg(self, value: pulumi.Input[str]):
        pulumi.set(self, "sig_alg", value)

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Input['KeystoresAliasesSelfSignedCertSubjectArgs']:
        """
        Subject details.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input['KeystoresAliasesSelfSignedCertSubjectArgs']):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter(name="certValidityInDays")
    def cert_validity_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
        """
        return pulumi.get(self, "cert_validity_in_days")

    @cert_validity_in_days.setter
    def cert_validity_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cert_validity_in_days", value)

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[pulumi.Input[str]]:
        """
        Key size. Default and maximum value is 2048 bits.
        """
        return pulumi.get(self, "key_size")

    @key_size.setter
    def key_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_size", value)

    @property
    @pulumi.getter(name="subjectAlternativeDnsNames")
    def subject_alternative_dns_names(self) -> Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']]:
        """
        List of alternative host names. Maximum length is 255 characters for each value.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alternative_dns_names")

    @subject_alternative_dns_names.setter
    def subject_alternative_dns_names(self, value: Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']]):
        pulumi.set(self, "subject_alternative_dns_names", value)


@pulumi.input_type
class _KeystoresAliasesSelfSignedCertState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 cert_validity_in_days: Optional[pulumi.Input[int]] = None,
                 certs_infos: Optional[pulumi.Input[Sequence[pulumi.Input['KeystoresAliasesSelfSignedCertCertsInfoArgs']]]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 key_size: Optional[pulumi.Input[str]] = None,
                 keystore: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 sig_alg: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectArgs']] = None,
                 subject_alternative_dns_names: Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KeystoresAliasesSelfSignedCert resources.
        :param pulumi.Input[str] alias: Alias for the key/certificate pair. Values must match the regular expression [\\w\\s-.]{1,255}.
               This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
               this parameter or the JSON body.
        :param pulumi.Input[int] cert_validity_in_days: Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
        :param pulumi.Input[Sequence[pulumi.Input['KeystoresAliasesSelfSignedCertCertsInfoArgs']]] certs_infos: Chain of certificates under this alias.
               Structure is documented below.
        :param pulumi.Input[str] environment: The Apigee environment name
        :param pulumi.Input[str] key_size: Key size. Default and maximum value is 2048 bits.
        :param pulumi.Input[str] keystore: The Apigee keystore name associated in an Apigee environment
        :param pulumi.Input[str] org_id: The Apigee Organization name associated with the Apigee environment
        :param pulumi.Input[str] sig_alg: Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
        :param pulumi.Input['KeystoresAliasesSelfSignedCertSubjectArgs'] subject: Subject details.
               Structure is documented below.
        :param pulumi.Input['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs'] subject_alternative_dns_names: List of alternative host names. Maximum length is 255 characters for each value.
               Structure is documented below.
        :param pulumi.Input[str] type: Optional.Type of Alias
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if cert_validity_in_days is not None:
            pulumi.set(__self__, "cert_validity_in_days", cert_validity_in_days)
        if certs_infos is not None:
            pulumi.set(__self__, "certs_infos", certs_infos)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)
        if keystore is not None:
            pulumi.set(__self__, "keystore", keystore)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if sig_alg is not None:
            pulumi.set(__self__, "sig_alg", sig_alg)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if subject_alternative_dns_names is not None:
            pulumi.set(__self__, "subject_alternative_dns_names", subject_alternative_dns_names)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Alias for the key/certificate pair. Values must match the regular expression [\\w\\s-.]{1,255}.
        This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
        this parameter or the JSON body.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="certValidityInDays")
    def cert_validity_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
        """
        return pulumi.get(self, "cert_validity_in_days")

    @cert_validity_in_days.setter
    def cert_validity_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cert_validity_in_days", value)

    @property
    @pulumi.getter(name="certsInfos")
    def certs_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeystoresAliasesSelfSignedCertCertsInfoArgs']]]]:
        """
        Chain of certificates under this alias.
        Structure is documented below.
        """
        return pulumi.get(self, "certs_infos")

    @certs_infos.setter
    def certs_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeystoresAliasesSelfSignedCertCertsInfoArgs']]]]):
        pulumi.set(self, "certs_infos", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The Apigee environment name
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[pulumi.Input[str]]:
        """
        Key size. Default and maximum value is 2048 bits.
        """
        return pulumi.get(self, "key_size")

    @key_size.setter
    def key_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_size", value)

    @property
    @pulumi.getter
    def keystore(self) -> Optional[pulumi.Input[str]]:
        """
        The Apigee keystore name associated in an Apigee environment
        """
        return pulumi.get(self, "keystore")

    @keystore.setter
    def keystore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Apigee Organization name associated with the Apigee environment
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="sigAlg")
    def sig_alg(self) -> Optional[pulumi.Input[str]]:
        """
        Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
        """
        return pulumi.get(self, "sig_alg")

    @sig_alg.setter
    def sig_alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sig_alg", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectArgs']]:
        """
        Subject details.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectArgs']]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter(name="subjectAlternativeDnsNames")
    def subject_alternative_dns_names(self) -> Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']]:
        """
        List of alternative host names. Maximum length is 255 characters for each value.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alternative_dns_names")

    @subject_alternative_dns_names.setter
    def subject_alternative_dns_names(self, value: Optional[pulumi.Input['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']]):
        pulumi.set(self, "subject_alternative_dns_names", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional.Type of Alias
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class KeystoresAliasesSelfSignedCert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 cert_validity_in_days: Optional[pulumi.Input[int]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 key_size: Optional[pulumi.Input[str]] = None,
                 keystore: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 sig_alg: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectArgs']]] = None,
                 subject_alternative_dns_names: Optional[pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']]] = None,
                 __props__=None):
        """
        An Environment Keystore Alias for Self Signed Certificate Format in Apigee

        To get more information about KeystoresAliasesSelfSignedCert, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.keystores.aliases/create)
        * How-to Guides
            * [Creating an environment](https://cloud.google.com/apigee/docs/api-platform/get-started/create-environment)

        ## Example Usage
        ### Apigee Env Keystore Alias Self Signed Cert

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        apigee = gcp.projects.Service("apigee",
            project=project.project_id,
            service="apigee.googleapis.com")
        servicenetworking = gcp.projects.Service("servicenetworking",
            project=project.project_id,
            service="servicenetworking.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[apigee]))
        compute = gcp.projects.Service("compute",
            project=project.project_id,
            service="compute.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[servicenetworking]))
        apigee_network = gcp.compute.Network("apigeeNetwork", project=project.project_id,
        opts=pulumi.ResourceOptions(depends_on=[compute]))
        apigee_range = gcp.compute.GlobalAddress("apigeeRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id,
            project=project.project_id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigeeVpcConnection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name],
            opts=pulumi.ResourceOptions(depends_on=[servicenetworking]))
        apigee_org = gcp.apigee.Organization("apigeeOrg",
            analytics_region="us-central1",
            project_id=project.project_id,
            authorized_network=apigee_network.id,
            opts=pulumi.ResourceOptions(depends_on=[
                    apigee_vpc_connection,
                    apigee,
                ]))
        apigee_environment_keystore_ss_alias_environment = gcp.apigee.Environment("apigeeEnvironmentKeystoreSsAliasEnvironment",
            org_id=apigee_org.id,
            description="Apigee Environment",
            display_name="environment-1")
        apigee_environment_keystore_alias = gcp.apigee.EnvKeystore("apigeeEnvironmentKeystoreAlias", env_id=apigee_environment_keystore_ss_alias_environment.id)
        apigee_environment_keystore_ss_alias_keystores_aliases_self_signed_cert = gcp.apigee.KeystoresAliasesSelfSignedCert("apigeeEnvironmentKeystoreSsAliasKeystoresAliasesSelfSignedCert",
            environment=apigee_environment_keystore_ss_alias_environment.name,
            org_id=apigee_org.name,
            keystore=apigee_environment_keystore_alias.name,
            alias="alias",
            key_size="1024",
            sig_alg="SHA512withRSA",
            cert_validity_in_days=4,
            subject=gcp.apigee.KeystoresAliasesSelfSignedCertSubjectArgs(
                common_name="selfsigned_example",
                country_code="US",
                locality="TX",
                org="CCE",
                org_unit="PSO",
            ))
        ```

        ## Import

        KeystoresAliasesSelfSignedCert can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:apigee/keystoresAliasesSelfSignedCert:KeystoresAliasesSelfSignedCert default organizations/{{org_id}}/environments/{{environment}}/keystores/{{keystore}}/aliases/{{alias}}
        ```

        ```sh
         $ pulumi import gcp:apigee/keystoresAliasesSelfSignedCert:KeystoresAliasesSelfSignedCert default {{org_id}}/{{environment}}/{{keystore}}/{{alias}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: Alias for the key/certificate pair. Values must match the regular expression [\\w\\s-.]{1,255}.
               This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
               this parameter or the JSON body.
        :param pulumi.Input[int] cert_validity_in_days: Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
        :param pulumi.Input[str] environment: The Apigee environment name
        :param pulumi.Input[str] key_size: Key size. Default and maximum value is 2048 bits.
        :param pulumi.Input[str] keystore: The Apigee keystore name associated in an Apigee environment
        :param pulumi.Input[str] org_id: The Apigee Organization name associated with the Apigee environment
        :param pulumi.Input[str] sig_alg: Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
        :param pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectArgs']] subject: Subject details.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']] subject_alternative_dns_names: List of alternative host names. Maximum length is 255 characters for each value.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeystoresAliasesSelfSignedCertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Environment Keystore Alias for Self Signed Certificate Format in Apigee

        To get more information about KeystoresAliasesSelfSignedCert, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.keystores.aliases/create)
        * How-to Guides
            * [Creating an environment](https://cloud.google.com/apigee/docs/api-platform/get-started/create-environment)

        ## Example Usage
        ### Apigee Env Keystore Alias Self Signed Cert

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        apigee = gcp.projects.Service("apigee",
            project=project.project_id,
            service="apigee.googleapis.com")
        servicenetworking = gcp.projects.Service("servicenetworking",
            project=project.project_id,
            service="servicenetworking.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[apigee]))
        compute = gcp.projects.Service("compute",
            project=project.project_id,
            service="compute.googleapis.com",
            opts=pulumi.ResourceOptions(depends_on=[servicenetworking]))
        apigee_network = gcp.compute.Network("apigeeNetwork", project=project.project_id,
        opts=pulumi.ResourceOptions(depends_on=[compute]))
        apigee_range = gcp.compute.GlobalAddress("apigeeRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id,
            project=project.project_id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigeeVpcConnection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name],
            opts=pulumi.ResourceOptions(depends_on=[servicenetworking]))
        apigee_org = gcp.apigee.Organization("apigeeOrg",
            analytics_region="us-central1",
            project_id=project.project_id,
            authorized_network=apigee_network.id,
            opts=pulumi.ResourceOptions(depends_on=[
                    apigee_vpc_connection,
                    apigee,
                ]))
        apigee_environment_keystore_ss_alias_environment = gcp.apigee.Environment("apigeeEnvironmentKeystoreSsAliasEnvironment",
            org_id=apigee_org.id,
            description="Apigee Environment",
            display_name="environment-1")
        apigee_environment_keystore_alias = gcp.apigee.EnvKeystore("apigeeEnvironmentKeystoreAlias", env_id=apigee_environment_keystore_ss_alias_environment.id)
        apigee_environment_keystore_ss_alias_keystores_aliases_self_signed_cert = gcp.apigee.KeystoresAliasesSelfSignedCert("apigeeEnvironmentKeystoreSsAliasKeystoresAliasesSelfSignedCert",
            environment=apigee_environment_keystore_ss_alias_environment.name,
            org_id=apigee_org.name,
            keystore=apigee_environment_keystore_alias.name,
            alias="alias",
            key_size="1024",
            sig_alg="SHA512withRSA",
            cert_validity_in_days=4,
            subject=gcp.apigee.KeystoresAliasesSelfSignedCertSubjectArgs(
                common_name="selfsigned_example",
                country_code="US",
                locality="TX",
                org="CCE",
                org_unit="PSO",
            ))
        ```

        ## Import

        KeystoresAliasesSelfSignedCert can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:apigee/keystoresAliasesSelfSignedCert:KeystoresAliasesSelfSignedCert default organizations/{{org_id}}/environments/{{environment}}/keystores/{{keystore}}/aliases/{{alias}}
        ```

        ```sh
         $ pulumi import gcp:apigee/keystoresAliasesSelfSignedCert:KeystoresAliasesSelfSignedCert default {{org_id}}/{{environment}}/{{keystore}}/{{alias}}
        ```

        :param str resource_name: The name of the resource.
        :param KeystoresAliasesSelfSignedCertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeystoresAliasesSelfSignedCertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 cert_validity_in_days: Optional[pulumi.Input[int]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 key_size: Optional[pulumi.Input[str]] = None,
                 keystore: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 sig_alg: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectArgs']]] = None,
                 subject_alternative_dns_names: Optional[pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeystoresAliasesSelfSignedCertArgs.__new__(KeystoresAliasesSelfSignedCertArgs)

            if alias is None and not opts.urn:
                raise TypeError("Missing required property 'alias'")
            __props__.__dict__["alias"] = alias
            __props__.__dict__["cert_validity_in_days"] = cert_validity_in_days
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["key_size"] = key_size
            if keystore is None and not opts.urn:
                raise TypeError("Missing required property 'keystore'")
            __props__.__dict__["keystore"] = keystore
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if sig_alg is None and not opts.urn:
                raise TypeError("Missing required property 'sig_alg'")
            __props__.__dict__["sig_alg"] = sig_alg
            if subject is None and not opts.urn:
                raise TypeError("Missing required property 'subject'")
            __props__.__dict__["subject"] = subject
            __props__.__dict__["subject_alternative_dns_names"] = subject_alternative_dns_names
            __props__.__dict__["certs_infos"] = None
            __props__.__dict__["type"] = None
        super(KeystoresAliasesSelfSignedCert, __self__).__init__(
            'gcp:apigee/keystoresAliasesSelfSignedCert:KeystoresAliasesSelfSignedCert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[str]] = None,
            cert_validity_in_days: Optional[pulumi.Input[int]] = None,
            certs_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertCertsInfoArgs']]]]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            key_size: Optional[pulumi.Input[str]] = None,
            keystore: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            sig_alg: Optional[pulumi.Input[str]] = None,
            subject: Optional[pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectArgs']]] = None,
            subject_alternative_dns_names: Optional[pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'KeystoresAliasesSelfSignedCert':
        """
        Get an existing KeystoresAliasesSelfSignedCert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: Alias for the key/certificate pair. Values must match the regular expression [\\w\\s-.]{1,255}.
               This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
               this parameter or the JSON body.
        :param pulumi.Input[int] cert_validity_in_days: Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertCertsInfoArgs']]]] certs_infos: Chain of certificates under this alias.
               Structure is documented below.
        :param pulumi.Input[str] environment: The Apigee environment name
        :param pulumi.Input[str] key_size: Key size. Default and maximum value is 2048 bits.
        :param pulumi.Input[str] keystore: The Apigee keystore name associated in an Apigee environment
        :param pulumi.Input[str] org_id: The Apigee Organization name associated with the Apigee environment
        :param pulumi.Input[str] sig_alg: Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
        :param pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectArgs']] subject: Subject details.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesArgs']] subject_alternative_dns_names: List of alternative host names. Maximum length is 255 characters for each value.
               Structure is documented below.
        :param pulumi.Input[str] type: Optional.Type of Alias
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeystoresAliasesSelfSignedCertState.__new__(_KeystoresAliasesSelfSignedCertState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["cert_validity_in_days"] = cert_validity_in_days
        __props__.__dict__["certs_infos"] = certs_infos
        __props__.__dict__["environment"] = environment
        __props__.__dict__["key_size"] = key_size
        __props__.__dict__["keystore"] = keystore
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["sig_alg"] = sig_alg
        __props__.__dict__["subject"] = subject
        __props__.__dict__["subject_alternative_dns_names"] = subject_alternative_dns_names
        __props__.__dict__["type"] = type
        return KeystoresAliasesSelfSignedCert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[str]:
        """
        Alias for the key/certificate pair. Values must match the regular expression [\\w\\s-.]{1,255}.
        This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
        this parameter or the JSON body.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certValidityInDays")
    def cert_validity_in_days(self) -> pulumi.Output[Optional[int]]:
        """
        Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
        """
        return pulumi.get(self, "cert_validity_in_days")

    @property
    @pulumi.getter(name="certsInfos")
    def certs_infos(self) -> pulumi.Output[Sequence['outputs.KeystoresAliasesSelfSignedCertCertsInfo']]:
        """
        Chain of certificates under this alias.
        Structure is documented below.
        """
        return pulumi.get(self, "certs_infos")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[str]:
        """
        The Apigee environment name
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> pulumi.Output[Optional[str]]:
        """
        Key size. Default and maximum value is 2048 bits.
        """
        return pulumi.get(self, "key_size")

    @property
    @pulumi.getter
    def keystore(self) -> pulumi.Output[str]:
        """
        The Apigee keystore name associated in an Apigee environment
        """
        return pulumi.get(self, "keystore")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[str]:
        """
        The Apigee Organization name associated with the Apigee environment
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="sigAlg")
    def sig_alg(self) -> pulumi.Output[str]:
        """
        Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
        """
        return pulumi.get(self, "sig_alg")

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Output['outputs.KeystoresAliasesSelfSignedCertSubject']:
        """
        Subject details.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAlternativeDnsNames")
    def subject_alternative_dns_names(self) -> pulumi.Output[Optional['outputs.KeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames']]:
        """
        List of alternative host names. Maximum length is 255 characters for each value.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alternative_dns_names")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Optional.Type of Alias
        """
        return pulumi.get(self, "type")

