# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationArgs', 'Organization']

@pulumi.input_type
class OrganizationArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 analytics_region: Optional[pulumi.Input[str]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_vpc_peering: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['OrganizationPropertiesArgs']] = None,
                 retention: Optional[pulumi.Input[str]] = None,
                 runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Organization resource.
        :param pulumi.Input[str] project_id: The project ID associated with the Apigee organization.
               
               
               - - -
        :param pulumi.Input[str] analytics_region: Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        :param pulumi.Input[str] authorized_network: Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
               See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
               Valid only when `RuntimeType` is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
        :param pulumi.Input[str] billing_type: Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        :param pulumi.Input[str] description: Description of the Apigee organization.
        :param pulumi.Input[bool] disable_vpc_peering: Flag that specifies whether the VPC Peering through Private Google Access should be
               disabled between the consumer network and Apigee. Required if an `authorizedNetwork`
               on the consumer project is not provided, in which case the flag should be set to `true`.
               Valid only when `RuntimeType` is set to CLOUD. The value must be set before the creation
               of any Apigee runtime instance and can be updated only when there are no runtime instances.
        :param pulumi.Input[str] display_name: The display name of the Apigee organization.
        :param pulumi.Input['OrganizationPropertiesArgs'] properties: Properties defined in the Apigee organization profile.
               Structure is documented below.
        :param pulumi.Input[str] retention: Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType
               is not EVALUATION). It controls how long Organization data will be retained after the initial delete
               operation completes. During this period, the Organization may be restored to its last known state.
               After this period, the Organization will no longer be able to be restored.
               Default value is `DELETION_RETENTION_UNSPECIFIED`.
               Possible values are: `DELETION_RETENTION_UNSPECIFIED`, `MINIMUM`.
        :param pulumi.Input[str] runtime_database_encryption_key_name: Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
               Update is not allowed after the organization is created.
               If not specified, a Google-Managed encryption key will be used.
               Valid only when `RuntimeType` is CLOUD. For example: `projects/foo/locations/us/keyRings/bar/cryptoKeys/baz`.
        :param pulumi.Input[str] runtime_type: Runtime type of the Apigee organization based on the Apigee subscription purchased.
               Default value is `CLOUD`.
               Possible values are: `CLOUD`, `HYBRID`.
        """
        pulumi.set(__self__, "project_id", project_id)
        if analytics_region is not None:
            pulumi.set(__self__, "analytics_region", analytics_region)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_vpc_peering is not None:
            pulumi.set(__self__, "disable_vpc_peering", disable_vpc_peering)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if runtime_database_encryption_key_name is not None:
            pulumi.set(__self__, "runtime_database_encryption_key_name", runtime_database_encryption_key_name)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The project ID associated with the Apigee organization.


        - - -
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="analyticsRegion")
    def analytics_region(self) -> Optional[pulumi.Input[str]]:
        """
        Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        """
        return pulumi.get(self, "analytics_region")

    @analytics_region.setter
    def analytics_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analytics_region", value)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[str]]:
        """
        Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
        See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
        Valid only when `RuntimeType` is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorized_network", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Apigee organization.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableVpcPeering")
    def disable_vpc_peering(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that specifies whether the VPC Peering through Private Google Access should be
        disabled between the consumer network and Apigee. Required if an `authorizedNetwork`
        on the consumer project is not provided, in which case the flag should be set to `true`.
        Valid only when `RuntimeType` is set to CLOUD. The value must be set before the creation
        of any Apigee runtime instance and can be updated only when there are no runtime instances.
        """
        return pulumi.get(self, "disable_vpc_peering")

    @disable_vpc_peering.setter
    def disable_vpc_peering(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_vpc_peering", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the Apigee organization.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['OrganizationPropertiesArgs']]:
        """
        Properties defined in the Apigee organization profile.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['OrganizationPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType
        is not EVALUATION). It controls how long Organization data will be retained after the initial delete
        operation completes. During this period, the Organization may be restored to its last known state.
        After this period, the Organization will no longer be able to be restored.
        Default value is `DELETION_RETENTION_UNSPECIFIED`.
        Possible values are: `DELETION_RETENTION_UNSPECIFIED`, `MINIMUM`.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter(name="runtimeDatabaseEncryptionKeyName")
    def runtime_database_encryption_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
        Update is not allowed after the organization is created.
        If not specified, a Google-Managed encryption key will be used.
        Valid only when `RuntimeType` is CLOUD. For example: `projects/foo/locations/us/keyRings/bar/cryptoKeys/baz`.
        """
        return pulumi.get(self, "runtime_database_encryption_key_name")

    @runtime_database_encryption_key_name.setter
    def runtime_database_encryption_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_database_encryption_key_name", value)

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime type of the Apigee organization based on the Apigee subscription purchased.
        Default value is `CLOUD`.
        Possible values are: `CLOUD`, `HYBRID`.
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_type", value)


@pulumi.input_type
class _OrganizationState:
    def __init__(__self__, *,
                 analytics_region: Optional[pulumi.Input[str]] = None,
                 apigee_project_id: Optional[pulumi.Input[str]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_vpc_peering: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['OrganizationPropertiesArgs']] = None,
                 retention: Optional[pulumi.Input[str]] = None,
                 runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 subscription_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Organization resources.
        :param pulumi.Input[str] analytics_region: Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        :param pulumi.Input[str] apigee_project_id: Output only. Project ID of the Apigee Tenant Project.
        :param pulumi.Input[str] authorized_network: Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
               See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
               Valid only when `RuntimeType` is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
        :param pulumi.Input[str] billing_type: Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        :param pulumi.Input[str] ca_certificate: Output only. Base64-encoded public certificate for the root CA of the Apigee organization.
               Valid only when `RuntimeType` is CLOUD. A base64-encoded string.
        :param pulumi.Input[str] description: Description of the Apigee organization.
        :param pulumi.Input[bool] disable_vpc_peering: Flag that specifies whether the VPC Peering through Private Google Access should be
               disabled between the consumer network and Apigee. Required if an `authorizedNetwork`
               on the consumer project is not provided, in which case the flag should be set to `true`.
               Valid only when `RuntimeType` is set to CLOUD. The value must be set before the creation
               of any Apigee runtime instance and can be updated only when there are no runtime instances.
        :param pulumi.Input[str] display_name: The display name of the Apigee organization.
        :param pulumi.Input[str] name: Name of the property.
        :param pulumi.Input[str] project_id: The project ID associated with the Apigee organization.
               
               
               - - -
        :param pulumi.Input['OrganizationPropertiesArgs'] properties: Properties defined in the Apigee organization profile.
               Structure is documented below.
        :param pulumi.Input[str] retention: Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType
               is not EVALUATION). It controls how long Organization data will be retained after the initial delete
               operation completes. During this period, the Organization may be restored to its last known state.
               After this period, the Organization will no longer be able to be restored.
               Default value is `DELETION_RETENTION_UNSPECIFIED`.
               Possible values are: `DELETION_RETENTION_UNSPECIFIED`, `MINIMUM`.
        :param pulumi.Input[str] runtime_database_encryption_key_name: Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
               Update is not allowed after the organization is created.
               If not specified, a Google-Managed encryption key will be used.
               Valid only when `RuntimeType` is CLOUD. For example: `projects/foo/locations/us/keyRings/bar/cryptoKeys/baz`.
        :param pulumi.Input[str] runtime_type: Runtime type of the Apigee organization based on the Apigee subscription purchased.
               Default value is `CLOUD`.
               Possible values are: `CLOUD`, `HYBRID`.
        :param pulumi.Input[str] subscription_type: Output only. Subscription type of the Apigee organization.
               Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased).
        """
        if analytics_region is not None:
            pulumi.set(__self__, "analytics_region", analytics_region)
        if apigee_project_id is not None:
            pulumi.set(__self__, "apigee_project_id", apigee_project_id)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_vpc_peering is not None:
            pulumi.set(__self__, "disable_vpc_peering", disable_vpc_peering)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if runtime_database_encryption_key_name is not None:
            pulumi.set(__self__, "runtime_database_encryption_key_name", runtime_database_encryption_key_name)
        if runtime_type is not None:
            pulumi.set(__self__, "runtime_type", runtime_type)
        if subscription_type is not None:
            pulumi.set(__self__, "subscription_type", subscription_type)

    @property
    @pulumi.getter(name="analyticsRegion")
    def analytics_region(self) -> Optional[pulumi.Input[str]]:
        """
        Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        """
        return pulumi.get(self, "analytics_region")

    @analytics_region.setter
    def analytics_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analytics_region", value)

    @property
    @pulumi.getter(name="apigeeProjectId")
    def apigee_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Project ID of the Apigee Tenant Project.
        """
        return pulumi.get(self, "apigee_project_id")

    @apigee_project_id.setter
    def apigee_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apigee_project_id", value)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[str]]:
        """
        Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
        See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
        Valid only when `RuntimeType` is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorized_network", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Base64-encoded public certificate for the root CA of the Apigee organization.
        Valid only when `RuntimeType` is CLOUD. A base64-encoded string.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Apigee organization.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableVpcPeering")
    def disable_vpc_peering(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that specifies whether the VPC Peering through Private Google Access should be
        disabled between the consumer network and Apigee. Required if an `authorizedNetwork`
        on the consumer project is not provided, in which case the flag should be set to `true`.
        Valid only when `RuntimeType` is set to CLOUD. The value must be set before the creation
        of any Apigee runtime instance and can be updated only when there are no runtime instances.
        """
        return pulumi.get(self, "disable_vpc_peering")

    @disable_vpc_peering.setter
    def disable_vpc_peering(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_vpc_peering", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the Apigee organization.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The project ID associated with the Apigee organization.


        - - -
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['OrganizationPropertiesArgs']]:
        """
        Properties defined in the Apigee organization profile.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['OrganizationPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType
        is not EVALUATION). It controls how long Organization data will be retained after the initial delete
        operation completes. During this period, the Organization may be restored to its last known state.
        After this period, the Organization will no longer be able to be restored.
        Default value is `DELETION_RETENTION_UNSPECIFIED`.
        Possible values are: `DELETION_RETENTION_UNSPECIFIED`, `MINIMUM`.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter(name="runtimeDatabaseEncryptionKeyName")
    def runtime_database_encryption_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
        Update is not allowed after the organization is created.
        If not specified, a Google-Managed encryption key will be used.
        Valid only when `RuntimeType` is CLOUD. For example: `projects/foo/locations/us/keyRings/bar/cryptoKeys/baz`.
        """
        return pulumi.get(self, "runtime_database_encryption_key_name")

    @runtime_database_encryption_key_name.setter
    def runtime_database_encryption_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_database_encryption_key_name", value)

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime type of the Apigee organization based on the Apigee subscription purchased.
        Default value is `CLOUD`.
        Possible values are: `CLOUD`, `HYBRID`.
        """
        return pulumi.get(self, "runtime_type")

    @runtime_type.setter
    def runtime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_type", value)

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Subscription type of the Apigee organization.
        Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased).
        """
        return pulumi.get(self, "subscription_type")

    @subscription_type.setter
    def subscription_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_type", value)


class Organization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_region: Optional[pulumi.Input[str]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_vpc_peering: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['OrganizationPropertiesArgs']]] = None,
                 retention: Optional[pulumi.Input[str]] = None,
                 runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An `Organization` is the top-level container in Apigee.

        To get more information about Organization, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations)
        * How-to Guides
            * [Creating an API organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org)

        ## Example Usage
        ### Apigee Organization Cloud Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigeeNetwork")
        apigee_range = gcp.compute.GlobalAddress("apigeeRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigeeVpcConnection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        org = gcp.apigee.Organization("org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts=pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        ```
        ### Apigee Organization Cloud Basic Disable Vpc Peering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        org = gcp.apigee.Organization("org",
            description="Terraform-provisioned basic Apigee Org without VPC Peering.",
            analytics_region="us-central1",
            project_id=current.project,
            disable_vpc_peering=True)
        ```
        ### Apigee Organization Cloud Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigeeNetwork")
        apigee_range = gcp.compute.GlobalAddress("apigeeRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigeeVpcConnection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_keyring = gcp.kms.KeyRing("apigeeKeyring", location="us-central1")
        apigee_key = gcp.kms.CryptoKey("apigeeKey", key_ring=apigee_keyring.id)
        apigee_sa = gcp.projects.ServiceIdentity("apigeeSa",
            project=google_project["project"]["project_id"],
            service=google_project_service["apigee"]["service"],
            opts=pulumi.ResourceOptions(provider=google_beta))
        apigee_sa_keyuser = gcp.kms.CryptoKeyIAMBinding("apigeeSaKeyuser",
            crypto_key_id=apigee_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[apigee_sa.email.apply(lambda email: f"serviceAccount:{email}")])
        org = gcp.apigee.Organization("org",
            analytics_region="us-central1",
            display_name="apigee-org",
            description="Auto-provisioned Apigee Org.",
            project_id=current.project,
            authorized_network=apigee_network.id,
            runtime_database_encryption_key_name=apigee_key.id,
            opts=pulumi.ResourceOptions(depends_on=[
                    apigee_vpc_connection,
                    apigee_sa_keyuser,
                ]))
        ```
        ### Apigee Organization Cloud Full Disable Vpc Peering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_keyring = gcp.kms.KeyRing("apigeeKeyring", location="us-central1")
        apigee_key = gcp.kms.CryptoKey("apigeeKey", key_ring=apigee_keyring.id)
        apigee_sa = gcp.projects.ServiceIdentity("apigeeSa",
            project=google_project["project"]["project_id"],
            service=google_project_service["apigee"]["service"],
            opts=pulumi.ResourceOptions(provider=google_beta))
        apigee_sa_keyuser = gcp.kms.CryptoKeyIAMBinding("apigeeSaKeyuser",
            crypto_key_id=apigee_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[apigee_sa.email.apply(lambda email: f"serviceAccount:{email}")])
        org = gcp.apigee.Organization("org",
            analytics_region="us-central1",
            display_name="apigee-org",
            description="Terraform-provisioned Apigee Org without VPC Peering.",
            project_id=current.project,
            disable_vpc_peering=True,
            runtime_database_encryption_key_name=apigee_key.id,
            opts=pulumi.ResourceOptions(depends_on=[apigee_sa_keyuser]))
        ```

        ## Import

        Organization can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:apigee/organization:Organization default organizations/{{name}}
        ```

        ```sh
         $ pulumi import gcp:apigee/organization:Organization default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analytics_region: Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        :param pulumi.Input[str] authorized_network: Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
               See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
               Valid only when `RuntimeType` is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
        :param pulumi.Input[str] billing_type: Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        :param pulumi.Input[str] description: Description of the Apigee organization.
        :param pulumi.Input[bool] disable_vpc_peering: Flag that specifies whether the VPC Peering through Private Google Access should be
               disabled between the consumer network and Apigee. Required if an `authorizedNetwork`
               on the consumer project is not provided, in which case the flag should be set to `true`.
               Valid only when `RuntimeType` is set to CLOUD. The value must be set before the creation
               of any Apigee runtime instance and can be updated only when there are no runtime instances.
        :param pulumi.Input[str] display_name: The display name of the Apigee organization.
        :param pulumi.Input[str] project_id: The project ID associated with the Apigee organization.
               
               
               - - -
        :param pulumi.Input[pulumi.InputType['OrganizationPropertiesArgs']] properties: Properties defined in the Apigee organization profile.
               Structure is documented below.
        :param pulumi.Input[str] retention: Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType
               is not EVALUATION). It controls how long Organization data will be retained after the initial delete
               operation completes. During this period, the Organization may be restored to its last known state.
               After this period, the Organization will no longer be able to be restored.
               Default value is `DELETION_RETENTION_UNSPECIFIED`.
               Possible values are: `DELETION_RETENTION_UNSPECIFIED`, `MINIMUM`.
        :param pulumi.Input[str] runtime_database_encryption_key_name: Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
               Update is not allowed after the organization is created.
               If not specified, a Google-Managed encryption key will be used.
               Valid only when `RuntimeType` is CLOUD. For example: `projects/foo/locations/us/keyRings/bar/cryptoKeys/baz`.
        :param pulumi.Input[str] runtime_type: Runtime type of the Apigee organization based on the Apigee subscription purchased.
               Default value is `CLOUD`.
               Possible values are: `CLOUD`, `HYBRID`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An `Organization` is the top-level container in Apigee.

        To get more information about Organization, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations)
        * How-to Guides
            * [Creating an API organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org)

        ## Example Usage
        ### Apigee Organization Cloud Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigeeNetwork")
        apigee_range = gcp.compute.GlobalAddress("apigeeRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigeeVpcConnection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        org = gcp.apigee.Organization("org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts=pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        ```
        ### Apigee Organization Cloud Basic Disable Vpc Peering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        org = gcp.apigee.Organization("org",
            description="Terraform-provisioned basic Apigee Org without VPC Peering.",
            analytics_region="us-central1",
            project_id=current.project,
            disable_vpc_peering=True)
        ```
        ### Apigee Organization Cloud Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigeeNetwork")
        apigee_range = gcp.compute.GlobalAddress("apigeeRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigeeVpcConnection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_keyring = gcp.kms.KeyRing("apigeeKeyring", location="us-central1")
        apigee_key = gcp.kms.CryptoKey("apigeeKey", key_ring=apigee_keyring.id)
        apigee_sa = gcp.projects.ServiceIdentity("apigeeSa",
            project=google_project["project"]["project_id"],
            service=google_project_service["apigee"]["service"],
            opts=pulumi.ResourceOptions(provider=google_beta))
        apigee_sa_keyuser = gcp.kms.CryptoKeyIAMBinding("apigeeSaKeyuser",
            crypto_key_id=apigee_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[apigee_sa.email.apply(lambda email: f"serviceAccount:{email}")])
        org = gcp.apigee.Organization("org",
            analytics_region="us-central1",
            display_name="apigee-org",
            description="Auto-provisioned Apigee Org.",
            project_id=current.project,
            authorized_network=apigee_network.id,
            runtime_database_encryption_key_name=apigee_key.id,
            opts=pulumi.ResourceOptions(depends_on=[
                    apigee_vpc_connection,
                    apigee_sa_keyuser,
                ]))
        ```
        ### Apigee Organization Cloud Full Disable Vpc Peering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_keyring = gcp.kms.KeyRing("apigeeKeyring", location="us-central1")
        apigee_key = gcp.kms.CryptoKey("apigeeKey", key_ring=apigee_keyring.id)
        apigee_sa = gcp.projects.ServiceIdentity("apigeeSa",
            project=google_project["project"]["project_id"],
            service=google_project_service["apigee"]["service"],
            opts=pulumi.ResourceOptions(provider=google_beta))
        apigee_sa_keyuser = gcp.kms.CryptoKeyIAMBinding("apigeeSaKeyuser",
            crypto_key_id=apigee_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[apigee_sa.email.apply(lambda email: f"serviceAccount:{email}")])
        org = gcp.apigee.Organization("org",
            analytics_region="us-central1",
            display_name="apigee-org",
            description="Terraform-provisioned Apigee Org without VPC Peering.",
            project_id=current.project,
            disable_vpc_peering=True,
            runtime_database_encryption_key_name=apigee_key.id,
            opts=pulumi.ResourceOptions(depends_on=[apigee_sa_keyuser]))
        ```

        ## Import

        Organization can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:apigee/organization:Organization default organizations/{{name}}
        ```

        ```sh
         $ pulumi import gcp:apigee/organization:Organization default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_region: Optional[pulumi.Input[str]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_vpc_peering: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['OrganizationPropertiesArgs']]] = None,
                 retention: Optional[pulumi.Input[str]] = None,
                 runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationArgs.__new__(OrganizationArgs)

            __props__.__dict__["analytics_region"] = analytics_region
            __props__.__dict__["authorized_network"] = authorized_network
            __props__.__dict__["billing_type"] = billing_type
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_vpc_peering"] = disable_vpc_peering
            __props__.__dict__["display_name"] = display_name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["properties"] = properties
            __props__.__dict__["retention"] = retention
            __props__.__dict__["runtime_database_encryption_key_name"] = runtime_database_encryption_key_name
            __props__.__dict__["runtime_type"] = runtime_type
            __props__.__dict__["apigee_project_id"] = None
            __props__.__dict__["ca_certificate"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["subscription_type"] = None
        super(Organization, __self__).__init__(
            'gcp:apigee/organization:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analytics_region: Optional[pulumi.Input[str]] = None,
            apigee_project_id: Optional[pulumi.Input[str]] = None,
            authorized_network: Optional[pulumi.Input[str]] = None,
            billing_type: Optional[pulumi.Input[str]] = None,
            ca_certificate: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disable_vpc_peering: Optional[pulumi.Input[bool]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            properties: Optional[pulumi.Input[pulumi.InputType['OrganizationPropertiesArgs']]] = None,
            retention: Optional[pulumi.Input[str]] = None,
            runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
            runtime_type: Optional[pulumi.Input[str]] = None,
            subscription_type: Optional[pulumi.Input[str]] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analytics_region: Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        :param pulumi.Input[str] apigee_project_id: Output only. Project ID of the Apigee Tenant Project.
        :param pulumi.Input[str] authorized_network: Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
               See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
               Valid only when `RuntimeType` is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
        :param pulumi.Input[str] billing_type: Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        :param pulumi.Input[str] ca_certificate: Output only. Base64-encoded public certificate for the root CA of the Apigee organization.
               Valid only when `RuntimeType` is CLOUD. A base64-encoded string.
        :param pulumi.Input[str] description: Description of the Apigee organization.
        :param pulumi.Input[bool] disable_vpc_peering: Flag that specifies whether the VPC Peering through Private Google Access should be
               disabled between the consumer network and Apigee. Required if an `authorizedNetwork`
               on the consumer project is not provided, in which case the flag should be set to `true`.
               Valid only when `RuntimeType` is set to CLOUD. The value must be set before the creation
               of any Apigee runtime instance and can be updated only when there are no runtime instances.
        :param pulumi.Input[str] display_name: The display name of the Apigee organization.
        :param pulumi.Input[str] name: Name of the property.
        :param pulumi.Input[str] project_id: The project ID associated with the Apigee organization.
               
               
               - - -
        :param pulumi.Input[pulumi.InputType['OrganizationPropertiesArgs']] properties: Properties defined in the Apigee organization profile.
               Structure is documented below.
        :param pulumi.Input[str] retention: Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType
               is not EVALUATION). It controls how long Organization data will be retained after the initial delete
               operation completes. During this period, the Organization may be restored to its last known state.
               After this period, the Organization will no longer be able to be restored.
               Default value is `DELETION_RETENTION_UNSPECIFIED`.
               Possible values are: `DELETION_RETENTION_UNSPECIFIED`, `MINIMUM`.
        :param pulumi.Input[str] runtime_database_encryption_key_name: Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
               Update is not allowed after the organization is created.
               If not specified, a Google-Managed encryption key will be used.
               Valid only when `RuntimeType` is CLOUD. For example: `projects/foo/locations/us/keyRings/bar/cryptoKeys/baz`.
        :param pulumi.Input[str] runtime_type: Runtime type of the Apigee organization based on the Apigee subscription purchased.
               Default value is `CLOUD`.
               Possible values are: `CLOUD`, `HYBRID`.
        :param pulumi.Input[str] subscription_type: Output only. Subscription type of the Apigee organization.
               Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationState.__new__(_OrganizationState)

        __props__.__dict__["analytics_region"] = analytics_region
        __props__.__dict__["apigee_project_id"] = apigee_project_id
        __props__.__dict__["authorized_network"] = authorized_network
        __props__.__dict__["billing_type"] = billing_type
        __props__.__dict__["ca_certificate"] = ca_certificate
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_vpc_peering"] = disable_vpc_peering
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["properties"] = properties
        __props__.__dict__["retention"] = retention
        __props__.__dict__["runtime_database_encryption_key_name"] = runtime_database_encryption_key_name
        __props__.__dict__["runtime_type"] = runtime_type
        __props__.__dict__["subscription_type"] = subscription_type
        return Organization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analyticsRegion")
    def analytics_region(self) -> pulumi.Output[Optional[str]]:
        """
        Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        """
        return pulumi.get(self, "analytics_region")

    @property
    @pulumi.getter(name="apigeeProjectId")
    def apigee_project_id(self) -> pulumi.Output[str]:
        """
        Output only. Project ID of the Apigee Tenant Project.
        """
        return pulumi.get(self, "apigee_project_id")

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Output[Optional[str]]:
        """
        Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
        See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
        Valid only when `RuntimeType` is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
        """
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Output[str]:
        """
        Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Output[str]:
        """
        Output only. Base64-encoded public certificate for the root CA of the Apigee organization.
        Valid only when `RuntimeType` is CLOUD. A base64-encoded string.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Apigee organization.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableVpcPeering")
    def disable_vpc_peering(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag that specifies whether the VPC Peering through Private Google Access should be
        disabled between the consumer network and Apigee. Required if an `authorizedNetwork`
        on the consumer project is not provided, in which case the flag should be set to `true`.
        Valid only when `RuntimeType` is set to CLOUD. The value must be set before the creation
        of any Apigee runtime instance and can be updated only when there are no runtime instances.
        """
        return pulumi.get(self, "disable_vpc_peering")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name of the Apigee organization.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The project ID associated with the Apigee organization.


        - - -
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.OrganizationProperties']:
        """
        Properties defined in the Apigee organization profile.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def retention(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType
        is not EVALUATION). It controls how long Organization data will be retained after the initial delete
        operation completes. During this period, the Organization may be restored to its last known state.
        After this period, the Organization will no longer be able to be restored.
        Default value is `DELETION_RETENTION_UNSPECIFIED`.
        Possible values are: `DELETION_RETENTION_UNSPECIFIED`, `MINIMUM`.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="runtimeDatabaseEncryptionKeyName")
    def runtime_database_encryption_key_name(self) -> pulumi.Output[Optional[str]]:
        """
        Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
        Update is not allowed after the organization is created.
        If not specified, a Google-Managed encryption key will be used.
        Valid only when `RuntimeType` is CLOUD. For example: `projects/foo/locations/us/keyRings/bar/cryptoKeys/baz`.
        """
        return pulumi.get(self, "runtime_database_encryption_key_name")

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> pulumi.Output[Optional[str]]:
        """
        Runtime type of the Apigee organization based on the Apigee subscription purchased.
        Default value is `CLOUD`.
        Possible values are: `CLOUD`, `HYBRID`.
        """
        return pulumi.get(self, "runtime_type")

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> pulumi.Output[str]:
        """
        Output only. Subscription type of the Apigee organization.
        Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased).
        """
        return pulumi.get(self, "subscription_type")

