# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SharedflowArgs', 'Sharedflow']

@pulumi.input_type
class SharedflowArgs:
    def __init__(__self__, *,
                 config_bundle: pulumi.Input[str],
                 org_id: pulumi.Input[str],
                 detect_md5hash: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Sharedflow resource.
        :param pulumi.Input[str] config_bundle: Path to the config zip bundle.
               
               - - -
        :param pulumi.Input[str] org_id: The Apigee Organization name associated with the Apigee instance.
        :param pulumi.Input[str] detect_md5hash: A hash of local config bundle in string, user needs to use a Terraform Hash function of their choice. A change in hash
               will trigger an update.
        :param pulumi.Input[str] name: The ID of the shared flow.
        """
        pulumi.set(__self__, "config_bundle", config_bundle)
        pulumi.set(__self__, "org_id", org_id)
        if detect_md5hash is not None:
            pulumi.set(__self__, "detect_md5hash", detect_md5hash)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="configBundle")
    def config_bundle(self) -> pulumi.Input[str]:
        """
        Path to the config zip bundle.

        - - -
        """
        return pulumi.get(self, "config_bundle")

    @config_bundle.setter
    def config_bundle(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_bundle", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[str]:
        """
        The Apigee Organization name associated with the Apigee instance.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> Optional[pulumi.Input[str]]:
        """
        A hash of local config bundle in string, user needs to use a Terraform Hash function of their choice. A change in hash
        will trigger an update.
        """
        return pulumi.get(self, "detect_md5hash")

    @detect_md5hash.setter
    def detect_md5hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detect_md5hash", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the shared flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SharedflowState:
    def __init__(__self__, *,
                 config_bundle: Optional[pulumi.Input[str]] = None,
                 detect_md5hash: Optional[pulumi.Input[str]] = None,
                 latest_revision_id: Optional[pulumi.Input[str]] = None,
                 md5hash: Optional[pulumi.Input[str]] = None,
                 meta_datas: Optional[pulumi.Input[Sequence[pulumi.Input['SharedflowMetaDataArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 revisions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Sharedflow resources.
        :param pulumi.Input[str] config_bundle: Path to the config zip bundle.
               
               - - -
        :param pulumi.Input[str] detect_md5hash: A hash of local config bundle in string, user needs to use a Terraform Hash function of their choice. A change in hash
               will trigger an update.
        :param pulumi.Input[str] latest_revision_id: The id of the most recently created revision for this shared flow.
        :param pulumi.Input[str] md5hash: (Computed) Base 64 MD5 hash of the uploaded data. It is speculative as remote does not return hash of the bundle. Remote changes are detected using returned last_modified timestamp.
        :param pulumi.Input[Sequence[pulumi.Input['SharedflowMetaDataArgs']]] meta_datas: Metadata describing the shared flow.
               Structure is documented below.
        :param pulumi.Input[str] name: The ID of the shared flow.
        :param pulumi.Input[str] org_id: The Apigee Organization name associated with the Apigee instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] revisions: A list of revisions of this shared flow.
        """
        if config_bundle is not None:
            pulumi.set(__self__, "config_bundle", config_bundle)
        if detect_md5hash is not None:
            pulumi.set(__self__, "detect_md5hash", detect_md5hash)
        if latest_revision_id is not None:
            pulumi.set(__self__, "latest_revision_id", latest_revision_id)
        if md5hash is not None:
            pulumi.set(__self__, "md5hash", md5hash)
        if meta_datas is not None:
            pulumi.set(__self__, "meta_datas", meta_datas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if revisions is not None:
            pulumi.set(__self__, "revisions", revisions)

    @property
    @pulumi.getter(name="configBundle")
    def config_bundle(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the config zip bundle.

        - - -
        """
        return pulumi.get(self, "config_bundle")

    @config_bundle.setter
    def config_bundle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_bundle", value)

    @property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> Optional[pulumi.Input[str]]:
        """
        A hash of local config bundle in string, user needs to use a Terraform Hash function of their choice. A change in hash
        will trigger an update.
        """
        return pulumi.get(self, "detect_md5hash")

    @detect_md5hash.setter
    def detect_md5hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detect_md5hash", value)

    @property
    @pulumi.getter(name="latestRevisionId")
    def latest_revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the most recently created revision for this shared flow.
        """
        return pulumi.get(self, "latest_revision_id")

    @latest_revision_id.setter
    def latest_revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_revision_id", value)

    @property
    @pulumi.getter
    def md5hash(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) Base 64 MD5 hash of the uploaded data. It is speculative as remote does not return hash of the bundle. Remote changes are detected using returned last_modified timestamp.
        """
        return pulumi.get(self, "md5hash")

    @md5hash.setter
    def md5hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5hash", value)

    @property
    @pulumi.getter(name="metaDatas")
    def meta_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SharedflowMetaDataArgs']]]]:
        """
        Metadata describing the shared flow.
        Structure is documented below.
        """
        return pulumi.get(self, "meta_datas")

    @meta_datas.setter
    def meta_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SharedflowMetaDataArgs']]]]):
        pulumi.set(self, "meta_datas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the shared flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Apigee Organization name associated with the Apigee instance.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def revisions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of revisions of this shared flow.
        """
        return pulumi.get(self, "revisions")

    @revisions.setter
    def revisions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "revisions", value)


class Sharedflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_bundle: Optional[pulumi.Input[str]] = None,
                 detect_md5hash: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        You can combine policies and resources into a shared flow that you can consume from multiple API proxies, and even from other shared flows. Although it's like a proxy, a shared flow has no endpoint. It can be used only from an API proxy or shared flow that's in the same organization as the shared flow itself.

        To get more information about SharedFlow, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.sharedflows)
        * How-to Guides
            * [Sharedflows](https://cloud.google.com/apigee/docs/resources)

        ## Import

        SharedFlow can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:apigee/sharedflow:Sharedflow default {{org_id}}/sharedflows/{{name}}
        ```

        ```sh
         $ pulumi import gcp:apigee/sharedflow:Sharedflow default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_bundle: Path to the config zip bundle.
               
               - - -
        :param pulumi.Input[str] detect_md5hash: A hash of local config bundle in string, user needs to use a Terraform Hash function of their choice. A change in hash
               will trigger an update.
        :param pulumi.Input[str] name: The ID of the shared flow.
        :param pulumi.Input[str] org_id: The Apigee Organization name associated with the Apigee instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        You can combine policies and resources into a shared flow that you can consume from multiple API proxies, and even from other shared flows. Although it's like a proxy, a shared flow has no endpoint. It can be used only from an API proxy or shared flow that's in the same organization as the shared flow itself.

        To get more information about SharedFlow, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.sharedflows)
        * How-to Guides
            * [Sharedflows](https://cloud.google.com/apigee/docs/resources)

        ## Import

        SharedFlow can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:apigee/sharedflow:Sharedflow default {{org_id}}/sharedflows/{{name}}
        ```

        ```sh
         $ pulumi import gcp:apigee/sharedflow:Sharedflow default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SharedflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_bundle: Optional[pulumi.Input[str]] = None,
                 detect_md5hash: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedflowArgs.__new__(SharedflowArgs)

            if config_bundle is None and not opts.urn:
                raise TypeError("Missing required property 'config_bundle'")
            __props__.__dict__["config_bundle"] = config_bundle
            __props__.__dict__["detect_md5hash"] = detect_md5hash
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["latest_revision_id"] = None
            __props__.__dict__["md5hash"] = None
            __props__.__dict__["meta_datas"] = None
            __props__.__dict__["revisions"] = None
        super(Sharedflow, __self__).__init__(
            'gcp:apigee/sharedflow:Sharedflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_bundle: Optional[pulumi.Input[str]] = None,
            detect_md5hash: Optional[pulumi.Input[str]] = None,
            latest_revision_id: Optional[pulumi.Input[str]] = None,
            md5hash: Optional[pulumi.Input[str]] = None,
            meta_datas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SharedflowMetaDataArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            revisions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Sharedflow':
        """
        Get an existing Sharedflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_bundle: Path to the config zip bundle.
               
               - - -
        :param pulumi.Input[str] detect_md5hash: A hash of local config bundle in string, user needs to use a Terraform Hash function of their choice. A change in hash
               will trigger an update.
        :param pulumi.Input[str] latest_revision_id: The id of the most recently created revision for this shared flow.
        :param pulumi.Input[str] md5hash: (Computed) Base 64 MD5 hash of the uploaded data. It is speculative as remote does not return hash of the bundle. Remote changes are detected using returned last_modified timestamp.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SharedflowMetaDataArgs']]]] meta_datas: Metadata describing the shared flow.
               Structure is documented below.
        :param pulumi.Input[str] name: The ID of the shared flow.
        :param pulumi.Input[str] org_id: The Apigee Organization name associated with the Apigee instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] revisions: A list of revisions of this shared flow.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedflowState.__new__(_SharedflowState)

        __props__.__dict__["config_bundle"] = config_bundle
        __props__.__dict__["detect_md5hash"] = detect_md5hash
        __props__.__dict__["latest_revision_id"] = latest_revision_id
        __props__.__dict__["md5hash"] = md5hash
        __props__.__dict__["meta_datas"] = meta_datas
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["revisions"] = revisions
        return Sharedflow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configBundle")
    def config_bundle(self) -> pulumi.Output[str]:
        """
        Path to the config zip bundle.

        - - -
        """
        return pulumi.get(self, "config_bundle")

    @property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> pulumi.Output[Optional[str]]:
        """
        A hash of local config bundle in string, user needs to use a Terraform Hash function of their choice. A change in hash
        will trigger an update.
        """
        return pulumi.get(self, "detect_md5hash")

    @property
    @pulumi.getter(name="latestRevisionId")
    def latest_revision_id(self) -> pulumi.Output[str]:
        """
        The id of the most recently created revision for this shared flow.
        """
        return pulumi.get(self, "latest_revision_id")

    @property
    @pulumi.getter
    def md5hash(self) -> pulumi.Output[str]:
        """
        (Computed) Base 64 MD5 hash of the uploaded data. It is speculative as remote does not return hash of the bundle. Remote changes are detected using returned last_modified timestamp.
        """
        return pulumi.get(self, "md5hash")

    @property
    @pulumi.getter(name="metaDatas")
    def meta_datas(self) -> pulumi.Output[Sequence['outputs.SharedflowMetaData']]:
        """
        Metadata describing the shared flow.
        Structure is documented below.
        """
        return pulumi.get(self, "meta_datas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The ID of the shared flow.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[str]:
        """
        The Apigee Organization name associated with the Apigee instance.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def revisions(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of revisions of this shared flow.
        """
        return pulumi.get(self, "revisions")

