# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainMappingArgs', 'DomainMapping']

@pulumi.input_type
class DomainMappingArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 override_strategy: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ssl_settings: Optional[pulumi.Input['DomainMappingSslSettingsArgs']] = None):
        """
        The set of arguments for constructing a DomainMapping resource.
        :param pulumi.Input[str] domain_name: Relative name of the domain serving the application. Example: example.com.
               
               
               - - -
        :param pulumi.Input[str] override_strategy: Whether the domain creation should override any existing mappings for this domain.
               By default, overrides are rejected.
               Default value is `STRICT`.
               Possible values are: `STRICT`, `OVERRIDE`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['DomainMappingSslSettingsArgs'] ssl_settings: SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
               Structure is documented below.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if override_strategy is not None:
            pulumi.set(__self__, "override_strategy", override_strategy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if ssl_settings is not None:
            pulumi.set(__self__, "ssl_settings", ssl_settings)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Relative name of the domain serving the application. Example: example.com.


        - - -
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="overrideStrategy")
    def override_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the domain creation should override any existing mappings for this domain.
        By default, overrides are rejected.
        Default value is `STRICT`.
        Possible values are: `STRICT`, `OVERRIDE`.
        """
        return pulumi.get(self, "override_strategy")

    @override_strategy.setter
    def override_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "override_strategy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sslSettings")
    def ssl_settings(self) -> Optional[pulumi.Input['DomainMappingSslSettingsArgs']]:
        """
        SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_settings")

    @ssl_settings.setter
    def ssl_settings(self, value: Optional[pulumi.Input['DomainMappingSslSettingsArgs']]):
        pulumi.set(self, "ssl_settings", value)


@pulumi.input_type
class _DomainMappingState:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_strategy: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 resource_records: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingResourceRecordArgs']]]] = None,
                 ssl_settings: Optional[pulumi.Input['DomainMappingSslSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering DomainMapping resources.
        :param pulumi.Input[str] domain_name: Relative name of the domain serving the application. Example: example.com.
               
               
               - - -
        :param pulumi.Input[str] name: Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        :param pulumi.Input[str] override_strategy: Whether the domain creation should override any existing mappings for this domain.
               By default, overrides are rejected.
               Default value is `STRICT`.
               Possible values are: `STRICT`, `OVERRIDE`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['DomainMappingResourceRecordArgs']]] resource_records: The resource records required to configure this domain mapping. These records must be added to the domain's DNS
               configuration in order to serve the application via this domain mapping.
               Structure is documented below.
        :param pulumi.Input['DomainMappingSslSettingsArgs'] ssl_settings: SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
               Structure is documented below.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if override_strategy is not None:
            pulumi.set(__self__, "override_strategy", override_strategy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_records is not None:
            pulumi.set(__self__, "resource_records", resource_records)
        if ssl_settings is not None:
            pulumi.set(__self__, "ssl_settings", ssl_settings)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Relative name of the domain serving the application. Example: example.com.


        - - -
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overrideStrategy")
    def override_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the domain creation should override any existing mappings for this domain.
        By default, overrides are rejected.
        Default value is `STRICT`.
        Possible values are: `STRICT`, `OVERRIDE`.
        """
        return pulumi.get(self, "override_strategy")

    @override_strategy.setter
    def override_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "override_strategy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingResourceRecordArgs']]]]:
        """
        The resource records required to configure this domain mapping. These records must be added to the domain's DNS
        configuration in order to serve the application via this domain mapping.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_records")

    @resource_records.setter
    def resource_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingResourceRecordArgs']]]]):
        pulumi.set(self, "resource_records", value)

    @property
    @pulumi.getter(name="sslSettings")
    def ssl_settings(self) -> Optional[pulumi.Input['DomainMappingSslSettingsArgs']]:
        """
        SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_settings")

    @ssl_settings.setter
    def ssl_settings(self, value: Optional[pulumi.Input['DomainMappingSslSettingsArgs']]):
        pulumi.set(self, "ssl_settings", value)


class DomainMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 override_strategy: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ssl_settings: Optional[pulumi.Input[pulumi.InputType['DomainMappingSslSettingsArgs']]] = None,
                 __props__=None):
        """
        A domain serving an App Engine application.

        To get more information about DomainMapping, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.domainMappings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/appengine/docs/standard/python/mapping-custom-domains)

        ## Example Usage
        ### App Engine Domain Mapping Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        domain_mapping = gcp.appengine.DomainMapping("domainMapping",
            domain_name="verified-domain.com",
            ssl_settings=gcp.appengine.DomainMappingSslSettingsArgs(
                ssl_management_type="AUTOMATIC",
            ))
        ```

        ## Import

        DomainMapping can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:appengine/domainMapping:DomainMapping default apps/{{project}}/domainMappings/{{domain_name}}
        ```

        ```sh
         $ pulumi import gcp:appengine/domainMapping:DomainMapping default {{project}}/{{domain_name}}
        ```

        ```sh
         $ pulumi import gcp:appengine/domainMapping:DomainMapping default {{domain_name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: Relative name of the domain serving the application. Example: example.com.
               
               
               - - -
        :param pulumi.Input[str] override_strategy: Whether the domain creation should override any existing mappings for this domain.
               By default, overrides are rejected.
               Default value is `STRICT`.
               Possible values are: `STRICT`, `OVERRIDE`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['DomainMappingSslSettingsArgs']] ssl_settings: SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A domain serving an App Engine application.

        To get more information about DomainMapping, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.domainMappings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/appengine/docs/standard/python/mapping-custom-domains)

        ## Example Usage
        ### App Engine Domain Mapping Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        domain_mapping = gcp.appengine.DomainMapping("domainMapping",
            domain_name="verified-domain.com",
            ssl_settings=gcp.appengine.DomainMappingSslSettingsArgs(
                ssl_management_type="AUTOMATIC",
            ))
        ```

        ## Import

        DomainMapping can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:appengine/domainMapping:DomainMapping default apps/{{project}}/domainMappings/{{domain_name}}
        ```

        ```sh
         $ pulumi import gcp:appengine/domainMapping:DomainMapping default {{project}}/{{domain_name}}
        ```

        ```sh
         $ pulumi import gcp:appengine/domainMapping:DomainMapping default {{domain_name}}
        ```

        :param str resource_name: The name of the resource.
        :param DomainMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 override_strategy: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ssl_settings: Optional[pulumi.Input[pulumi.InputType['DomainMappingSslSettingsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainMappingArgs.__new__(DomainMappingArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["override_strategy"] = override_strategy
            __props__.__dict__["project"] = project
            __props__.__dict__["ssl_settings"] = ssl_settings
            __props__.__dict__["name"] = None
            __props__.__dict__["resource_records"] = None
        super(DomainMapping, __self__).__init__(
            'gcp:appengine/domainMapping:DomainMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            override_strategy: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            resource_records: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainMappingResourceRecordArgs']]]]] = None,
            ssl_settings: Optional[pulumi.Input[pulumi.InputType['DomainMappingSslSettingsArgs']]] = None) -> 'DomainMapping':
        """
        Get an existing DomainMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: Relative name of the domain serving the application. Example: example.com.
               
               
               - - -
        :param pulumi.Input[str] name: Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        :param pulumi.Input[str] override_strategy: Whether the domain creation should override any existing mappings for this domain.
               By default, overrides are rejected.
               Default value is `STRICT`.
               Possible values are: `STRICT`, `OVERRIDE`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainMappingResourceRecordArgs']]]] resource_records: The resource records required to configure this domain mapping. These records must be added to the domain's DNS
               configuration in order to serve the application via this domain mapping.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['DomainMappingSslSettingsArgs']] ssl_settings: SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainMappingState.__new__(_DomainMappingState)

        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["name"] = name
        __props__.__dict__["override_strategy"] = override_strategy
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_records"] = resource_records
        __props__.__dict__["ssl_settings"] = ssl_settings
        return DomainMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Relative name of the domain serving the application. Example: example.com.


        - - -
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overrideStrategy")
    def override_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        Whether the domain creation should override any existing mappings for this domain.
        By default, overrides are rejected.
        Default value is `STRICT`.
        Possible values are: `STRICT`, `OVERRIDE`.
        """
        return pulumi.get(self, "override_strategy")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> pulumi.Output[Sequence['outputs.DomainMappingResourceRecord']]:
        """
        The resource records required to configure this domain mapping. These records must be added to the domain's DNS
        configuration in order to serve the application via this domain mapping.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_records")

    @property
    @pulumi.getter(name="sslSettings")
    def ssl_settings(self) -> pulumi.Output[Optional['outputs.DomainMappingSslSettings']]:
        """
        SSL configuration for this domain. If unconfigured, this domain will not serve with SSL.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_settings")

