# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlexibleAppVersionArgs', 'FlexibleAppVersion']

@pulumi.input_type
class FlexibleAppVersionArgs:
    def __init__(__self__, *,
                 liveness_check: pulumi.Input['FlexibleAppVersionLivenessCheckArgs'],
                 readiness_check: pulumi.Input['FlexibleAppVersionReadinessCheckArgs'],
                 runtime: pulumi.Input[str],
                 service: pulumi.Input[str],
                 api_config: Optional[pulumi.Input['FlexibleAppVersionApiConfigArgs']] = None,
                 automatic_scaling: Optional[pulumi.Input['FlexibleAppVersionAutomaticScalingArgs']] = None,
                 beta_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 default_expiration: Optional[pulumi.Input[str]] = None,
                 delete_service_on_destroy: Optional[pulumi.Input[bool]] = None,
                 deployment: Optional[pulumi.Input['FlexibleAppVersionDeploymentArgs']] = None,
                 endpoints_api_service: Optional[pulumi.Input['FlexibleAppVersionEndpointsApiServiceArgs']] = None,
                 entrypoint: Optional[pulumi.Input['FlexibleAppVersionEntrypointArgs']] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input['FlexibleAppVersionHandlerArgs']]]] = None,
                 inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 manual_scaling: Optional[pulumi.Input['FlexibleAppVersionManualScalingArgs']] = None,
                 network: Optional[pulumi.Input['FlexibleAppVersionNetworkArgs']] = None,
                 nobuild_files_regex: Optional[pulumi.Input[str]] = None,
                 noop_on_destroy: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input['FlexibleAppVersionResourcesArgs']] = None,
                 runtime_api_version: Optional[pulumi.Input[str]] = None,
                 runtime_channel: Optional[pulumi.Input[str]] = None,
                 runtime_main_executable_path: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 serving_status: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 vpc_access_connector: Optional[pulumi.Input['FlexibleAppVersionVpcAccessConnectorArgs']] = None):
        """
        The set of arguments for constructing a FlexibleAppVersion resource.
        :param pulumi.Input['FlexibleAppVersionLivenessCheckArgs'] liveness_check: Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionReadinessCheckArgs'] readiness_check: Configures readiness health checking for instances. Unhealthy instances are not put into the backend traffic rotation.
               Structure is documented below.
        :param pulumi.Input[str] runtime: Desired runtime. Example python27.
        :param pulumi.Input[str] service: AppEngine service resource. Can contain numbers, letters, and hyphens.
        :param pulumi.Input['FlexibleAppVersionApiConfigArgs'] api_config: Serving configuration for Google Cloud Endpoints.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionAutomaticScalingArgs'] automatic_scaling: Automatic scaling is based on request rate, response latencies, and other application metrics.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] beta_settings: Metadata settings that are supplied to this version to enable beta runtime features.
        :param pulumi.Input[str] default_expiration: Duration that static files should be cached by web proxies and browsers.
               Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        :param pulumi.Input[bool] delete_service_on_destroy: If set to `true`, the service will be deleted if it is the last version.
        :param pulumi.Input['FlexibleAppVersionDeploymentArgs'] deployment: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionEndpointsApiServiceArgs'] endpoints_api_service: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionEntrypointArgs'] entrypoint: The entrypoint for the application.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_variables: Environment variables available to the application.  As these are not returned in the API request, the provider will not detect any changes made outside of the config.
        :param pulumi.Input[Sequence[pulumi.Input['FlexibleAppVersionHandlerArgs']]] handlers: An ordered list of URL-matching patterns that should be applied to incoming requests.
               The first matching URL handles the request and other request handlers are not attempted.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_services: A list of the types of messages that this application is able to receive.
               Each value may be one of: `INBOUND_SERVICE_MAIL`, `INBOUND_SERVICE_MAIL_BOUNCE`, `INBOUND_SERVICE_XMPP_ERROR`, `INBOUND_SERVICE_XMPP_MESSAGE`, `INBOUND_SERVICE_XMPP_SUBSCRIBE`, `INBOUND_SERVICE_XMPP_PRESENCE`, `INBOUND_SERVICE_CHANNEL_PRESENCE`, `INBOUND_SERVICE_WARMUP`.
        :param pulumi.Input[str] instance_class: Instance class that is used to run this version. Valid values are
               AutomaticScaling: F1, F2, F4, F4_1G
               ManualScaling: B1, B2, B4, B8, B4_1G
               Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        :param pulumi.Input['FlexibleAppVersionManualScalingArgs'] manual_scaling: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionNetworkArgs'] network: Extra network settings
               Structure is documented below.
        :param pulumi.Input[str] nobuild_files_regex: Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        :param pulumi.Input[bool] noop_on_destroy: If set to `true`, the application version will not be deleted.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['FlexibleAppVersionResourcesArgs'] resources: Machine resources for a version.
               Structure is documented below.
        :param pulumi.Input[str] runtime_api_version: The version of the API in the given runtime environment.
               Please see the app.yaml reference for valid values at `https://cloud.google.com/appengine/docs/standard/<language>/config/appref`\\
               Substitute `<language>` with `python`, `java`, `php`, `ruby`, `go` or `nodejs`.
        :param pulumi.Input[str] runtime_channel: The channel of the runtime to use. Only available for some runtimes.
        :param pulumi.Input[str] runtime_main_executable_path: The path or name of the app's main executable.
        :param pulumi.Input[str] service_account: The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
               default if this field is neither provided in app.yaml file nor through CLI flag.
        :param pulumi.Input[str] serving_status: Current serving status of this version. Only the versions with a SERVING status create instances and can be billed.
               Default value is `SERVING`.
               Possible values are: `SERVING`, `STOPPED`.
        :param pulumi.Input[str] version_id: Relative name of the version within the service. For example, `v1`. Version names can contain only lowercase letters, numbers, or hyphens.
               Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param pulumi.Input['FlexibleAppVersionVpcAccessConnectorArgs'] vpc_access_connector: Enables VPC connectivity for standard apps.
               Structure is documented below.
        """
        pulumi.set(__self__, "liveness_check", liveness_check)
        pulumi.set(__self__, "readiness_check", readiness_check)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "service", service)
        if api_config is not None:
            pulumi.set(__self__, "api_config", api_config)
        if automatic_scaling is not None:
            pulumi.set(__self__, "automatic_scaling", automatic_scaling)
        if beta_settings is not None:
            pulumi.set(__self__, "beta_settings", beta_settings)
        if default_expiration is not None:
            pulumi.set(__self__, "default_expiration", default_expiration)
        if delete_service_on_destroy is not None:
            pulumi.set(__self__, "delete_service_on_destroy", delete_service_on_destroy)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if endpoints_api_service is not None:
            pulumi.set(__self__, "endpoints_api_service", endpoints_api_service)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if handlers is not None:
            pulumi.set(__self__, "handlers", handlers)
        if inbound_services is not None:
            pulumi.set(__self__, "inbound_services", inbound_services)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if manual_scaling is not None:
            pulumi.set(__self__, "manual_scaling", manual_scaling)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if nobuild_files_regex is not None:
            pulumi.set(__self__, "nobuild_files_regex", nobuild_files_regex)
        if noop_on_destroy is not None:
            pulumi.set(__self__, "noop_on_destroy", noop_on_destroy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if runtime_api_version is not None:
            pulumi.set(__self__, "runtime_api_version", runtime_api_version)
        if runtime_channel is not None:
            pulumi.set(__self__, "runtime_channel", runtime_channel)
        if runtime_main_executable_path is not None:
            pulumi.set(__self__, "runtime_main_executable_path", runtime_main_executable_path)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if serving_status is not None:
            pulumi.set(__self__, "serving_status", serving_status)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if vpc_access_connector is not None:
            pulumi.set(__self__, "vpc_access_connector", vpc_access_connector)

    @property
    @pulumi.getter(name="livenessCheck")
    def liveness_check(self) -> pulumi.Input['FlexibleAppVersionLivenessCheckArgs']:
        """
        Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_check")

    @liveness_check.setter
    def liveness_check(self, value: pulumi.Input['FlexibleAppVersionLivenessCheckArgs']):
        pulumi.set(self, "liveness_check", value)

    @property
    @pulumi.getter(name="readinessCheck")
    def readiness_check(self) -> pulumi.Input['FlexibleAppVersionReadinessCheckArgs']:
        """
        Configures readiness health checking for instances. Unhealthy instances are not put into the backend traffic rotation.
        Structure is documented below.
        """
        return pulumi.get(self, "readiness_check")

    @readiness_check.setter
    def readiness_check(self, value: pulumi.Input['FlexibleAppVersionReadinessCheckArgs']):
        pulumi.set(self, "readiness_check", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[str]:
        """
        Desired runtime. Example python27.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        AppEngine service resource. Can contain numbers, letters, and hyphens.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="apiConfig")
    def api_config(self) -> Optional[pulumi.Input['FlexibleAppVersionApiConfigArgs']]:
        """
        Serving configuration for Google Cloud Endpoints.
        Structure is documented below.
        """
        return pulumi.get(self, "api_config")

    @api_config.setter
    def api_config(self, value: Optional[pulumi.Input['FlexibleAppVersionApiConfigArgs']]):
        pulumi.set(self, "api_config", value)

    @property
    @pulumi.getter(name="automaticScaling")
    def automatic_scaling(self) -> Optional[pulumi.Input['FlexibleAppVersionAutomaticScalingArgs']]:
        """
        Automatic scaling is based on request rate, response latencies, and other application metrics.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_scaling")

    @automatic_scaling.setter
    def automatic_scaling(self, value: Optional[pulumi.Input['FlexibleAppVersionAutomaticScalingArgs']]):
        pulumi.set(self, "automatic_scaling", value)

    @property
    @pulumi.getter(name="betaSettings")
    def beta_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata settings that are supplied to this version to enable beta runtime features.
        """
        return pulumi.get(self, "beta_settings")

    @beta_settings.setter
    def beta_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "beta_settings", value)

    @property
    @pulumi.getter(name="defaultExpiration")
    def default_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        Duration that static files should be cached by web proxies and browsers.
        Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        """
        return pulumi.get(self, "default_expiration")

    @default_expiration.setter
    def default_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_expiration", value)

    @property
    @pulumi.getter(name="deleteServiceOnDestroy")
    def delete_service_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the service will be deleted if it is the last version.
        """
        return pulumi.get(self, "delete_service_on_destroy")

    @delete_service_on_destroy.setter
    def delete_service_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_service_on_destroy", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['FlexibleAppVersionDeploymentArgs']]:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['FlexibleAppVersionDeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter(name="endpointsApiService")
    def endpoints_api_service(self) -> Optional[pulumi.Input['FlexibleAppVersionEndpointsApiServiceArgs']]:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints_api_service")

    @endpoints_api_service.setter
    def endpoints_api_service(self, value: Optional[pulumi.Input['FlexibleAppVersionEndpointsApiServiceArgs']]):
        pulumi.set(self, "endpoints_api_service", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input['FlexibleAppVersionEntrypointArgs']]:
        """
        The entrypoint for the application.
        Structure is documented below.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input['FlexibleAppVersionEntrypointArgs']]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables available to the application.  As these are not returned in the API request, the provider will not detect any changes made outside of the config.
        """
        return pulumi.get(self, "env_variables")

    @env_variables.setter
    def env_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env_variables", value)

    @property
    @pulumi.getter
    def handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlexibleAppVersionHandlerArgs']]]]:
        """
        An ordered list of URL-matching patterns that should be applied to incoming requests.
        The first matching URL handles the request and other request handlers are not attempted.
        Structure is documented below.
        """
        return pulumi.get(self, "handlers")

    @handlers.setter
    def handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlexibleAppVersionHandlerArgs']]]]):
        pulumi.set(self, "handlers", value)

    @property
    @pulumi.getter(name="inboundServices")
    def inbound_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the types of messages that this application is able to receive.
        Each value may be one of: `INBOUND_SERVICE_MAIL`, `INBOUND_SERVICE_MAIL_BOUNCE`, `INBOUND_SERVICE_XMPP_ERROR`, `INBOUND_SERVICE_XMPP_MESSAGE`, `INBOUND_SERVICE_XMPP_SUBSCRIBE`, `INBOUND_SERVICE_XMPP_PRESENCE`, `INBOUND_SERVICE_CHANNEL_PRESENCE`, `INBOUND_SERVICE_WARMUP`.
        """
        return pulumi.get(self, "inbound_services")

    @inbound_services.setter
    def inbound_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inbound_services", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        Instance class that is used to run this version. Valid values are
        AutomaticScaling: F1, F2, F4, F4_1G
        ManualScaling: B1, B2, B4, B8, B4_1G
        Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="manualScaling")
    def manual_scaling(self) -> Optional[pulumi.Input['FlexibleAppVersionManualScalingArgs']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "manual_scaling")

    @manual_scaling.setter
    def manual_scaling(self, value: Optional[pulumi.Input['FlexibleAppVersionManualScalingArgs']]):
        pulumi.set(self, "manual_scaling", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['FlexibleAppVersionNetworkArgs']]:
        """
        Extra network settings
        Structure is documented below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['FlexibleAppVersionNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="nobuildFilesRegex")
    def nobuild_files_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        """
        return pulumi.get(self, "nobuild_files_regex")

    @nobuild_files_regex.setter
    def nobuild_files_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nobuild_files_regex", value)

    @property
    @pulumi.getter(name="noopOnDestroy")
    def noop_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the application version will not be deleted.
        """
        return pulumi.get(self, "noop_on_destroy")

    @noop_on_destroy.setter
    def noop_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "noop_on_destroy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['FlexibleAppVersionResourcesArgs']]:
        """
        Machine resources for a version.
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['FlexibleAppVersionResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="runtimeApiVersion")
    def runtime_api_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the API in the given runtime environment.
        Please see the app.yaml reference for valid values at `https://cloud.google.com/appengine/docs/standard/<language>/config/appref`\\
        Substitute `<language>` with `python`, `java`, `php`, `ruby`, `go` or `nodejs`.
        """
        return pulumi.get(self, "runtime_api_version")

    @runtime_api_version.setter
    def runtime_api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_api_version", value)

    @property
    @pulumi.getter(name="runtimeChannel")
    def runtime_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The channel of the runtime to use. Only available for some runtimes.
        """
        return pulumi.get(self, "runtime_channel")

    @runtime_channel.setter
    def runtime_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_channel", value)

    @property
    @pulumi.getter(name="runtimeMainExecutablePath")
    def runtime_main_executable_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path or name of the app's main executable.
        """
        return pulumi.get(self, "runtime_main_executable_path")

    @runtime_main_executable_path.setter
    def runtime_main_executable_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_main_executable_path", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
        default if this field is neither provided in app.yaml file nor through CLI flag.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="servingStatus")
    def serving_status(self) -> Optional[pulumi.Input[str]]:
        """
        Current serving status of this version. Only the versions with a SERVING status create instances and can be billed.
        Default value is `SERVING`.
        Possible values are: `SERVING`, `STOPPED`.
        """
        return pulumi.get(self, "serving_status")

    @serving_status.setter
    def serving_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serving_status", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Relative name of the version within the service. For example, `v1`. Version names can contain only lowercase letters, numbers, or hyphens.
        Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="vpcAccessConnector")
    def vpc_access_connector(self) -> Optional[pulumi.Input['FlexibleAppVersionVpcAccessConnectorArgs']]:
        """
        Enables VPC connectivity for standard apps.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access_connector")

    @vpc_access_connector.setter
    def vpc_access_connector(self, value: Optional[pulumi.Input['FlexibleAppVersionVpcAccessConnectorArgs']]):
        pulumi.set(self, "vpc_access_connector", value)


@pulumi.input_type
class _FlexibleAppVersionState:
    def __init__(__self__, *,
                 api_config: Optional[pulumi.Input['FlexibleAppVersionApiConfigArgs']] = None,
                 automatic_scaling: Optional[pulumi.Input['FlexibleAppVersionAutomaticScalingArgs']] = None,
                 beta_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 default_expiration: Optional[pulumi.Input[str]] = None,
                 delete_service_on_destroy: Optional[pulumi.Input[bool]] = None,
                 deployment: Optional[pulumi.Input['FlexibleAppVersionDeploymentArgs']] = None,
                 endpoints_api_service: Optional[pulumi.Input['FlexibleAppVersionEndpointsApiServiceArgs']] = None,
                 entrypoint: Optional[pulumi.Input['FlexibleAppVersionEntrypointArgs']] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input['FlexibleAppVersionHandlerArgs']]]] = None,
                 inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 liveness_check: Optional[pulumi.Input['FlexibleAppVersionLivenessCheckArgs']] = None,
                 manual_scaling: Optional[pulumi.Input['FlexibleAppVersionManualScalingArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input['FlexibleAppVersionNetworkArgs']] = None,
                 nobuild_files_regex: Optional[pulumi.Input[str]] = None,
                 noop_on_destroy: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 readiness_check: Optional[pulumi.Input['FlexibleAppVersionReadinessCheckArgs']] = None,
                 resources: Optional[pulumi.Input['FlexibleAppVersionResourcesArgs']] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 runtime_api_version: Optional[pulumi.Input[str]] = None,
                 runtime_channel: Optional[pulumi.Input[str]] = None,
                 runtime_main_executable_path: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 serving_status: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 vpc_access_connector: Optional[pulumi.Input['FlexibleAppVersionVpcAccessConnectorArgs']] = None):
        """
        Input properties used for looking up and filtering FlexibleAppVersion resources.
        :param pulumi.Input['FlexibleAppVersionApiConfigArgs'] api_config: Serving configuration for Google Cloud Endpoints.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionAutomaticScalingArgs'] automatic_scaling: Automatic scaling is based on request rate, response latencies, and other application metrics.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] beta_settings: Metadata settings that are supplied to this version to enable beta runtime features.
        :param pulumi.Input[str] default_expiration: Duration that static files should be cached by web proxies and browsers.
               Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        :param pulumi.Input[bool] delete_service_on_destroy: If set to `true`, the service will be deleted if it is the last version.
        :param pulumi.Input['FlexibleAppVersionDeploymentArgs'] deployment: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionEndpointsApiServiceArgs'] endpoints_api_service: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionEntrypointArgs'] entrypoint: The entrypoint for the application.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_variables: Environment variables available to the application.  As these are not returned in the API request, the provider will not detect any changes made outside of the config.
        :param pulumi.Input[Sequence[pulumi.Input['FlexibleAppVersionHandlerArgs']]] handlers: An ordered list of URL-matching patterns that should be applied to incoming requests.
               The first matching URL handles the request and other request handlers are not attempted.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_services: A list of the types of messages that this application is able to receive.
               Each value may be one of: `INBOUND_SERVICE_MAIL`, `INBOUND_SERVICE_MAIL_BOUNCE`, `INBOUND_SERVICE_XMPP_ERROR`, `INBOUND_SERVICE_XMPP_MESSAGE`, `INBOUND_SERVICE_XMPP_SUBSCRIBE`, `INBOUND_SERVICE_XMPP_PRESENCE`, `INBOUND_SERVICE_CHANNEL_PRESENCE`, `INBOUND_SERVICE_WARMUP`.
        :param pulumi.Input[str] instance_class: Instance class that is used to run this version. Valid values are
               AutomaticScaling: F1, F2, F4, F4_1G
               ManualScaling: B1, B2, B4, B8, B4_1G
               Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        :param pulumi.Input['FlexibleAppVersionLivenessCheckArgs'] liveness_check: Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionManualScalingArgs'] manual_scaling: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[str] name: Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
               
               (Required)
               Unique name for the volume.
               
               
               (Required)
               Endpoints service name which is the name of the "service" resource in the Service Management API.
               For example "myapi.endpoints.myproject.cloud.goog"
               
               (Required)
               Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        :param pulumi.Input['FlexibleAppVersionNetworkArgs'] network: Extra network settings
               Structure is documented below.
        :param pulumi.Input[str] nobuild_files_regex: Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        :param pulumi.Input[bool] noop_on_destroy: If set to `true`, the application version will not be deleted.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['FlexibleAppVersionReadinessCheckArgs'] readiness_check: Configures readiness health checking for instances. Unhealthy instances are not put into the backend traffic rotation.
               Structure is documented below.
        :param pulumi.Input['FlexibleAppVersionResourcesArgs'] resources: Machine resources for a version.
               Structure is documented below.
        :param pulumi.Input[str] runtime: Desired runtime. Example python27.
        :param pulumi.Input[str] runtime_api_version: The version of the API in the given runtime environment.
               Please see the app.yaml reference for valid values at `https://cloud.google.com/appengine/docs/standard/<language>/config/appref`\\
               Substitute `<language>` with `python`, `java`, `php`, `ruby`, `go` or `nodejs`.
        :param pulumi.Input[str] runtime_channel: The channel of the runtime to use. Only available for some runtimes.
        :param pulumi.Input[str] runtime_main_executable_path: The path or name of the app's main executable.
        :param pulumi.Input[str] service: AppEngine service resource. Can contain numbers, letters, and hyphens.
        :param pulumi.Input[str] service_account: The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
               default if this field is neither provided in app.yaml file nor through CLI flag.
        :param pulumi.Input[str] serving_status: Current serving status of this version. Only the versions with a SERVING status create instances and can be billed.
               Default value is `SERVING`.
               Possible values are: `SERVING`, `STOPPED`.
        :param pulumi.Input[str] version_id: Relative name of the version within the service. For example, `v1`. Version names can contain only lowercase letters, numbers, or hyphens.
               Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param pulumi.Input['FlexibleAppVersionVpcAccessConnectorArgs'] vpc_access_connector: Enables VPC connectivity for standard apps.
               Structure is documented below.
        """
        if api_config is not None:
            pulumi.set(__self__, "api_config", api_config)
        if automatic_scaling is not None:
            pulumi.set(__self__, "automatic_scaling", automatic_scaling)
        if beta_settings is not None:
            pulumi.set(__self__, "beta_settings", beta_settings)
        if default_expiration is not None:
            pulumi.set(__self__, "default_expiration", default_expiration)
        if delete_service_on_destroy is not None:
            pulumi.set(__self__, "delete_service_on_destroy", delete_service_on_destroy)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if endpoints_api_service is not None:
            pulumi.set(__self__, "endpoints_api_service", endpoints_api_service)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if handlers is not None:
            pulumi.set(__self__, "handlers", handlers)
        if inbound_services is not None:
            pulumi.set(__self__, "inbound_services", inbound_services)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if liveness_check is not None:
            pulumi.set(__self__, "liveness_check", liveness_check)
        if manual_scaling is not None:
            pulumi.set(__self__, "manual_scaling", manual_scaling)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if nobuild_files_regex is not None:
            pulumi.set(__self__, "nobuild_files_regex", nobuild_files_regex)
        if noop_on_destroy is not None:
            pulumi.set(__self__, "noop_on_destroy", noop_on_destroy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if readiness_check is not None:
            pulumi.set(__self__, "readiness_check", readiness_check)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if runtime_api_version is not None:
            pulumi.set(__self__, "runtime_api_version", runtime_api_version)
        if runtime_channel is not None:
            pulumi.set(__self__, "runtime_channel", runtime_channel)
        if runtime_main_executable_path is not None:
            pulumi.set(__self__, "runtime_main_executable_path", runtime_main_executable_path)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if serving_status is not None:
            pulumi.set(__self__, "serving_status", serving_status)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if vpc_access_connector is not None:
            pulumi.set(__self__, "vpc_access_connector", vpc_access_connector)

    @property
    @pulumi.getter(name="apiConfig")
    def api_config(self) -> Optional[pulumi.Input['FlexibleAppVersionApiConfigArgs']]:
        """
        Serving configuration for Google Cloud Endpoints.
        Structure is documented below.
        """
        return pulumi.get(self, "api_config")

    @api_config.setter
    def api_config(self, value: Optional[pulumi.Input['FlexibleAppVersionApiConfigArgs']]):
        pulumi.set(self, "api_config", value)

    @property
    @pulumi.getter(name="automaticScaling")
    def automatic_scaling(self) -> Optional[pulumi.Input['FlexibleAppVersionAutomaticScalingArgs']]:
        """
        Automatic scaling is based on request rate, response latencies, and other application metrics.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_scaling")

    @automatic_scaling.setter
    def automatic_scaling(self, value: Optional[pulumi.Input['FlexibleAppVersionAutomaticScalingArgs']]):
        pulumi.set(self, "automatic_scaling", value)

    @property
    @pulumi.getter(name="betaSettings")
    def beta_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata settings that are supplied to this version to enable beta runtime features.
        """
        return pulumi.get(self, "beta_settings")

    @beta_settings.setter
    def beta_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "beta_settings", value)

    @property
    @pulumi.getter(name="defaultExpiration")
    def default_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        Duration that static files should be cached by web proxies and browsers.
        Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        """
        return pulumi.get(self, "default_expiration")

    @default_expiration.setter
    def default_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_expiration", value)

    @property
    @pulumi.getter(name="deleteServiceOnDestroy")
    def delete_service_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the service will be deleted if it is the last version.
        """
        return pulumi.get(self, "delete_service_on_destroy")

    @delete_service_on_destroy.setter
    def delete_service_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_service_on_destroy", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['FlexibleAppVersionDeploymentArgs']]:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['FlexibleAppVersionDeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter(name="endpointsApiService")
    def endpoints_api_service(self) -> Optional[pulumi.Input['FlexibleAppVersionEndpointsApiServiceArgs']]:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints_api_service")

    @endpoints_api_service.setter
    def endpoints_api_service(self, value: Optional[pulumi.Input['FlexibleAppVersionEndpointsApiServiceArgs']]):
        pulumi.set(self, "endpoints_api_service", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input['FlexibleAppVersionEntrypointArgs']]:
        """
        The entrypoint for the application.
        Structure is documented below.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input['FlexibleAppVersionEntrypointArgs']]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables available to the application.  As these are not returned in the API request, the provider will not detect any changes made outside of the config.
        """
        return pulumi.get(self, "env_variables")

    @env_variables.setter
    def env_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env_variables", value)

    @property
    @pulumi.getter
    def handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlexibleAppVersionHandlerArgs']]]]:
        """
        An ordered list of URL-matching patterns that should be applied to incoming requests.
        The first matching URL handles the request and other request handlers are not attempted.
        Structure is documented below.
        """
        return pulumi.get(self, "handlers")

    @handlers.setter
    def handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlexibleAppVersionHandlerArgs']]]]):
        pulumi.set(self, "handlers", value)

    @property
    @pulumi.getter(name="inboundServices")
    def inbound_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the types of messages that this application is able to receive.
        Each value may be one of: `INBOUND_SERVICE_MAIL`, `INBOUND_SERVICE_MAIL_BOUNCE`, `INBOUND_SERVICE_XMPP_ERROR`, `INBOUND_SERVICE_XMPP_MESSAGE`, `INBOUND_SERVICE_XMPP_SUBSCRIBE`, `INBOUND_SERVICE_XMPP_PRESENCE`, `INBOUND_SERVICE_CHANNEL_PRESENCE`, `INBOUND_SERVICE_WARMUP`.
        """
        return pulumi.get(self, "inbound_services")

    @inbound_services.setter
    def inbound_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inbound_services", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        Instance class that is used to run this version. Valid values are
        AutomaticScaling: F1, F2, F4, F4_1G
        ManualScaling: B1, B2, B4, B8, B4_1G
        Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="livenessCheck")
    def liveness_check(self) -> Optional[pulumi.Input['FlexibleAppVersionLivenessCheckArgs']]:
        """
        Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_check")

    @liveness_check.setter
    def liveness_check(self, value: Optional[pulumi.Input['FlexibleAppVersionLivenessCheckArgs']]):
        pulumi.set(self, "liveness_check", value)

    @property
    @pulumi.getter(name="manualScaling")
    def manual_scaling(self) -> Optional[pulumi.Input['FlexibleAppVersionManualScalingArgs']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "manual_scaling")

    @manual_scaling.setter
    def manual_scaling(self, value: Optional[pulumi.Input['FlexibleAppVersionManualScalingArgs']]):
        pulumi.set(self, "manual_scaling", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.

        (Required)
        Unique name for the volume.


        (Required)
        Endpoints service name which is the name of the "service" resource in the Service Management API.
        For example "myapi.endpoints.myproject.cloud.goog"

        (Required)
        Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['FlexibleAppVersionNetworkArgs']]:
        """
        Extra network settings
        Structure is documented below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['FlexibleAppVersionNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="nobuildFilesRegex")
    def nobuild_files_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        """
        return pulumi.get(self, "nobuild_files_regex")

    @nobuild_files_regex.setter
    def nobuild_files_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nobuild_files_regex", value)

    @property
    @pulumi.getter(name="noopOnDestroy")
    def noop_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the application version will not be deleted.
        """
        return pulumi.get(self, "noop_on_destroy")

    @noop_on_destroy.setter
    def noop_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "noop_on_destroy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="readinessCheck")
    def readiness_check(self) -> Optional[pulumi.Input['FlexibleAppVersionReadinessCheckArgs']]:
        """
        Configures readiness health checking for instances. Unhealthy instances are not put into the backend traffic rotation.
        Structure is documented below.
        """
        return pulumi.get(self, "readiness_check")

    @readiness_check.setter
    def readiness_check(self, value: Optional[pulumi.Input['FlexibleAppVersionReadinessCheckArgs']]):
        pulumi.set(self, "readiness_check", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['FlexibleAppVersionResourcesArgs']]:
        """
        Machine resources for a version.
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['FlexibleAppVersionResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Desired runtime. Example python27.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="runtimeApiVersion")
    def runtime_api_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the API in the given runtime environment.
        Please see the app.yaml reference for valid values at `https://cloud.google.com/appengine/docs/standard/<language>/config/appref`\\
        Substitute `<language>` with `python`, `java`, `php`, `ruby`, `go` or `nodejs`.
        """
        return pulumi.get(self, "runtime_api_version")

    @runtime_api_version.setter
    def runtime_api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_api_version", value)

    @property
    @pulumi.getter(name="runtimeChannel")
    def runtime_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The channel of the runtime to use. Only available for some runtimes.
        """
        return pulumi.get(self, "runtime_channel")

    @runtime_channel.setter
    def runtime_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_channel", value)

    @property
    @pulumi.getter(name="runtimeMainExecutablePath")
    def runtime_main_executable_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path or name of the app's main executable.
        """
        return pulumi.get(self, "runtime_main_executable_path")

    @runtime_main_executable_path.setter
    def runtime_main_executable_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_main_executable_path", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        AppEngine service resource. Can contain numbers, letters, and hyphens.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
        default if this field is neither provided in app.yaml file nor through CLI flag.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="servingStatus")
    def serving_status(self) -> Optional[pulumi.Input[str]]:
        """
        Current serving status of this version. Only the versions with a SERVING status create instances and can be billed.
        Default value is `SERVING`.
        Possible values are: `SERVING`, `STOPPED`.
        """
        return pulumi.get(self, "serving_status")

    @serving_status.setter
    def serving_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serving_status", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Relative name of the version within the service. For example, `v1`. Version names can contain only lowercase letters, numbers, or hyphens.
        Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="vpcAccessConnector")
    def vpc_access_connector(self) -> Optional[pulumi.Input['FlexibleAppVersionVpcAccessConnectorArgs']]:
        """
        Enables VPC connectivity for standard apps.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access_connector")

    @vpc_access_connector.setter
    def vpc_access_connector(self, value: Optional[pulumi.Input['FlexibleAppVersionVpcAccessConnectorArgs']]):
        pulumi.set(self, "vpc_access_connector", value)


class FlexibleAppVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_config: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionApiConfigArgs']]] = None,
                 automatic_scaling: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionAutomaticScalingArgs']]] = None,
                 beta_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 default_expiration: Optional[pulumi.Input[str]] = None,
                 delete_service_on_destroy: Optional[pulumi.Input[bool]] = None,
                 deployment: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionDeploymentArgs']]] = None,
                 endpoints_api_service: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionEndpointsApiServiceArgs']]] = None,
                 entrypoint: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionEntrypointArgs']]] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FlexibleAppVersionHandlerArgs']]]]] = None,
                 inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 liveness_check: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionLivenessCheckArgs']]] = None,
                 manual_scaling: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionManualScalingArgs']]] = None,
                 network: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionNetworkArgs']]] = None,
                 nobuild_files_regex: Optional[pulumi.Input[str]] = None,
                 noop_on_destroy: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 readiness_check: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionReadinessCheckArgs']]] = None,
                 resources: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionResourcesArgs']]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 runtime_api_version: Optional[pulumi.Input[str]] = None,
                 runtime_channel: Optional[pulumi.Input[str]] = None,
                 runtime_main_executable_path: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 serving_status: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 vpc_access_connector: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionVpcAccessConnectorArgs']]] = None,
                 __props__=None):
        """
        Flexible App Version resource to create a new version of flexible GAE Application. Based on Google Compute Engine,
        the App Engine flexible environment automatically scales your app up and down while also balancing the load.
        Learn about the differences between the standard environment and the flexible environment
        at https://cloud.google.com/appengine/docs/the-appengine-environments.

        > **Note:** The App Engine flexible environment service account uses the member ID `service-[YOUR_PROJECT_NUMBER]@gae-api-prod.google.com.iam.gserviceaccount.com`
        It should have the App Engine Flexible Environment Service Agent role, which will be applied when the `appengineflex.googleapis.com` service is enabled.

        To get more information about FlexibleAppVersion, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/appengine/docs/flexible)

        ## Example Usage
        ### App Engine Flexible App Version

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.organizations.Project("myProject",
            project_id="appeng-flex",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        app = gcp.appengine.Application("app",
            project=my_project.project_id,
            location_id="us-central")
        service = gcp.projects.Service("service",
            project=my_project.project_id,
            service="appengineflex.googleapis.com",
            disable_dependent_services=False)
        custom_service_account = gcp.service_account.Account("customServiceAccount",
            project=service.project,
            account_id="my-account",
            display_name="Custom Service Account")
        gae_api = gcp.projects.IAMMember("gaeApi",
            project=service.project,
            role="roles/compute.networkUser",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        logs_writer = gcp.projects.IAMMember("logsWriter",
            project=service.project,
            role="roles/logging.logWriter",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        storage_viewer = gcp.projects.IAMMember("storageViewer",
            project=service.project,
            role="roles/storage.objectViewer",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        bucket = gcp.storage.Bucket("bucket",
            project=my_project.project_id,
            location="US")
        object = gcp.storage.BucketObject("object",
            bucket=bucket.name,
            source=pulumi.FileAsset("./test-fixtures/appengine/hello-world.zip"))
        myapp_v1 = gcp.appengine.FlexibleAppVersion("myappV1",
            version_id="v1",
            project=gae_api.project,
            service="default",
            runtime="nodejs",
            entrypoint=gcp.appengine.FlexibleAppVersionEntrypointArgs(
                shell="node ./app.js",
            ),
            deployment=gcp.appengine.FlexibleAppVersionDeploymentArgs(
                zip=gcp.appengine.FlexibleAppVersionDeploymentZipArgs(
                    source_url=pulumi.Output.all(bucket.name, object.name).apply(lambda bucketName, objectName: f"https://storage.googleapis.com/{bucket_name}/{object_name}"),
                ),
            ),
            liveness_check=gcp.appengine.FlexibleAppVersionLivenessCheckArgs(
                path="/",
            ),
            readiness_check=gcp.appengine.FlexibleAppVersionReadinessCheckArgs(
                path="/",
            ),
            env_variables={
                "port": "8080",
            },
            handlers=[gcp.appengine.FlexibleAppVersionHandlerArgs(
                url_regex=".*\\\\/my-path\\\\/*",
                security_level="SECURE_ALWAYS",
                login="LOGIN_REQUIRED",
                auth_fail_action="AUTH_FAIL_ACTION_REDIRECT",
                static_files=gcp.appengine.FlexibleAppVersionHandlerStaticFilesArgs(
                    path="my-other-path",
                    upload_path_regex=".*\\\\/my-path\\\\/*",
                ),
            )],
            automatic_scaling=gcp.appengine.FlexibleAppVersionAutomaticScalingArgs(
                cool_down_period="120s",
                cpu_utilization=gcp.appengine.FlexibleAppVersionAutomaticScalingCpuUtilizationArgs(
                    target_utilization=0.5,
                ),
            ),
            noop_on_destroy=True,
            service_account=custom_service_account.email)
        ```

        ## Import

        FlexibleAppVersion can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:appengine/flexibleAppVersion:FlexibleAppVersion default apps/{{project}}/services/{{service}}/versions/{{version_id}}
        ```

        ```sh
         $ pulumi import gcp:appengine/flexibleAppVersion:FlexibleAppVersion default {{project}}/{{service}}/{{version_id}}
        ```

        ```sh
         $ pulumi import gcp:appengine/flexibleAppVersion:FlexibleAppVersion default {{service}}/{{version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionApiConfigArgs']] api_config: Serving configuration for Google Cloud Endpoints.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionAutomaticScalingArgs']] automatic_scaling: Automatic scaling is based on request rate, response latencies, and other application metrics.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] beta_settings: Metadata settings that are supplied to this version to enable beta runtime features.
        :param pulumi.Input[str] default_expiration: Duration that static files should be cached by web proxies and browsers.
               Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        :param pulumi.Input[bool] delete_service_on_destroy: If set to `true`, the service will be deleted if it is the last version.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionDeploymentArgs']] deployment: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionEndpointsApiServiceArgs']] endpoints_api_service: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionEntrypointArgs']] entrypoint: The entrypoint for the application.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_variables: Environment variables available to the application.  As these are not returned in the API request, the provider will not detect any changes made outside of the config.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FlexibleAppVersionHandlerArgs']]]] handlers: An ordered list of URL-matching patterns that should be applied to incoming requests.
               The first matching URL handles the request and other request handlers are not attempted.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_services: A list of the types of messages that this application is able to receive.
               Each value may be one of: `INBOUND_SERVICE_MAIL`, `INBOUND_SERVICE_MAIL_BOUNCE`, `INBOUND_SERVICE_XMPP_ERROR`, `INBOUND_SERVICE_XMPP_MESSAGE`, `INBOUND_SERVICE_XMPP_SUBSCRIBE`, `INBOUND_SERVICE_XMPP_PRESENCE`, `INBOUND_SERVICE_CHANNEL_PRESENCE`, `INBOUND_SERVICE_WARMUP`.
        :param pulumi.Input[str] instance_class: Instance class that is used to run this version. Valid values are
               AutomaticScaling: F1, F2, F4, F4_1G
               ManualScaling: B1, B2, B4, B8, B4_1G
               Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionLivenessCheckArgs']] liveness_check: Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionManualScalingArgs']] manual_scaling: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionNetworkArgs']] network: Extra network settings
               Structure is documented below.
        :param pulumi.Input[str] nobuild_files_regex: Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        :param pulumi.Input[bool] noop_on_destroy: If set to `true`, the application version will not be deleted.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionReadinessCheckArgs']] readiness_check: Configures readiness health checking for instances. Unhealthy instances are not put into the backend traffic rotation.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionResourcesArgs']] resources: Machine resources for a version.
               Structure is documented below.
        :param pulumi.Input[str] runtime: Desired runtime. Example python27.
        :param pulumi.Input[str] runtime_api_version: The version of the API in the given runtime environment.
               Please see the app.yaml reference for valid values at `https://cloud.google.com/appengine/docs/standard/<language>/config/appref`\\
               Substitute `<language>` with `python`, `java`, `php`, `ruby`, `go` or `nodejs`.
        :param pulumi.Input[str] runtime_channel: The channel of the runtime to use. Only available for some runtimes.
        :param pulumi.Input[str] runtime_main_executable_path: The path or name of the app's main executable.
        :param pulumi.Input[str] service: AppEngine service resource. Can contain numbers, letters, and hyphens.
        :param pulumi.Input[str] service_account: The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
               default if this field is neither provided in app.yaml file nor through CLI flag.
        :param pulumi.Input[str] serving_status: Current serving status of this version. Only the versions with a SERVING status create instances and can be billed.
               Default value is `SERVING`.
               Possible values are: `SERVING`, `STOPPED`.
        :param pulumi.Input[str] version_id: Relative name of the version within the service. For example, `v1`. Version names can contain only lowercase letters, numbers, or hyphens.
               Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionVpcAccessConnectorArgs']] vpc_access_connector: Enables VPC connectivity for standard apps.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlexibleAppVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Flexible App Version resource to create a new version of flexible GAE Application. Based on Google Compute Engine,
        the App Engine flexible environment automatically scales your app up and down while also balancing the load.
        Learn about the differences between the standard environment and the flexible environment
        at https://cloud.google.com/appengine/docs/the-appengine-environments.

        > **Note:** The App Engine flexible environment service account uses the member ID `service-[YOUR_PROJECT_NUMBER]@gae-api-prod.google.com.iam.gserviceaccount.com`
        It should have the App Engine Flexible Environment Service Agent role, which will be applied when the `appengineflex.googleapis.com` service is enabled.

        To get more information about FlexibleAppVersion, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/appengine/docs/flexible)

        ## Example Usage
        ### App Engine Flexible App Version

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.organizations.Project("myProject",
            project_id="appeng-flex",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        app = gcp.appengine.Application("app",
            project=my_project.project_id,
            location_id="us-central")
        service = gcp.projects.Service("service",
            project=my_project.project_id,
            service="appengineflex.googleapis.com",
            disable_dependent_services=False)
        custom_service_account = gcp.service_account.Account("customServiceAccount",
            project=service.project,
            account_id="my-account",
            display_name="Custom Service Account")
        gae_api = gcp.projects.IAMMember("gaeApi",
            project=service.project,
            role="roles/compute.networkUser",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        logs_writer = gcp.projects.IAMMember("logsWriter",
            project=service.project,
            role="roles/logging.logWriter",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        storage_viewer = gcp.projects.IAMMember("storageViewer",
            project=service.project,
            role="roles/storage.objectViewer",
            member=custom_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        bucket = gcp.storage.Bucket("bucket",
            project=my_project.project_id,
            location="US")
        object = gcp.storage.BucketObject("object",
            bucket=bucket.name,
            source=pulumi.FileAsset("./test-fixtures/appengine/hello-world.zip"))
        myapp_v1 = gcp.appengine.FlexibleAppVersion("myappV1",
            version_id="v1",
            project=gae_api.project,
            service="default",
            runtime="nodejs",
            entrypoint=gcp.appengine.FlexibleAppVersionEntrypointArgs(
                shell="node ./app.js",
            ),
            deployment=gcp.appengine.FlexibleAppVersionDeploymentArgs(
                zip=gcp.appengine.FlexibleAppVersionDeploymentZipArgs(
                    source_url=pulumi.Output.all(bucket.name, object.name).apply(lambda bucketName, objectName: f"https://storage.googleapis.com/{bucket_name}/{object_name}"),
                ),
            ),
            liveness_check=gcp.appengine.FlexibleAppVersionLivenessCheckArgs(
                path="/",
            ),
            readiness_check=gcp.appengine.FlexibleAppVersionReadinessCheckArgs(
                path="/",
            ),
            env_variables={
                "port": "8080",
            },
            handlers=[gcp.appengine.FlexibleAppVersionHandlerArgs(
                url_regex=".*\\\\/my-path\\\\/*",
                security_level="SECURE_ALWAYS",
                login="LOGIN_REQUIRED",
                auth_fail_action="AUTH_FAIL_ACTION_REDIRECT",
                static_files=gcp.appengine.FlexibleAppVersionHandlerStaticFilesArgs(
                    path="my-other-path",
                    upload_path_regex=".*\\\\/my-path\\\\/*",
                ),
            )],
            automatic_scaling=gcp.appengine.FlexibleAppVersionAutomaticScalingArgs(
                cool_down_period="120s",
                cpu_utilization=gcp.appengine.FlexibleAppVersionAutomaticScalingCpuUtilizationArgs(
                    target_utilization=0.5,
                ),
            ),
            noop_on_destroy=True,
            service_account=custom_service_account.email)
        ```

        ## Import

        FlexibleAppVersion can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:appengine/flexibleAppVersion:FlexibleAppVersion default apps/{{project}}/services/{{service}}/versions/{{version_id}}
        ```

        ```sh
         $ pulumi import gcp:appengine/flexibleAppVersion:FlexibleAppVersion default {{project}}/{{service}}/{{version_id}}
        ```

        ```sh
         $ pulumi import gcp:appengine/flexibleAppVersion:FlexibleAppVersion default {{service}}/{{version_id}}
        ```

        :param str resource_name: The name of the resource.
        :param FlexibleAppVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlexibleAppVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_config: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionApiConfigArgs']]] = None,
                 automatic_scaling: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionAutomaticScalingArgs']]] = None,
                 beta_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 default_expiration: Optional[pulumi.Input[str]] = None,
                 delete_service_on_destroy: Optional[pulumi.Input[bool]] = None,
                 deployment: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionDeploymentArgs']]] = None,
                 endpoints_api_service: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionEndpointsApiServiceArgs']]] = None,
                 entrypoint: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionEntrypointArgs']]] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FlexibleAppVersionHandlerArgs']]]]] = None,
                 inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 liveness_check: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionLivenessCheckArgs']]] = None,
                 manual_scaling: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionManualScalingArgs']]] = None,
                 network: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionNetworkArgs']]] = None,
                 nobuild_files_regex: Optional[pulumi.Input[str]] = None,
                 noop_on_destroy: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 readiness_check: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionReadinessCheckArgs']]] = None,
                 resources: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionResourcesArgs']]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 runtime_api_version: Optional[pulumi.Input[str]] = None,
                 runtime_channel: Optional[pulumi.Input[str]] = None,
                 runtime_main_executable_path: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 serving_status: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 vpc_access_connector: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionVpcAccessConnectorArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlexibleAppVersionArgs.__new__(FlexibleAppVersionArgs)

            __props__.__dict__["api_config"] = api_config
            __props__.__dict__["automatic_scaling"] = automatic_scaling
            __props__.__dict__["beta_settings"] = beta_settings
            __props__.__dict__["default_expiration"] = default_expiration
            __props__.__dict__["delete_service_on_destroy"] = delete_service_on_destroy
            __props__.__dict__["deployment"] = deployment
            __props__.__dict__["endpoints_api_service"] = endpoints_api_service
            __props__.__dict__["entrypoint"] = entrypoint
            __props__.__dict__["env_variables"] = env_variables
            __props__.__dict__["handlers"] = handlers
            __props__.__dict__["inbound_services"] = inbound_services
            __props__.__dict__["instance_class"] = instance_class
            if liveness_check is None and not opts.urn:
                raise TypeError("Missing required property 'liveness_check'")
            __props__.__dict__["liveness_check"] = liveness_check
            __props__.__dict__["manual_scaling"] = manual_scaling
            __props__.__dict__["network"] = network
            __props__.__dict__["nobuild_files_regex"] = nobuild_files_regex
            __props__.__dict__["noop_on_destroy"] = noop_on_destroy
            __props__.__dict__["project"] = project
            if readiness_check is None and not opts.urn:
                raise TypeError("Missing required property 'readiness_check'")
            __props__.__dict__["readiness_check"] = readiness_check
            __props__.__dict__["resources"] = resources
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["runtime_api_version"] = runtime_api_version
            __props__.__dict__["runtime_channel"] = runtime_channel
            __props__.__dict__["runtime_main_executable_path"] = runtime_main_executable_path
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["serving_status"] = serving_status
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["vpc_access_connector"] = vpc_access_connector
            __props__.__dict__["name"] = None
        super(FlexibleAppVersion, __self__).__init__(
            'gcp:appengine/flexibleAppVersion:FlexibleAppVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_config: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionApiConfigArgs']]] = None,
            automatic_scaling: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionAutomaticScalingArgs']]] = None,
            beta_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            default_expiration: Optional[pulumi.Input[str]] = None,
            delete_service_on_destroy: Optional[pulumi.Input[bool]] = None,
            deployment: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionDeploymentArgs']]] = None,
            endpoints_api_service: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionEndpointsApiServiceArgs']]] = None,
            entrypoint: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionEntrypointArgs']]] = None,
            env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            handlers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FlexibleAppVersionHandlerArgs']]]]] = None,
            inbound_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            instance_class: Optional[pulumi.Input[str]] = None,
            liveness_check: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionLivenessCheckArgs']]] = None,
            manual_scaling: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionManualScalingArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionNetworkArgs']]] = None,
            nobuild_files_regex: Optional[pulumi.Input[str]] = None,
            noop_on_destroy: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            readiness_check: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionReadinessCheckArgs']]] = None,
            resources: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionResourcesArgs']]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            runtime_api_version: Optional[pulumi.Input[str]] = None,
            runtime_channel: Optional[pulumi.Input[str]] = None,
            runtime_main_executable_path: Optional[pulumi.Input[str]] = None,
            service: Optional[pulumi.Input[str]] = None,
            service_account: Optional[pulumi.Input[str]] = None,
            serving_status: Optional[pulumi.Input[str]] = None,
            version_id: Optional[pulumi.Input[str]] = None,
            vpc_access_connector: Optional[pulumi.Input[pulumi.InputType['FlexibleAppVersionVpcAccessConnectorArgs']]] = None) -> 'FlexibleAppVersion':
        """
        Get an existing FlexibleAppVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionApiConfigArgs']] api_config: Serving configuration for Google Cloud Endpoints.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionAutomaticScalingArgs']] automatic_scaling: Automatic scaling is based on request rate, response latencies, and other application metrics.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] beta_settings: Metadata settings that are supplied to this version to enable beta runtime features.
        :param pulumi.Input[str] default_expiration: Duration that static files should be cached by web proxies and browsers.
               Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        :param pulumi.Input[bool] delete_service_on_destroy: If set to `true`, the service will be deleted if it is the last version.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionDeploymentArgs']] deployment: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionEndpointsApiServiceArgs']] endpoints_api_service: Code and application artifacts that make up this version.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionEntrypointArgs']] entrypoint: The entrypoint for the application.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_variables: Environment variables available to the application.  As these are not returned in the API request, the provider will not detect any changes made outside of the config.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FlexibleAppVersionHandlerArgs']]]] handlers: An ordered list of URL-matching patterns that should be applied to incoming requests.
               The first matching URL handles the request and other request handlers are not attempted.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_services: A list of the types of messages that this application is able to receive.
               Each value may be one of: `INBOUND_SERVICE_MAIL`, `INBOUND_SERVICE_MAIL_BOUNCE`, `INBOUND_SERVICE_XMPP_ERROR`, `INBOUND_SERVICE_XMPP_MESSAGE`, `INBOUND_SERVICE_XMPP_SUBSCRIBE`, `INBOUND_SERVICE_XMPP_PRESENCE`, `INBOUND_SERVICE_CHANNEL_PRESENCE`, `INBOUND_SERVICE_WARMUP`.
        :param pulumi.Input[str] instance_class: Instance class that is used to run this version. Valid values are
               AutomaticScaling: F1, F2, F4, F4_1G
               ManualScaling: B1, B2, B4, B8, B4_1G
               Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionLivenessCheckArgs']] liveness_check: Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionManualScalingArgs']] manual_scaling: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[str] name: Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
               
               (Required)
               Unique name for the volume.
               
               
               (Required)
               Endpoints service name which is the name of the "service" resource in the Service Management API.
               For example "myapi.endpoints.myproject.cloud.goog"
               
               (Required)
               Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionNetworkArgs']] network: Extra network settings
               Structure is documented below.
        :param pulumi.Input[str] nobuild_files_regex: Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        :param pulumi.Input[bool] noop_on_destroy: If set to `true`, the application version will not be deleted.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionReadinessCheckArgs']] readiness_check: Configures readiness health checking for instances. Unhealthy instances are not put into the backend traffic rotation.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionResourcesArgs']] resources: Machine resources for a version.
               Structure is documented below.
        :param pulumi.Input[str] runtime: Desired runtime. Example python27.
        :param pulumi.Input[str] runtime_api_version: The version of the API in the given runtime environment.
               Please see the app.yaml reference for valid values at `https://cloud.google.com/appengine/docs/standard/<language>/config/appref`\\
               Substitute `<language>` with `python`, `java`, `php`, `ruby`, `go` or `nodejs`.
        :param pulumi.Input[str] runtime_channel: The channel of the runtime to use. Only available for some runtimes.
        :param pulumi.Input[str] runtime_main_executable_path: The path or name of the app's main executable.
        :param pulumi.Input[str] service: AppEngine service resource. Can contain numbers, letters, and hyphens.
        :param pulumi.Input[str] service_account: The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
               default if this field is neither provided in app.yaml file nor through CLI flag.
        :param pulumi.Input[str] serving_status: Current serving status of this version. Only the versions with a SERVING status create instances and can be billed.
               Default value is `SERVING`.
               Possible values are: `SERVING`, `STOPPED`.
        :param pulumi.Input[str] version_id: Relative name of the version within the service. For example, `v1`. Version names can contain only lowercase letters, numbers, or hyphens.
               Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param pulumi.Input[pulumi.InputType['FlexibleAppVersionVpcAccessConnectorArgs']] vpc_access_connector: Enables VPC connectivity for standard apps.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlexibleAppVersionState.__new__(_FlexibleAppVersionState)

        __props__.__dict__["api_config"] = api_config
        __props__.__dict__["automatic_scaling"] = automatic_scaling
        __props__.__dict__["beta_settings"] = beta_settings
        __props__.__dict__["default_expiration"] = default_expiration
        __props__.__dict__["delete_service_on_destroy"] = delete_service_on_destroy
        __props__.__dict__["deployment"] = deployment
        __props__.__dict__["endpoints_api_service"] = endpoints_api_service
        __props__.__dict__["entrypoint"] = entrypoint
        __props__.__dict__["env_variables"] = env_variables
        __props__.__dict__["handlers"] = handlers
        __props__.__dict__["inbound_services"] = inbound_services
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["liveness_check"] = liveness_check
        __props__.__dict__["manual_scaling"] = manual_scaling
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["nobuild_files_regex"] = nobuild_files_regex
        __props__.__dict__["noop_on_destroy"] = noop_on_destroy
        __props__.__dict__["project"] = project
        __props__.__dict__["readiness_check"] = readiness_check
        __props__.__dict__["resources"] = resources
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["runtime_api_version"] = runtime_api_version
        __props__.__dict__["runtime_channel"] = runtime_channel
        __props__.__dict__["runtime_main_executable_path"] = runtime_main_executable_path
        __props__.__dict__["service"] = service
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["serving_status"] = serving_status
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["vpc_access_connector"] = vpc_access_connector
        return FlexibleAppVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiConfig")
    def api_config(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionApiConfig']]:
        """
        Serving configuration for Google Cloud Endpoints.
        Structure is documented below.
        """
        return pulumi.get(self, "api_config")

    @property
    @pulumi.getter(name="automaticScaling")
    def automatic_scaling(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionAutomaticScaling']]:
        """
        Automatic scaling is based on request rate, response latencies, and other application metrics.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_scaling")

    @property
    @pulumi.getter(name="betaSettings")
    def beta_settings(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Metadata settings that are supplied to this version to enable beta runtime features.
        """
        return pulumi.get(self, "beta_settings")

    @property
    @pulumi.getter(name="defaultExpiration")
    def default_expiration(self) -> pulumi.Output[Optional[str]]:
        """
        Duration that static files should be cached by web proxies and browsers.
        Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        """
        return pulumi.get(self, "default_expiration")

    @property
    @pulumi.getter(name="deleteServiceOnDestroy")
    def delete_service_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to `true`, the service will be deleted if it is the last version.
        """
        return pulumi.get(self, "delete_service_on_destroy")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionDeployment']]:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter(name="endpointsApiService")
    def endpoints_api_service(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionEndpointsApiService']]:
        """
        Code and application artifacts that make up this version.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints_api_service")

    @property
    @pulumi.getter
    def entrypoint(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionEntrypoint']]:
        """
        The entrypoint for the application.
        Structure is documented below.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Environment variables available to the application.  As these are not returned in the API request, the provider will not detect any changes made outside of the config.
        """
        return pulumi.get(self, "env_variables")

    @property
    @pulumi.getter
    def handlers(self) -> pulumi.Output[Sequence['outputs.FlexibleAppVersionHandler']]:
        """
        An ordered list of URL-matching patterns that should be applied to incoming requests.
        The first matching URL handles the request and other request handlers are not attempted.
        Structure is documented below.
        """
        return pulumi.get(self, "handlers")

    @property
    @pulumi.getter(name="inboundServices")
    def inbound_services(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of the types of messages that this application is able to receive.
        Each value may be one of: `INBOUND_SERVICE_MAIL`, `INBOUND_SERVICE_MAIL_BOUNCE`, `INBOUND_SERVICE_XMPP_ERROR`, `INBOUND_SERVICE_XMPP_MESSAGE`, `INBOUND_SERVICE_XMPP_SUBSCRIBE`, `INBOUND_SERVICE_XMPP_PRESENCE`, `INBOUND_SERVICE_CHANNEL_PRESENCE`, `INBOUND_SERVICE_WARMUP`.
        """
        return pulumi.get(self, "inbound_services")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[Optional[str]]:
        """
        Instance class that is used to run this version. Valid values are
        AutomaticScaling: F1, F2, F4, F4_1G
        ManualScaling: B1, B2, B4, B8, B4_1G
        Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="livenessCheck")
    def liveness_check(self) -> pulumi.Output['outputs.FlexibleAppVersionLivenessCheck']:
        """
        Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_check")

    @property
    @pulumi.getter(name="manualScaling")
    def manual_scaling(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionManualScaling']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "manual_scaling")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.

        (Required)
        Unique name for the volume.


        (Required)
        Endpoints service name which is the name of the "service" resource in the Service Management API.
        For example "myapi.endpoints.myproject.cloud.goog"

        (Required)
        Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionNetwork']]:
        """
        Extra network settings
        Structure is documented below.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nobuildFilesRegex")
    def nobuild_files_regex(self) -> pulumi.Output[Optional[str]]:
        """
        Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        """
        return pulumi.get(self, "nobuild_files_regex")

    @property
    @pulumi.getter(name="noopOnDestroy")
    def noop_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to `true`, the application version will not be deleted.
        """
        return pulumi.get(self, "noop_on_destroy")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="readinessCheck")
    def readiness_check(self) -> pulumi.Output['outputs.FlexibleAppVersionReadinessCheck']:
        """
        Configures readiness health checking for instances. Unhealthy instances are not put into the backend traffic rotation.
        Structure is documented below.
        """
        return pulumi.get(self, "readiness_check")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionResources']]:
        """
        Machine resources for a version.
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        Desired runtime. Example python27.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="runtimeApiVersion")
    def runtime_api_version(self) -> pulumi.Output[str]:
        """
        The version of the API in the given runtime environment.
        Please see the app.yaml reference for valid values at `https://cloud.google.com/appengine/docs/standard/<language>/config/appref`\\
        Substitute `<language>` with `python`, `java`, `php`, `ruby`, `go` or `nodejs`.
        """
        return pulumi.get(self, "runtime_api_version")

    @property
    @pulumi.getter(name="runtimeChannel")
    def runtime_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The channel of the runtime to use. Only available for some runtimes.
        """
        return pulumi.get(self, "runtime_channel")

    @property
    @pulumi.getter(name="runtimeMainExecutablePath")
    def runtime_main_executable_path(self) -> pulumi.Output[Optional[str]]:
        """
        The path or name of the app's main executable.
        """
        return pulumi.get(self, "runtime_main_executable_path")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        AppEngine service resource. Can contain numbers, letters, and hyphens.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[str]:
        """
        The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
        default if this field is neither provided in app.yaml file nor through CLI flag.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="servingStatus")
    def serving_status(self) -> pulumi.Output[Optional[str]]:
        """
        Current serving status of this version. Only the versions with a SERVING status create instances and can be billed.
        Default value is `SERVING`.
        Possible values are: `SERVING`, `STOPPED`.
        """
        return pulumi.get(self, "serving_status")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[Optional[str]]:
        """
        Relative name of the version within the service. For example, `v1`. Version names can contain only lowercase letters, numbers, or hyphens.
        Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="vpcAccessConnector")
    def vpc_access_connector(self) -> pulumi.Output[Optional['outputs.FlexibleAppVersionVpcAccessConnector']]:
        """
        Enables VPC connectivity for standard apps.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access_connector")

